/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia.logging;

public class Logger {
    public static final int OFF = Integer.MAX_VALUE;
    public static final int ERROR = 4;
    public static final int WARNING = 3;
    public static final int INFO = 2;
    public static final int DEBUG = 1;
    private static int currentLevel = Integer.MAX_VALUE;
    private static long startTime = 0L;
    private static final Object lock = new Object();

    private static void startLogger() {
        try {
            String level = System.getProperty("jfxmedia.loglevel", "off").toLowerCase();
            Integer logLevel = level.equals("debug") ? Integer.valueOf(1) : (level.equals("warning") ? Integer.valueOf(3) : (level.equals("error") ? Integer.valueOf(4) : (level.equals("info") ? Integer.valueOf(2) : Integer.valueOf(Integer.MAX_VALUE))));
            Logger.setLevel(logLevel);
            startTime = System.currentTimeMillis();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Logger.canLog(1)) {
            Logger.logMsg(1, "Logger initialized");
        }
    }

    private Logger() {
    }

    public static void initNative() {
        Logger.nativeInit();
        Logger.nativeSetNativeLevel(currentLevel);
    }

    private static native void nativeInit();

    public static void setLevel(int level) {
        currentLevel = level;
        try {
            Logger.nativeSetNativeLevel(level);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    private static native void nativeSetNativeLevel(int var0);

    public static boolean canLog(int level) {
        return level >= currentLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logMsg(int level, String msg) {
        Object object = lock;
        synchronized (object) {
            if (level < currentLevel) {
                return;
            }
            if (level == 4) {
                System.err.println("Error (" + Logger.getTimestamp() + "): " + msg);
            } else if (level == 3) {
                System.err.println("Warning (" + Logger.getTimestamp() + "): " + msg);
            } else if (level == 2) {
                System.out.println("Info (" + Logger.getTimestamp() + "): " + msg);
            } else if (level == 1) {
                System.out.println("Debug (" + Logger.getTimestamp() + "): " + msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logMsg(int level, String sourceClass, String sourceMethod, String msg) {
        Object object = lock;
        synchronized (object) {
            if (level < currentLevel) {
                return;
            }
            Logger.logMsg(level, sourceClass + ":" + sourceMethod + "() " + msg);
        }
    }

    private static String getTimestamp() {
        long elapsed = System.currentTimeMillis() - startTime;
        long elapsedHours = elapsed / 3600000L;
        long elapsedMinutes = (elapsed - elapsedHours * 60L * 60L * 1000L) / 60000L;
        long elapsedSeconds = (elapsed - elapsedHours * 60L * 60L * 1000L - elapsedMinutes * 60L * 1000L) / 1000L;
        long elapsedMillis = elapsed - elapsedHours * 60L * 60L * 1000L - elapsedMinutes * 60L * 1000L - elapsedSeconds * 1000L;
        return String.format("%d:%02d:%02d:%03d", elapsedHours, elapsedMinutes, elapsedSeconds, elapsedMillis);
    }

    static {
        Logger.startLogger();
    }
}

