/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.math.BigInteger;
import java.util.List;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.StrptimeParser;
import org.jruby.util.StrptimeToken;
import org.jruby.util.TimeZoneConverter;

public class RubyDateParser {
    public IRubyObject parse(ThreadContext context, RubyString format, RubyString text) {
        return this.parse(context, format.asJavaString(), text);
    }

    public IRubyObject parse(ThreadContext context, String format, RubyString text) {
        List<StrptimeToken> compiledPattern = context.runtime.getCachedStrptimePattern(format);
        StrptimeParser.FormatBag bag = new StrptimeParser().parse(compiledPattern, text.asJavaString());
        return bag == null ? context.nil : RubyDateParser.convertFormatBagToHash(context, bag, text.getEncoding(), text.isTaint());
    }

    static RubyHash convertFormatBagToHash(ThreadContext context, StrptimeParser.FormatBag bag, Encoding encoding2, boolean tainted) {
        Ruby runtime2 = context.runtime;
        RubyHash hash2 = RubyHash.newHash(runtime2);
        if (StrptimeParser.FormatBag.has(bag.getMDay())) {
            RubyDateParser.setHashValue(runtime2, hash2, "mday", runtime2.newFixnum(bag.getMDay()));
        }
        if (StrptimeParser.FormatBag.has(bag.getWDay())) {
            RubyDateParser.setHashValue(runtime2, hash2, "wday", runtime2.newFixnum(bag.getWDay()));
        }
        if (StrptimeParser.FormatBag.has(bag.getCWDay())) {
            RubyDateParser.setHashValue(runtime2, hash2, "cwday", runtime2.newFixnum(bag.getCWDay()));
        }
        if (StrptimeParser.FormatBag.has(bag.getYDay())) {
            RubyDateParser.setHashValue(runtime2, hash2, "yday", runtime2.newFixnum(bag.getYDay()));
        }
        if (StrptimeParser.FormatBag.has(bag.getCWeek())) {
            RubyDateParser.setHashValue(runtime2, hash2, "cweek", runtime2.newFixnum(bag.getCWeek()));
        }
        if (StrptimeParser.FormatBag.has(bag.getCWYear())) {
            RubyDateParser.setHashValue(runtime2, hash2, "cwyear", RubyBignum.newBignum(runtime2, bag.getCWYear()));
        }
        if (StrptimeParser.FormatBag.has(bag.getMin())) {
            RubyDateParser.setHashValue(runtime2, hash2, "min", runtime2.newFixnum(bag.getMin()));
        }
        if (StrptimeParser.FormatBag.has(bag.getMon())) {
            RubyDateParser.setHashValue(runtime2, hash2, "mon", runtime2.newFixnum(bag.getMon()));
        }
        if (StrptimeParser.FormatBag.has(bag.getHour())) {
            RubyDateParser.setHashValue(runtime2, hash2, "hour", runtime2.newFixnum(bag.getHour()));
        }
        if (StrptimeParser.FormatBag.has(bag.getYear())) {
            RubyDateParser.setHashValue(runtime2, hash2, "year", RubyBignum.newBignum(runtime2, bag.getYear()));
        }
        if (StrptimeParser.FormatBag.has(bag.getSec())) {
            RubyDateParser.setHashValue(runtime2, hash2, "sec", runtime2.newFixnum(bag.getSec()));
        }
        if (StrptimeParser.FormatBag.has(bag.getWNum0())) {
            RubyDateParser.setHashValue(runtime2, hash2, "wnum0", runtime2.newFixnum(bag.getWNum0()));
        }
        if (StrptimeParser.FormatBag.has(bag.getWNum1())) {
            RubyDateParser.setHashValue(runtime2, hash2, "wnum1", runtime2.newFixnum(bag.getWNum1()));
        }
        if (bag.getZone() != null) {
            RubyString zone2 = RubyString.newString(runtime2, bag.getZone(), encoding2);
            if (tainted) {
                zone2.taint(context);
            }
            RubyDateParser.setHashValue(runtime2, hash2, "zone", zone2);
            int offset2 = TimeZoneConverter.dateZoneToDiff(bag.getZone());
            if (offset2 != Integer.MIN_VALUE) {
                RubyDateParser.setHashValue(runtime2, hash2, "offset", runtime2.newFixnum(offset2));
            }
        }
        if (StrptimeParser.FormatBag.has(bag.getSecFraction())) {
            RubyInteger secFraction = RubyDateParser.toRubyInteger(runtime2, bag.getSecFraction());
            RubyFixnum secFractionSize = RubyFixnum.newFixnum(runtime2, (long)Math.pow(10.0, bag.getSecFractionSize()));
            RubyDateParser.setHashValue(runtime2, hash2, "sec_fraction", RubyRational.newRationalCanonicalize(context, secFraction, secFractionSize));
        }
        if (StrptimeParser.FormatBag.has(bag.getSeconds())) {
            if (StrptimeParser.FormatBag.has(bag.getSecondsSize())) {
                RubyInteger seconds = RubyDateParser.toRubyInteger(runtime2, bag.getSeconds());
                RubyFixnum secondsSize = RubyFixnum.newFixnum(runtime2, (long)Math.pow(10.0, bag.getSecondsSize()));
                RubyDateParser.setHashValue(runtime2, hash2, "seconds", RubyRational.newRationalCanonicalize(context, seconds, secondsSize));
            } else {
                RubyDateParser.setHashValue(runtime2, hash2, "seconds", RubyDateParser.toRubyInteger(runtime2, bag.getSeconds()));
            }
        }
        if (StrptimeParser.FormatBag.has(bag.getMerid())) {
            RubyDateParser.setHashValue(runtime2, hash2, "_merid", runtime2.newFixnum(bag.getMerid()));
        }
        if (StrptimeParser.FormatBag.has(bag.getCent())) {
            RubyDateParser.setHashValue(runtime2, hash2, "_cent", RubyBignum.newBignum(runtime2, bag.getCent()));
        }
        if (bag.getLeftover() != null) {
            RubyString leftover = RubyString.newString(runtime2, bag.getLeftover(), encoding2);
            if (tainted) {
                leftover.taint(context);
            }
            RubyDateParser.setHashValue(runtime2, hash2, "leftover", leftover);
        }
        return hash2;
    }

    private static RubyInteger toRubyInteger(Ruby runtime2, Number i2) {
        if (i2 instanceof BigInteger) {
            return RubyBignum.newBignum(runtime2, (BigInteger)i2);
        }
        return RubyFixnum.newFixnum(runtime2, i2.longValue());
    }

    private static void setHashValue(Ruby runtime2, RubyHash hash2, String key2, IRubyObject value2) {
        hash2.fastASet(RubySymbol.newSymbol(runtime2, key2), value2);
    }
}

