#ifndef _EFL_UI_SLIDER_INTERVAL_EO_H_
#define _EFL_UI_SLIDER_INTERVAL_EO_H_

#ifndef _EFL_UI_SLIDER_INTERVAL_EO_CLASS_TYPE
#define _EFL_UI_SLIDER_INTERVAL_EO_CLASS_TYPE

typedef Eo Efl_Ui_Slider_Interval;

#endif

#ifndef _EFL_UI_SLIDER_INTERVAL_EO_TYPES
#define _EFL_UI_SLIDER_INTERVAL_EO_TYPES


#endif
/**
 * @brief An interval slider.
 *
 * This is a slider with two indicators.
 *
 * @since 1.21
 *
 * @ingroup Efl_Ui_Slider_Interval
 */
#define EFL_UI_SLIDER_INTERVAL_CLASS efl_ui_slider_interval_class_get()

EWAPI const Efl_Class *efl_ui_slider_interval_class_get(void);

/**
 * @brief Sets up position of two indicators at start and end position.
 *
 * @param[in] obj The object.
 * @param[in] from interval minimum value
 * @param[in] to interval maximum value
 *
 * @since 1.21
 *
 * @ingroup Efl_Ui_Slider_Interval
 */
EOAPI void efl_ui_slider_interval_value_set(Eo *obj, double from, double to);

/**
 * @brief Sets up position of two indicators at start and end position.
 *
 * @param[in] obj The object.
 * @param[out] from interval minimum value
 * @param[out] to interval maximum value
 *
 * @since 1.21
 *
 * @ingroup Efl_Ui_Slider_Interval
 */
EOAPI void efl_ui_slider_interval_value_get(const Eo *obj, double *from, double *to);

#endif
