<?php
/**
 * @copyright Copyright (c) 2016, ownCloud, Inc.
 *
 * @author Andreas Fischer <bantu@owncloud.com>
 * @author Björn Schießle <bjoern@schiessle.org>
 * @author Lukas Reschke <lukas@statuscode.ch>
 * @author Morris Jobke <hey@morrisjobke.de>
 * @author Roeland Jago Douma <roeland@famdouma.nl>
 * @author Vincent Petry <pvince81@owncloud.com>
 *
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License, version 3,
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 *
 */

\OC_JSON::checkAppEnabled('files_versions');
\OC_JSON::checkLoggedIn();

$file = $_GET['file'];
$revision=(int)$_GET['revision'];

try {
	list($uid, $filename) = OCA\Files_Versions\Storage::getUidAndFilename($file);
} catch(\OCP\Files\NotFoundException $e) {
	http_response_code(404);
	$tmpl = new OCP\Template('', '404', 'guest');
	$tmpl->assign('file', '');
	$tmpl->printPage();
	exit();
}

$versionName = '/'.$uid.'/files_versions/'.$filename.'.v'.$revision;

$view = new OC\Files\View('/');

$ftype = \OC::$server->getMimeTypeDetector()->getSecureMimeType($view->getMimeType('/'.$uid.'/files/'.$filename));

header('Content-Type:'.$ftype);
\OC_Response::setContentDispositionHeader(basename($filename), 'attachment');
header('Pragma: public');// enable caching in IE
header('Expires: 0');
header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
\OC_Response::setContentLengthHeader($view->filesize($versionName));

OC_Util::obEnd();

$view->readfile($versionName);
