/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Buffer {
    public ByteBuffer b;
    public ByteBuffer _emptyBuffer;
    private int _size;
    private int _capacity;
    private boolean _direct;
    private int _shrinkCounter;
    private ByteOrder _order;

    public Buffer(boolean direct) {
        this(direct, ByteOrder.LITTLE_ENDIAN);
    }

    public Buffer(boolean direct, ByteOrder order) {
        this.b = this._emptyBuffer = ByteBuffer.allocate(0);
        this._size = 0;
        this._capacity = 0;
        this._direct = direct;
        this._order = order;
    }

    public Buffer(byte[] data) {
        this(data, ByteOrder.LITTLE_ENDIAN);
    }

    public Buffer(byte[] data, ByteOrder order) {
        this._emptyBuffer = ByteBuffer.allocate(0);
        this.b = ByteBuffer.wrap(data);
        this.b.order(order);
        this._size = data.length;
        this._capacity = 0;
        this._direct = false;
        this._order = order;
    }

    public Buffer(ByteBuffer data) {
        this(data, ByteOrder.LITTLE_ENDIAN);
    }

    public Buffer(ByteBuffer data, ByteOrder order) {
        this._emptyBuffer = ByteBuffer.allocate(0);
        this.b = data;
        this.b.order(order);
        this._size = data.remaining();
        this._capacity = 0;
        this._direct = false;
        this._order = order;
    }

    public Buffer(Buffer buf, boolean adopt) {
        this._emptyBuffer = ByteBuffer.allocate(0);
        this.b = buf.b;
        this._size = buf._size;
        this._capacity = buf._capacity;
        this._direct = buf._direct;
        this._shrinkCounter = buf._shrinkCounter;
        this._order = buf._order;
        if (adopt) {
            buf.clear();
        }
    }

    public java.nio.Buffer position(int newPosition) {
        return ((java.nio.Buffer)this.b).position(newPosition);
    }

    public java.nio.Buffer limit(int newLimit) {
        return ((java.nio.Buffer)this.b).limit(newLimit);
    }

    public java.nio.Buffer flip() {
        return ((java.nio.Buffer)this.b).flip();
    }

    public void swap(Buffer buf) {
        ByteBuffer bb = buf.b;
        int size = buf._size;
        int capacity = buf._capacity;
        boolean direct = buf._direct;
        int shrinkCounter = buf._shrinkCounter;
        ByteOrder order = buf._order;
        buf.b = this.b;
        buf._size = this._size;
        buf._capacity = this._capacity;
        buf._direct = this._direct;
        buf._shrinkCounter = this._shrinkCounter;
        buf._order = this._order;
        this.b = bb;
        this._size = size;
        this._capacity = capacity;
        this._direct = direct;
        this._shrinkCounter = shrinkCounter;
        this._order = order;
    }

    public int size() {
        return this._size;
    }

    public boolean empty() {
        return this._size == 0;
    }

    public void clear() {
        this.b = this._emptyBuffer;
        this._size = 0;
        this._capacity = 0;
        this._shrinkCounter = 0;
    }

    public void expand(int n) {
        int sz;
        int n2 = sz = this.b == this._emptyBuffer ? n : this.b.position() + n;
        if (sz > this._size) {
            this.resize(sz, false);
        }
    }

    public void resize(int n, boolean reading) {
        assert (this.b == this._emptyBuffer || this._capacity > 0);
        if (n == 0) {
            this.clear();
        } else if (n > this._capacity) {
            this.reserve(n);
        }
        this._size = n;
        if (reading) {
            this.limit(this._size);
        }
    }

    public void reset() {
        if (this._size > 0 && this._size * 2 < this._capacity) {
            if (++this._shrinkCounter > 2) {
                this.reserve(this._size);
                this._shrinkCounter = 0;
            }
        } else {
            this._shrinkCounter = 0;
        }
        this._size = 0;
        if (this.b != this._emptyBuffer) {
            this.limit(this.b.capacity());
            this.position(0);
        }
    }

    private void reserve(int n) {
        if (n > this._capacity) {
            this._capacity = Math.max(n, 2 * this._capacity);
            this._capacity = Math.max(240, this._capacity);
        } else if (n < this._capacity) {
            this._capacity = n;
        } else {
            return;
        }
        try {
            ByteBuffer buf = this._direct ? ByteBuffer.allocateDirect(this._capacity) : ByteBuffer.allocate(this._capacity);
            if (this.b == this._emptyBuffer) {
                this.b = buf;
            } else {
                int pos = this.b.position();
                this.position(0);
                this.limit(Math.min(this._capacity, this.b.capacity()));
                buf.put(this.b);
                this.b = buf;
                this.limit(this.b.capacity());
                this.position(pos);
            }
            this.b.order(this._order);
        }
        catch (OutOfMemoryError ex) {
            this._capacity = this.b.capacity();
            throw ex;
        }
    }
}

