import defs = require("raml-definition-system");
import hl = require("./highLevelAST");
import ll = require("./lowLevelAST");
import def = defs;
import ParserCore = require("./wrapped-ast/parserCore");
import jsonSerializerHL = require("../util/jsonSerializerHL");
import rTypes = defs.rt;
import contentprovider = require('../util/contentprovider');
export declare function qName(x: hl.IHighLevelNode, context: hl.IHighLevelNode): string;
export declare class BasicASTNode implements hl.IParseResult {
    protected _node: ll.ILowLevelASTNode;
    private _parent;
    private _hashkey;
    unitMap: {
        [path: string]: string;
    };
    private static CLASS_IDENTIFIER;
    protected _reuseMode: boolean;
    protected _isReused: boolean;
    protected _jsonCache: any;
    protected _valueSource: hl.IParseResult;
    static isInstance(instance: any): instance is BasicASTNode;
    getClassIdentifier(): string[];
    getKind(): hl.NodeKind;
    asAttr(): hl.IAttribute;
    asElement(): hl.IHighLevelNode;
    hashkey(): string;
    root(): hl.IHighLevelNode;
    version(): string;
    getLowLevelStart(): number;
    getLowLevelEnd(): number;
    private _implicit;
    private values;
    _computed: boolean;
    constructor(_node: ll.ILowLevelASTNode, _parent: hl.IHighLevelNode);
    knownProperty: hl.IProperty;
    needSequence: boolean;
    needMap: boolean;
    invalidSequence: boolean;
    unresolvedRef: string;
    errorMessage: {
        entry: any;
        parameters: any;
    };
    isSameNode(n: hl.IParseResult): boolean;
    checkContextValue(name: string, value: string, thisObj: any): boolean;
    printDetails(indent?: string): string;
    /**
     * Used for test comparison of two trees. Touching this will require AST tests update.
     * @param indent
     * @returns {string}
     */
    testSerialize(indent?: string): string;
    errors(): hl.ValidationIssue[];
    markCh(): boolean;
    unmarkCh(): void;
    validate(v: hl.ValidationAcceptor): void;
    allowRecursive(): boolean;
    setComputed(name: string, v: any): void;
    setValueSource(n: hl.IParseResult): void;
    computedValue(name: string): any;
    lowLevel(): ll.ILowLevelASTNode;
    name(): string;
    optional(): boolean;
    parent(): hl.IHighLevelNode;
    setParent(parent: hl.IHighLevelNode): void;
    isElement(): boolean;
    directChildren(): hl.IParseResult[];
    children(): hl.IParseResult[];
    isAttached(): boolean;
    isImplicit(): boolean;
    isAttr(): boolean;
    isUnknown(): boolean;
    id(): string;
    localId(): string;
    cachedId: string;
    cachedFullId: string;
    resetIDs(): void;
    fullLocalId(): string;
    property(): hl.IProperty;
    reuseMode(): boolean;
    setReuseMode(val: boolean): void;
    isReused(): boolean;
    setReused(val: boolean): void;
    setJSON(val: any): void;
    getJSON(): any;
}
export declare class StructuredValue implements hl.IStructuredValue {
    private node;
    private _parent;
    private kv;
    private _pr;
    private static CLASS_IDENTIFIER;
    static isInstance(instance: any): instance is StructuredValue;
    getClassIdentifier(): string[];
    constructor(node: ll.ILowLevelASTNode, _parent: hl.IHighLevelNode, _pr: hl.IProperty, kv?: any);
    valueName(): string;
    children(): StructuredValue[];
    lowLevel(): ll.ILowLevelASTNode;
    private _hl;
    toHighLevel(parent?: hl.IHighLevelNode): hl.IHighLevelNode;
    toHighLevel2(parent?: hl.IHighLevelNode): hl.IHighLevelNode;
    resetHighLevelNode(): void;
}
/**
 * Instanceof for StructuredValue class
 * @param node
 * @returns
 */
export declare function isStructuredValue(node: any): node is StructuredValue;
export declare class ASTPropImpl extends BasicASTNode implements hl.IAttribute {
    private _def;
    private _prop;
    private fromKey;
    private static CLASS_IDENTIFIER_ASTPropImpl;
    static isInstance(instance: any): instance is ASTPropImpl;
    getClassIdentifier(): string[];
    definition(): hl.IValueTypeDefinition;
    asAttr(): hl.IAttribute;
    errors(): hl.ValidationIssue[];
    isString(): boolean;
    isAnnotatedScalar(): boolean;
    annotations(): hl.IAttribute[];
    constructor(node: ll.ILowLevelASTNode, parent: hl.IHighLevelNode, _def: hl.IValueTypeDefinition, _prop: hl.IProperty, fromKey?: boolean);
    getKind(): hl.NodeKind;
    owningWrapper(): {
        node: ParserCore.BasicNode;
        property: string;
    };
    patchType(t: hl.IValueTypeDefinition): void;
    findReferenceDeclaration(): hl.IHighLevelNode;
    findReferencedValue(): any;
    isElement(): boolean;
    property(): defs.Property;
    convertMultivalueToString(value: string): string;
    _value: string;
    overrideValue(value: string): void;
    private _sval;
    value(): any;
    plainValue(): any;
    private calcValue();
    name(): string;
    printDetails(indent?: string): string;
    /**
     * Used for test comparison of two trees. Touching this will require AST tests update.
     * @param indent
     * @returns {string}
     */
    testSerialize(indent?: string): string;
    isAttr(): boolean;
    isUnknown(): boolean;
    setValue(value: string | StructuredValue): void;
    setKey(value: string): void;
    children(): hl.IParseResult[];
    addStringValue(value: string): void;
    addStructuredValue(sv: StructuredValue): void;
    addValue(value: string | StructuredValue): void;
    isEmbedded(): boolean;
    remove(): void;
    setValues(values: string[]): void;
    isEmpty(): boolean;
    isFromKey(): boolean;
}
/**
 * Instanceof for ASTPropImpl class
 * @param node
 * @returns
 */
export declare function isASTPropImpl(node: any): node is ASTPropImpl;
export declare enum OverlayMergeMode {
    MERGE = 0,
    AGGREGATE = 1,
}
export interface ParseNode {
    path(): string;
    key(): string;
    value(): any;
    children(): ParseNode[];
    childWithKey(k: string): ParseNode;
    kind(): number;
    getMeta(key: string): any;
    addMeta(key: string, value: any): any;
}
export declare class LowLevelWrapperForTypeSystem extends defs.SourceProvider implements ParseNode {
    protected _node: ll.ILowLevelASTNode;
    protected _highLevelRoot: hl.IHighLevelNode;
    private _toMerge;
    private static CLASS_IDENTIFIER_LowLevelWrapperForTypeSystem;
    static isInstance(instance: any): instance is LowLevelWrapperForTypeSystem;
    getClassIdentifier(): string[];
    constructor(_node: ll.ILowLevelASTNode, _highLevelRoot: hl.IHighLevelNode);
    private ownMeta;
    contentProvider(): contentprovider.ContentProvider;
    path(): string;
    key(): string;
    value(): any;
    _children: LowLevelWrapperForTypeSystem[];
    childByKey: {
        [key: string]: LowLevelWrapperForTypeSystem;
    };
    children(): LowLevelWrapperForTypeSystem[];
    childWithKey(k: string): ParseNode;
    kind(): defs.rt.NodeKind;
    getSource(): any;
    node(): ll.ILowLevelASTNode;
    getMeta(key: string): any;
    addMeta(key: string, value: any): void;
}
export declare class UsesNodeWrapperFoTypeSystem extends LowLevelWrapperForTypeSystem {
    children(): LowLevelWrapperForTypeSystem[];
    path(): string;
    anchor(): any;
    childWithKey(k: string): ParseNode;
}
export declare function auxiliaryTypeForExample(node: hl.IHighLevelNode): defs.rt.nominalInterfaces.ITypeDefinition;
export declare class ASTNodeImpl extends BasicASTNode implements hl.IEditableHighLevelNode {
    private _def;
    private _prop;
    private _types;
    private _ptype;
    private static CLASS_IDENTIFIER_ASTNodeImpl;
    static isInstance(instance: any): instance is ASTNodeImpl;
    getClassIdentifier(): string[];
    createIssue(error: any): hl.ValidationIssue;
    validate(v: hl.ValidationAcceptor): void;
    clearTypesCache(): void;
    types(): rTypes.IParsedTypeCollection;
    setTypes(t: rTypes.IParsedTypeCollection): void;
    parsedType(): rTypes.IParsedType;
    private isParametrizedType();
    localType(): hl.ITypeDefinition;
    private _expanded;
    _children: hl.IParseResult[];
    _allowQuestion: boolean;
    _associatedDef: hl.INodeDefinition;
    _subTypesCache: {
        [name: string]: hl.ITypeDefinition[];
    };
    private _wrapperNode;
    private _isAux;
    private _auxChecked;
    private _knownIds;
    private _slaveIds;
    private _knownLowLevelIds;
    isInEdit: boolean;
    /**
     * Externally set master AST, should be only available for root nodes,
     * and only in the case when we merge multiple overlays/extensions.
     */
    private masterApi;
    /**
     * Depending on the merge mode, overlays and extensions are either merged with the master, or their trees are joined via aggregation
     * @type {OverlayMergeMode}
     */
    private overlayMergeMode;
    /**
     * Slave of this master, if there is any
     */
    private slave;
    private _reusedNode;
    constructor(node: ll.ILowLevelASTNode, parent: hl.IHighLevelNode, _def: hl.INodeDefinition, _prop: hl.IProperty);
    _computedKey: string;
    patchProp(pr: hl.IProperty): void;
    getKind(): hl.NodeKind;
    wrapperNode(): ParserCore.BasicNode;
    asElement(): hl.IHighLevelNode;
    private buildWrapperNode();
    propertiesAllowedToUse(): hl.IProperty[];
    isAllowedToUse(p: hl.IProperty): boolean;
    allowRecursive(): boolean;
    setWrapperNode(node: ParserCore.BasicNode): void;
    setAssociatedType(d: hl.INodeDefinition): void;
    associatedType(): hl.INodeDefinition;
    knownIds(): {
        [name: string]: hl.IParseResult;
    };
    findById(id: string): any;
    isAuxilary(): boolean;
    private initilizeKnownIDs(api);
    getMaster(): hl.IParseResult;
    /**
     * Forcefully sets a master unit for this API, which may be different from the one, current unit points to
     * via masterRef.
     * @param master
     */
    overrideMaster(master: hl.IParseResult): void;
    setSlave(slave: hl.IParseResult): void;
    setMergeMode(mergeMode: OverlayMergeMode): void;
    getMergeMode(): OverlayMergeMode;
    private calculateMasterByRef();
    private resetAuxilaryState();
    printDetails(indent?: string): string;
    /**
     * Used for test comparison of two trees. Touching this will require AST tests update.
     * @param indent
     * @returns {string}
     */
    testSerialize(indent?: string): string;
    private getExtractedChildren();
    getMasterCounterPart(): hl.IHighLevelNode;
    /**
     * Finds slave counterpart of this node.
     * @returns {any}
     */
    getSlaveCounterPart(): hl.IHighLevelNode;
    /**
     * Finds the slave counterpart of this node. If this slave has another slave in turn, recursivelly,
     * returns the last slave in the dependency sequence.
     */
    getLastSlaveCounterPart(): hl.IHighLevelNode;
    private getExtractedLowLevelChildren(n);
    allowsQuestion(): boolean;
    findReferences(): hl.IParseResult[];
    private _patchedName;
    setNamePatch(s: string): void;
    isNamePatch(): string;
    name(): any;
    findElementAtOffset(n: number): hl.IHighLevelNode;
    isElement(): boolean;
    private _universe;
    universe(): defs.Universe;
    setUniverse(u: defs.Universe): void;
    private _findNode(n, offset, end);
    isStub(): boolean;
    add(node: hl.IHighLevelNode | hl.IAttribute): void;
    remove(node: hl.IHighLevelNode | hl.IAttribute): void;
    dump(flavor: string): string;
    patchType(d: hl.INodeDefinition): void;
    _mergedChildren: hl.IParseResult[];
    children(): hl.IParseResult[];
    private mergeChildren(originalChildren, masterChildren);
    private mergeLowLevelChildren(originalChildren, masterChildren);
    private mergeLowLevelChild(result, originalChild, masterChild);
    private mergeChild(result, originalChild, masterChild);
    directChildren(): hl.IParseResult[];
    resetChildren(): void;
    isEmptyRamlFile(): boolean;
    initRamlFile(): void;
    createAttr(n: string, v: string): void;
    isAttr(): boolean;
    isUnknown(): boolean;
    value(): any;
    valuesOf(propName: string): hl.IHighLevelNode[];
    attr(n: string): hl.IAttribute;
    attrOrCreate(name: string): hl.IAttribute;
    attrValue(n: string): string;
    attributes(n: string): hl.IAttribute[];
    attrs(): hl.IAttribute[];
    elements(): hl.IHighLevelNode[];
    element(n: string): hl.IHighLevelNode;
    elementsOfKind(n: string): hl.IHighLevelNode[];
    definition(): hl.INodeDefinition;
    property(): hl.IProperty;
    isExpanded(): boolean;
    copy(): ASTNodeImpl;
    clearChildrenCache(): void;
    optionalProperties(): string[];
    setReuseMode(val: boolean): void;
    reusedNode(): hl.IHighLevelNode;
    setReusedNode(n: hl.IHighLevelNode): void;
    resetRuntimeTypes(): void;
    /**
     * Turns high level model node into an object.
     * @param options serialization options
     * @return Stringifyable object representation of the node.
     **/
    toJSON(options: jsonSerializerHL.SerializeOptions): any;
}
export declare var universeProvider: any;
export declare function ramlFirstLine(content: string): RegExpMatchArray;
export declare function getFragmentDefenitionName(highLevelNode: hl.IHighLevelNode): string;
export declare function fromUnit(l: ll.ICompilationUnit): hl.IParseResult;
/**
 * Creates basic acceptor.
 * If primaryUnitPointerNode is provided, creates PointOfViewValidationAcceptor
 * instance with primary unit taken from the node.
 * @param errors
 * @param primaryUnitPointerNode
 * @returns {hl.ValidationAcceptor}
 */
export declare function createBasicValidationAcceptor(errors: hl.ValidationIssue[], primaryUnitPointerNode?: hl.IParseResult): hl.ValidationAcceptor;
export declare function isAnnotationTypeFragment(node: hl.IHighLevelNode): boolean;
export declare class AnnotatedNode implements def.rt.tsInterfaces.IAnnotatedElement {
    protected _node: hl.IParseResult;
    constructor(_node: hl.IParseResult);
    private _annotations;
    private _annotationsMap;
    kind(): string;
    annotationsMap(): {
        [key: string]: def.rt.tsInterfaces.IAnnotationInstance;
    };
    annotations(): def.rt.tsInterfaces.IAnnotationInstance[];
    value(): any;
    name(): string;
    entry(): hl.IParseResult;
}
export declare class AnnotationInstance implements def.rt.tsInterfaces.IAnnotationInstance {
    protected attr: hl.IAttribute;
    constructor(attr: hl.IAttribute);
    name(): string;
    /**
     * Annotation value
     */
    value(): any;
    /**
     * Annotation definition type
     */
    definition(): def.rt.tsInterfaces.IParsedType;
}
/**
 * Apply registered node validation plugins to the type
 * @param node node to be validated
 * @returns an array of {NodeValidationPluginIssue}
 */
export declare function applyNodeValidationPlugins(node: hl.IParseResult): hl.ValidationIssue[];
/**
 * Apply registered node annotation validation plugins to the type
 * @param node node to be validated
 * @returns an array of {NodeValidationPluginIssue}
 */
export declare function applyNodeAnnotationValidationPlugins(node: hl.IParseResult): hl.ValidationIssue[];
export declare function toParserErrors(issues: hl.ValidationIssue[], node: hl.IHighLevelNode): hl.RamlParserError[];
export declare function actualPath(node: hl.IParseResult, checkIfDifferent?: boolean): string;
export declare function actualUnit(llNode: ll.ILowLevelASTNode): ll.ICompilationUnit;
export declare function resolveSchemaFragment(node: hl.IParseResult, value: string): string;
