/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.storage.reftree.AlwaysFailUpdate;
import org.eclipse.jgit.internal.storage.reftree.RefTreeBatch;
import org.eclipse.jgit.internal.storage.reftree.RefTreeRename;
import org.eclipse.jgit.internal.storage.reftree.RefTreeUpdate;
import org.eclipse.jgit.internal.storage.reftree.Scanner;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.RefList;
import org.eclipse.jgit.util.RefMap;

public class RefTreeDatabase
extends RefDatabase {
    private final Repository repo;
    private final RefDatabase bootstrap;
    private final String txnCommitted;
    @Nullable
    private final String txnNamespace;
    private volatile Scanner.Result refs;

    public RefTreeDatabase(Repository repo, RefDatabase bootstrap) {
        StoredConfig cfg = repo.getConfig();
        String committed = cfg.getString("reftree", null, "committedRef");
        if (committed == null || committed.isEmpty()) {
            committed = "refs/txn/committed";
        }
        this.repo = repo;
        this.bootstrap = bootstrap;
        this.txnNamespace = RefTreeDatabase.initNamespace(committed);
        this.txnCommitted = committed;
    }

    public RefTreeDatabase(Repository repo, RefDatabase bootstrap, String txnCommitted) {
        this.repo = repo;
        this.bootstrap = bootstrap;
        this.txnNamespace = RefTreeDatabase.initNamespace(txnCommitted);
        this.txnCommitted = txnCommitted;
    }

    private static String initNamespace(String committed) {
        int s = committed.lastIndexOf(47);
        if (s < 0) {
            return null;
        }
        return committed.substring(0, s + 1);
    }

    Repository getRepository() {
        return this.repo;
    }

    public RefDatabase getBootstrap() {
        return this.bootstrap;
    }

    public String getTxnCommitted() {
        return this.txnCommitted;
    }

    @Nullable
    public String getTxnNamespace() {
        return this.txnNamespace;
    }

    @Override
    public void create() throws IOException {
        this.bootstrap.create();
    }

    @Override
    public boolean performsAtomicTransactions() {
        return true;
    }

    @Override
    public void refresh() {
        this.bootstrap.refresh();
    }

    @Override
    public void close() {
        this.refs = null;
        this.bootstrap.close();
    }

    @Override
    public Ref getRef(String name2) throws IOException {
        String[] needle = new String[SEARCH_PATH.length];
        for (int i = 0; i < SEARCH_PATH.length; ++i) {
            needle[i] = SEARCH_PATH[i] + name2;
        }
        return this.firstExactRef(needle);
    }

    @Override
    public Ref exactRef(String name2) throws IOException {
        Ref r;
        if (!this.repo.isBare() && name2.indexOf(47) < 0 && !"HEAD".equals(name2)) {
            return this.bootstrap.exactRef(name2);
        }
        if (this.conflictsWithBootstrap(name2)) {
            return null;
        }
        boolean partial2 = false;
        Ref src = this.bootstrap.exactRef(this.txnCommitted);
        Scanner.Result c = this.refs;
        if (c == null || !c.refTreeId.equals(RefTreeDatabase.idOf(src))) {
            c = Scanner.scanRefTree(this.repo, src, RefTreeDatabase.prefixOf(name2), false);
            partial2 = true;
        }
        if ((r = c.all.get(name2)) != null && r.isSymbolic()) {
            r = c.sym.get(name2);
            if (partial2 && r.getObjectId() == null) {
                return this.getRefs("").get(name2);
            }
        }
        return r;
    }

    private static String prefixOf(String name2) {
        int s = name2.lastIndexOf(47);
        if (s >= 0) {
            return name2.substring(0, s);
        }
        return "";
    }

    @Override
    public Map<String, Ref> getRefs(String prefix) throws IOException {
        if (!prefix.isEmpty() && prefix.charAt(prefix.length() - 1) != '/') {
            return new HashMap<String, Ref>(0);
        }
        Ref src = this.bootstrap.exactRef(this.txnCommitted);
        Scanner.Result c = this.refs;
        if (c == null || !c.refTreeId.equals(RefTreeDatabase.idOf(src))) {
            c = Scanner.scanRefTree(this.repo, src, prefix, true);
            if (prefix.isEmpty()) {
                this.refs = c;
            }
        }
        return new RefMap(prefix, RefList.emptyList(), c.all, c.sym);
    }

    private static ObjectId idOf(@Nullable Ref src) {
        return src != null && src.getObjectId() != null ? src.getObjectId() : ObjectId.zeroId();
    }

    @Override
    public List<Ref> getAdditionalRefs() throws IOException {
        Ref r;
        Collection<Ref> txnRefs = this.txnNamespace != null ? this.bootstrap.getRefs(this.txnNamespace).values() : ((r = this.bootstrap.exactRef(this.txnCommitted)) != null && r.getObjectId() != null ? Collections.singleton(r) : Collections.emptyList());
        List<Ref> otherRefs = this.bootstrap.getAdditionalRefs();
        ArrayList<Ref> all = new ArrayList<Ref>(txnRefs.size() + otherRefs.size());
        all.addAll(txnRefs);
        all.addAll(otherRefs);
        return all;
    }

    @Override
    public Ref peel(Ref ref2) throws IOException {
        Ref i = ref2.getLeaf();
        ObjectId id = i.getObjectId();
        if (i.isPeeled() || id == null) {
            return ref2;
        }
        try (RevWalk rw = new RevWalk(this.repo);){
            RevObject obj = rw.parseAny(id);
            if (obj instanceof RevTag) {
                ObjectId p = rw.peel(obj).copy();
                i = new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, i.getName(), id, p);
            } else {
                i = new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, i.getName(), id);
            }
        }
        return RefTreeDatabase.recreate(ref2, i);
    }

    private static Ref recreate(Ref old, Ref leaf) {
        if (old.isSymbolic()) {
            Ref dst = RefTreeDatabase.recreate(old.getTarget(), leaf);
            return new SymbolicRef(old.getName(), dst);
        }
        return leaf;
    }

    @Override
    public boolean isNameConflicting(String name2) throws IOException {
        return this.conflictsWithBootstrap(name2) || !this.getConflictingNames(name2).isEmpty();
    }

    @Override
    public BatchRefUpdate newBatchUpdate() {
        return new RefTreeBatch(this);
    }

    @Override
    public RefUpdate newUpdate(String name2, boolean detach) throws IOException {
        boolean detaching;
        if (!this.repo.isBare() && name2.indexOf(47) < 0 && !"HEAD".equals(name2)) {
            return this.bootstrap.newUpdate(name2, detach);
        }
        if (this.conflictsWithBootstrap(name2)) {
            return new AlwaysFailUpdate(this, name2);
        }
        Ref r = this.exactRef(name2);
        if (r == null) {
            r = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, name2, null);
        }
        boolean bl = detaching = detach && r.isSymbolic();
        if (detaching) {
            r = new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, name2, r.getObjectId());
        }
        RefTreeUpdate u = new RefTreeUpdate(this, r);
        if (detaching) {
            u.setDetachingSymbolicRef();
        }
        return u;
    }

    @Override
    public RefRename newRename(String fromName, String toName) throws IOException {
        RefUpdate from = this.newUpdate(fromName, true);
        RefUpdate to = this.newUpdate(toName, true);
        return new RefTreeRename(this, from, to);
    }

    boolean conflictsWithBootstrap(String name2) {
        if (this.txnNamespace != null && name2.startsWith(this.txnNamespace)) {
            return true;
        }
        if (this.txnCommitted.equals(name2)) {
            return true;
        }
        if (name2.indexOf(47) < 0 && !"HEAD".equals(name2)) {
            return true;
        }
        return name2.length() > this.txnCommitted.length() && name2.charAt(this.txnCommitted.length()) == '/' && name2.startsWith(this.txnCommitted);
    }
}

