/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.xpack.sql.expression.Expression;

public class ExpressionSet<E extends Expression>
implements Set<E> {
    public static final ExpressionSet EMPTY = new ExpressionSet(Collections.emptyList());
    private final Map<Expression, E> map = new LinkedHashMap<Expression, E>();

    public static <T extends Expression> ExpressionSet<T> emptySet() {
        return EMPTY;
    }

    public ExpressionSet() {
    }

    public ExpressionSet(Collection<? extends E> c) {
        this.addAll(c);
    }

    public E get(Expression e) {
        return (E)((Expression)this.map.get(e.canonical()));
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Expression) {
            return this.map.containsKey(((Expression)o).canonical());
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public boolean add(E e) {
        return this.map.putIfAbsent(((Expression)e).canonical(), e) == null;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = true;
        for (Expression o : c) {
            result &= this.add((E)o);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<Expression> keys = this.map.keySet().iterator();
        while (keys.hasNext()) {
            Expression key = keys.next();
            boolean found = false;
            for (Object o : c) {
                if (o instanceof Expression) {
                    o = ((Expression)o).canonical();
                }
                if (!key.equals(o)) continue;
                found = true;
                break;
            }
            if (found) continue;
            keys.remove();
        }
        return modified;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Expression) {
            return this.map.remove(((Expression)o).canonical()) != null;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            modified |= this.remove(o);
        }
        return modified;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Object[] toArray() {
        return this.map.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.values().toArray(a);
    }

    public String toString() {
        return this.map.toString();
    }
}

