/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.temporal.ChronoField;
import java.util.TimeZone;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeProcessor;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public class DayOfYear
extends DateTimeFunction {
    public DayOfYear(Location location, Expression field, TimeZone timeZone) {
        super(location, field, timeZone);
    }

    @Override
    protected NodeInfo.NodeCtor2<Expression, TimeZone, DateTimeFunction> ctorForInfo() {
        return DayOfYear::new;
    }

    @Override
    protected UnaryScalarFunction replaceChild(Expression newChild) {
        return new DayOfYear(this.location(), newChild, this.timeZone());
    }

    @Override
    public String dateTimeFormat() {
        return "D";
    }

    @Override
    protected ChronoField chronoField() {
        return ChronoField.DAY_OF_YEAR;
    }

    @Override
    protected DateTimeProcessor.DateTimeExtractor extractor() {
        return DateTimeProcessor.DateTimeExtractor.DAY_OF_YEAR;
    }
}

