/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestStatus;

class PostStartBasicResponse
extends AcknowledgedResponse {
    private Map<String, String[]> acknowledgeMessages;
    private String acknowledgeMessage;
    private Status status;

    PostStartBasicResponse() {
    }

    PostStartBasicResponse(Status status) {
        this(status, Collections.emptyMap(), null);
    }

    PostStartBasicResponse(Status status, Map<String, String[]> acknowledgeMessages, String acknowledgeMessage) {
        super(status != Status.NEED_ACKNOWLEDGEMENT);
        this.status = status;
        this.acknowledgeMessages = acknowledgeMessages;
        this.acknowledgeMessage = acknowledgeMessage;
    }

    public Status getStatus() {
        return this.status;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.status = (Status)in.readEnum(Status.class);
        this.acknowledgeMessage = in.readOptionalString();
        int size = in.readVInt();
        HashMap<String, String[]> acknowledgeMessages = new HashMap<String, String[]>(size);
        for (int i = 0; i < size; ++i) {
            String feature = in.readString();
            int nMessages = in.readVInt();
            String[] messages = new String[nMessages];
            for (int j = 0; j < nMessages; ++j) {
                messages[j] = in.readString();
            }
            acknowledgeMessages.put(feature, messages);
        }
        this.acknowledgeMessages = acknowledgeMessages;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeEnum((Enum)this.status);
        out.writeOptionalString(this.acknowledgeMessage);
        out.writeVInt(this.acknowledgeMessages.size());
        for (Map.Entry<String, String[]> entry : this.acknowledgeMessages.entrySet()) {
            out.writeString(entry.getKey());
            out.writeVInt(entry.getValue().length);
            for (String message : entry.getValue()) {
                out.writeString(message);
            }
        }
    }

    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.status.isBasicStarted()) {
            builder.field("basic_was_started", true);
        } else {
            builder.field("basic_was_started", false);
            builder.field("error_message", this.status.getErrorMessage());
        }
        if (!this.acknowledgeMessages.isEmpty()) {
            builder.startObject("acknowledge");
            builder.field("message", this.acknowledgeMessage);
            for (Map.Entry<String, String[]> entry : this.acknowledgeMessages.entrySet()) {
                builder.startArray(entry.getKey());
                for (String message : entry.getValue()) {
                    builder.value(message);
                }
                builder.endArray();
            }
            builder.endObject();
        }
    }

    static enum Status {
        GENERATED_BASIC(true, null, RestStatus.OK),
        ALREADY_USING_BASIC(false, "Operation failed: Current license is basic.", RestStatus.FORBIDDEN),
        NEED_ACKNOWLEDGEMENT(false, "Operation failed: Needs acknowledgement.", RestStatus.OK);

        private final boolean isBasicStarted;
        private final String errorMessage;
        private final RestStatus restStatus;

        private Status(boolean isBasicStarted, String errorMessage, RestStatus restStatus) {
            this.isBasicStarted = isBasicStarted;
            this.errorMessage = errorMessage;
            this.restStatus = restStatus;
        }

        boolean isBasicStarted() {
            return this.isBasicStarted;
        }

        String getErrorMessage() {
            return this.errorMessage;
        }

        RestStatus getRestStatus() {
            return this.restStatus;
        }
    }
}

