/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.token;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.xpack.core.security.authc.support.CharArrays;

public final class CreateTokenRequest
extends ActionRequest {
    private String grantType;
    private String username;
    private SecureString password;
    private String scope;
    private String refreshToken;

    public CreateTokenRequest() {
    }

    public CreateTokenRequest(String grantType, @Nullable String username, @Nullable SecureString password, @Nullable String scope, @Nullable String refreshToken) {
        this.grantType = grantType;
        this.username = username;
        this.password = password;
        this.scope = scope;
        this.refreshToken = refreshToken;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if ("password".equals(this.grantType)) {
            if (Strings.isNullOrEmpty((String)this.username)) {
                validationException = ValidateActions.addValidationError((String)"username is missing", validationException);
            }
            if (this.password == null || this.password.getChars() == null || this.password.getChars().length == 0) {
                validationException = ValidateActions.addValidationError((String)"password is missing", (ActionRequestValidationException)validationException);
            }
            if (this.refreshToken != null) {
                validationException = ValidateActions.addValidationError((String)"refresh_token is not supported with the password grant_type", (ActionRequestValidationException)validationException);
            }
        } else if ("refresh_token".equals(this.grantType)) {
            if (this.username != null) {
                validationException = ValidateActions.addValidationError((String)"username is not supported with the refresh_token grant_type", (ActionRequestValidationException)validationException);
            }
            if (this.password != null) {
                validationException = ValidateActions.addValidationError((String)"password is not supported with the refresh_token grant_type", (ActionRequestValidationException)validationException);
            }
            if (this.refreshToken == null) {
                validationException = ValidateActions.addValidationError((String)"refresh_token is missing", (ActionRequestValidationException)validationException);
            }
        } else {
            validationException = ValidateActions.addValidationError((String)"grant_type only supports the values: [password, refresh_token]", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    public void setPassword(@Nullable SecureString password) {
        this.password = password;
    }

    public void setScope(@Nullable String scope) {
        this.scope = scope;
    }

    public void setRefreshToken(@Nullable String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getGrantType() {
        return this.grantType;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public SecureString getPassword() {
        return this.password;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Nullable
    public String getRefreshToken() {
        return this.refreshToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.grantType);
        if (out.getVersion().onOrAfter(Version.V_6_2_0)) {
            out.writeOptionalString(this.username);
            if (this.password == null) {
                out.writeOptionalBytesReference(null);
            } else {
                byte[] passwordBytes = CharArrays.toUtf8Bytes(this.password.getChars());
                try {
                    out.writeOptionalBytesReference((BytesReference)new BytesArray(passwordBytes));
                }
                finally {
                    Arrays.fill(passwordBytes, (byte)0);
                }
            }
            out.writeOptionalString(this.refreshToken);
        } else {
            if ("refresh_token".equals(this.grantType)) {
                throw new IllegalArgumentException("a refresh request cannot be sent to an older version");
            }
            out.writeString(this.username);
            byte[] passwordBytes = CharArrays.toUtf8Bytes(this.password.getChars());
            try {
                out.writeByteArray(passwordBytes);
            }
            finally {
                Arrays.fill(passwordBytes, (byte)0);
            }
        }
        out.writeOptionalString(this.scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.grantType = in.readString();
        if (in.getVersion().onOrAfter(Version.V_6_2_0)) {
            this.username = in.readOptionalString();
            BytesReference bytesRef = in.readOptionalBytesReference();
            if (bytesRef != null) {
                byte[] bytes = BytesReference.toBytes((BytesReference)bytesRef);
                try {
                    this.password = new SecureString(CharArrays.utf8BytesToChars(bytes));
                }
                finally {
                    Arrays.fill(bytes, (byte)0);
                }
            } else {
                this.password = null;
            }
            this.refreshToken = in.readOptionalString();
        } else {
            this.username = in.readString();
            byte[] passwordBytes = in.readByteArray();
            try {
                this.password = new SecureString(CharArrays.utf8BytesToChars(passwordBytes));
            }
            finally {
                Arrays.fill(passwordBytes, (byte)0);
            }
        }
        this.scope = in.readOptionalString();
    }
}

