/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.lookup;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class PainlessMethod {
    public final String name;
    public final Class<?> target;
    public final Class<?> augmentation;
    public final Class<?> rtn;
    public final List<Class<?>> arguments;
    public final Method method;
    public final int modifiers;
    public final MethodHandle handle;

    public PainlessMethod(String name, Class<?> target, Class<?> augmentation, Class<?> rtn, List<Class<?>> arguments, Method method, int modifiers, MethodHandle handle) {
        this.name = name;
        this.augmentation = augmentation;
        this.target = target;
        this.rtn = rtn;
        this.arguments = Collections.unmodifiableList(arguments);
        this.method = method;
        this.modifiers = modifiers;
        this.handle = handle;
    }

    public MethodType getMethodType() {
        Class<?> returnValue;
        Class[] params;
        if (this.handle != null) {
            return this.handle.type();
        }
        if (this.augmentation != null) {
            params = new Class[1 + this.arguments.size()];
            params[0] = this.augmentation;
            for (int i = 0; i < this.arguments.size(); ++i) {
                params[i + 1] = PainlessLookupUtility.typeToJavaType(this.arguments.get(i));
            }
            returnValue = PainlessLookupUtility.typeToJavaType(this.rtn);
        } else if (Modifier.isStatic(this.modifiers)) {
            params = new Class[this.arguments.size()];
            for (int i = 0; i < this.arguments.size(); ++i) {
                params[i] = PainlessLookupUtility.typeToJavaType(this.arguments.get(i));
            }
            returnValue = PainlessLookupUtility.typeToJavaType(this.rtn);
        } else if ("<init>".equals(this.name)) {
            params = new Class[this.arguments.size()];
            for (int i = 0; i < this.arguments.size(); ++i) {
                params[i] = PainlessLookupUtility.typeToJavaType(this.arguments.get(i));
            }
            returnValue = this.target;
        } else {
            params = new Class[1 + this.arguments.size()];
            params[0] = this.target;
            for (int i = 0; i < this.arguments.size(); ++i) {
                params[i + 1] = PainlessLookupUtility.typeToJavaType(this.arguments.get(i));
            }
            returnValue = PainlessLookupUtility.typeToJavaType(this.rtn);
        }
        return MethodType.methodType(returnValue, params);
    }

    public void write(MethodWriter writer) {
        Type type;
        Class<?> clazz;
        if (this.augmentation != null) {
            assert (Modifier.isStatic(this.modifiers));
            clazz = this.augmentation;
            type = Type.getType(this.augmentation);
        } else {
            clazz = this.target;
            type = Type.getType(this.target);
        }
        if (Modifier.isStatic(this.modifiers)) {
            if (Modifier.isInterface(clazz.getModifiers())) {
                writer.visitMethodInsn(184, type.getInternalName(), this.name, this.getMethodType().toMethodDescriptorString(), true);
            } else {
                writer.invokeStatic(type, this.method);
            }
        } else if (Modifier.isInterface(clazz.getModifiers())) {
            writer.invokeInterface(type, this.method);
        } else {
            writer.invokeVirtual(type, this.method);
        }
    }
}

