/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.action;

import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.sql.action.SqlQueryAction;
import org.elasticsearch.xpack.sql.action.SqlQueryRequest;
import org.elasticsearch.xpack.sql.action.SqlQueryResponse;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.proto.Protocol;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;

public class SqlQueryRequestBuilder
extends ActionRequestBuilder<SqlQueryRequest, SqlQueryResponse, SqlQueryRequestBuilder> {
    public SqlQueryRequestBuilder(ElasticsearchClient client, SqlQueryAction action) {
        this(client, action, "", Collections.emptyList(), null, Protocol.TIME_ZONE, 1000, Protocol.REQUEST_TIMEOUT, Protocol.PAGE_TIMEOUT, "", Mode.PLAIN);
    }

    public SqlQueryRequestBuilder(ElasticsearchClient client, SqlQueryAction action, String query, List<SqlTypedParamValue> params, QueryBuilder filter, TimeZone timeZone, int fetchSize, TimeValue requestTimeout, TimeValue pageTimeout, String nextPageInfo, Mode mode) {
        super(client, (Action)action, (ActionRequest)new SqlQueryRequest(mode, query, params, filter, timeZone, fetchSize, requestTimeout, pageTimeout, nextPageInfo));
    }

    public SqlQueryRequestBuilder query(String query) {
        ((SqlQueryRequest)this.request).query(query);
        return this;
    }

    public SqlQueryRequestBuilder mode(String mode) {
        ((SqlQueryRequest)this.request).mode(mode);
        return this;
    }

    public SqlQueryRequestBuilder mode(Mode mode) {
        ((SqlQueryRequest)this.request).mode(mode);
        return this;
    }

    public SqlQueryRequestBuilder cursor(String cursor) {
        ((SqlQueryRequest)this.request).cursor(cursor);
        return this;
    }

    public SqlQueryRequestBuilder filter(QueryBuilder filter) {
        ((SqlQueryRequest)this.request).filter(filter);
        return this;
    }

    public SqlQueryRequestBuilder timeZone(TimeZone timeZone) {
        ((SqlQueryRequest)this.request).timeZone(timeZone);
        return this;
    }

    public SqlQueryRequestBuilder requestTimeout(TimeValue timeout) {
        ((SqlQueryRequest)this.request).requestTimeout(timeout);
        return this;
    }

    public SqlQueryRequestBuilder pageTimeout(TimeValue timeout) {
        ((SqlQueryRequest)this.request).pageTimeout(timeout);
        return this;
    }

    public SqlQueryRequestBuilder fetchSize(int fetchSize) {
        ((SqlQueryRequest)this.request).fetchSize(fetchSize);
        return this;
    }
}

