/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.cli;

import java.io.IOException;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.xpack.sql.cli.CliTerminal;
import org.elasticsearch.xpack.sql.cli.Completers;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.InfoCmp;

public class JLineTerminal
implements CliTerminal {
    private Terminal terminal;
    private LineReader reader;

    public JLineTerminal(Terminal terminal, boolean enableMatchBracket) {
        this(terminal, LineReaderBuilder.builder().terminal(terminal).completer(Completers.INSTANCE).build(), enableMatchBracket);
    }

    JLineTerminal(Terminal terminal, LineReader reader, boolean enableMatchBracket) {
        this.terminal = terminal;
        this.reader = reader;
        if (!enableMatchBracket) {
            reader.setVariable("blink-matching-paren", 0L);
        }
    }

    @Override
    public LineBuilder line() {
        return new LineBuilder();
    }

    @Override
    public void print(String text) {
        this.terminal.writer().print(text);
    }

    @Override
    public void println(String text) {
        this.print(text);
        this.print("\n");
    }

    @Override
    public void error(String type, String message) {
        AttributedStringBuilder sb = new AttributedStringBuilder();
        sb.append(type + " [", AttributedStyle.BOLD.foreground(1));
        sb.append(message, AttributedStyle.DEFAULT.boldOff().italic().foreground(3));
        sb.append("]", AttributedStyle.BOLD.underlineOff().foreground(1));
        this.terminal.writer().print(sb.toAnsi(this.terminal));
        this.terminal.flush();
    }

    @Override
    public void println() {
        this.print("\n");
    }

    @Override
    public void clear() {
        this.terminal.puts(InfoCmp.Capability.clear_screen, new Object[0]);
    }

    @Override
    public void flush() {
        this.terminal.flush();
    }

    @Override
    public void printStackTrace(Exception ex) {
        ex.printStackTrace(this.terminal.writer());
    }

    @Override
    public String readPassword(String prompt) throws UserException {
        try {
            String password = this.reader.readLine(prompt, Character.valueOf('\u0000'));
            if (password == null) {
                throw new UserException(77, "password required");
            }
            return password;
        }
        catch (EndOfFileException | UserInterruptException ex) {
            throw new UserException(77, "password required");
        }
    }

    @Override
    public String readLine(String prompt) {
        String attributedString = new AttributedString(prompt, AttributedStyle.DEFAULT.foreground(3)).toAnsi(this.terminal);
        try {
            return this.reader.readLine(attributedString);
        }
        catch (UserInterruptException ex) {
            return "";
        }
        catch (EndOfFileException ex) {
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        this.terminal.close();
    }

    public final class LineBuilder
    implements CliTerminal.LineBuilder {
        AttributedStringBuilder line = new AttributedStringBuilder();

        private LineBuilder() {
        }

        @Override
        public LineBuilder text(String text) {
            this.line.append(text, AttributedStyle.DEFAULT);
            return this;
        }

        @Override
        public LineBuilder em(String text) {
            this.line.append(text, AttributedStyle.DEFAULT.foreground(8));
            return this;
        }

        @Override
        public LineBuilder error(String text) {
            this.line.append(text, AttributedStyle.BOLD.foreground(1));
            return this;
        }

        @Override
        public LineBuilder param(String text) {
            this.line.append(text, AttributedStyle.DEFAULT.italic().foreground(3));
            return this;
        }

        @Override
        public void ln() {
            JLineTerminal.this.println(this.line.toAnsi(JLineTerminal.this.terminal));
        }

        @Override
        public void end() {
            JLineTerminal.this.terminal.writer().print(this.line.toAnsi(JLineTerminal.this.terminal));
            JLineTerminal.this.terminal.writer().flush();
        }
    }
}

