/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.LDAPSDKUsageException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.support.CachingRealm;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExpressionModel;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.FieldExpression;

public interface UserRoleMapper {
    public void resolveRoles(UserData var1, ActionListener<Set<String>> var2);

    public void refreshRealmOnChange(CachingRealm var1);

    public static class DistinguishedNamePredicate
    implements Predicate<FieldExpression.FieldValue> {
        private static final Logger LOGGER = Loggers.getLogger(DistinguishedNamePredicate.class);
        private final String string;
        private final DN dn;

        public DistinguishedNamePredicate(String string) {
            this.string = string;
            this.dn = DistinguishedNamePredicate.parseDn(string);
        }

        private static DN parseDn(String string) {
            if (string == null) {
                return null;
            }
            try {
                return new DN(string);
            }
            catch (LDAPException | LDAPSDKUsageException e) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Message)new ParameterizedMessage("failed to parse [{}] as a DN", (Object)string), e);
                }
                return null;
            }
        }

        public String toString() {
            return this.string;
        }

        @Override
        public boolean test(FieldExpression.FieldValue fieldValue) {
            CharacterRunAutomaton automaton = fieldValue.getAutomaton();
            if (automaton != null) {
                DN dnSuffix;
                String suffix;
                if (automaton.run(this.string)) {
                    return true;
                }
                if (this.dn != null && automaton.run(this.dn.toNormalizedString())) {
                    return true;
                }
                if (automaton.run(this.string.toLowerCase(Locale.ROOT)) || automaton.run(this.string.toUpperCase(Locale.ROOT))) {
                    return true;
                }
                if (this.dn == null) {
                    return false;
                }
                assert (fieldValue.getValue() instanceof String) : "FieldValue " + fieldValue + " has automaton but value is " + (fieldValue.getValue() == null ? "<null>" : fieldValue.getValue().getClass());
                String pattern = (String)fieldValue.getValue();
                return pattern.startsWith("*,") && (suffix = pattern.substring(2)).indexOf(42) == -1 && (dnSuffix = DistinguishedNamePredicate.parseDn(suffix)) != null && this.dn.isDescendantOf(dnSuffix, false);
            }
            if (fieldValue.getValue() instanceof String) {
                String testString = (String)fieldValue.getValue();
                if (testString.equalsIgnoreCase(this.string)) {
                    return true;
                }
                if (this.dn == null) {
                    return false;
                }
                DN testDn = DistinguishedNamePredicate.parseDn(testString);
                if (testDn != null) {
                    return this.dn.equals((Object)testDn);
                }
                return testString.equalsIgnoreCase(this.dn.toNormalizedString());
            }
            return this.string == null && fieldValue.getValue() == null;
        }
    }

    public static class UserData {
        private final String username;
        @Nullable
        private final String dn;
        private final Set<String> groups;
        private final Map<String, Object> metadata;
        private final RealmConfig realm;

        public UserData(String username, @Nullable String dn, Collection<String> groups, Map<String, Object> metadata, RealmConfig realm) {
            this.username = username;
            this.dn = dn;
            this.groups = groups == null || groups.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(groups));
            this.metadata = metadata == null || metadata.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(metadata);
            this.realm = realm;
        }

        public ExpressionModel asModel() {
            ExpressionModel model = new ExpressionModel();
            model.defineField("username", (Object)this.username);
            model.defineField("dn", (Object)this.dn, (Predicate)new DistinguishedNamePredicate(this.dn));
            model.defineField("groups", this.groups, this.groups.stream().map(DistinguishedNamePredicate::new).reduce(Predicate::or).orElse(fieldValue -> false));
            this.metadata.keySet().forEach(k -> model.defineField("metadata." + k, this.metadata.get(k)));
            model.defineField("realm.name", (Object)this.realm.name());
            return model;
        }

        public String toString() {
            return "UserData{username:" + this.username + "; dn:" + this.dn + "; groups:" + this.groups + "; metadata:" + this.metadata + "; realm=" + this.realm.name() + '}';
        }

        public String getUsername() {
            return this.username;
        }

        @Nullable
        public String getDn() {
            return this.dn;
        }

        public Set<String> getGroups() {
            return this.groups;
        }

        public Map<String, Object> getMetadata() {
            return this.metadata;
        }

        public RealmConfig getRealm() {
            return this.realm;
        }
    }
}

