/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.tools.plugin;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.gephi.graph.api.Node;
import org.gephi.tools.spi.NodePressAndDraggingEventListener;
import org.gephi.tools.spi.Tool;
import org.gephi.tools.spi.ToolEventListener;
import org.gephi.tools.spi.ToolSelectionType;
import org.gephi.tools.spi.ToolUI;
import org.gephi.ui.tools.plugin.SizerPanel;
import org.openide.util.NbBundle;

public class Sizer
implements Tool {
    private SizerPanel sizerPanel;
    private ToolEventListener[] listeners;
    private final float INTENSITY = 0.4f;
    private final float LIMIT = 0.1f;
    private Node[] nodes;
    private float[] sizes;

    public void select() {
    }

    public void unselect() {
        this.listeners = null;
        this.sizerPanel = null;
        this.nodes = null;
        this.sizes = null;
    }

    public ToolEventListener[] getListeners() {
        this.listeners = new ToolEventListener[1];
        this.listeners[0] = new NodePressAndDraggingEventListener(){

            public void pressNodes(Node[] nodes) {
                Sizer.access$002(Sizer.this, nodes);
                Sizer.access$102(Sizer.this, new float[nodes.length]);
                for (int i = 0; i < nodes.length; ++i) {
                    Node n = nodes[i];
                    ((Sizer)Sizer.this).sizes[i] = n.size();
                }
            }

            public void released() {
                Sizer.access$002(Sizer.this, null);
                Sizer.this.sizerPanel.setAvgSize(-1.0f);
            }

            public void drag(float displacementX, float displacementY) {
                if (Sizer.this.nodes != null) {
                    float averageSize = 0.0f;
                    for (int i = 0; i < Sizer.this.nodes.length; ++i) {
                        Node n = Sizer.this.nodes[i];
                        float size = Sizer.this.sizes[i];
                        if ((size += displacementY * 0.4f) < 0.1f) {
                            size = 0.1f;
                        }
                        averageSize += size;
                        n.setSize(size);
                    }
                    Sizer.this.sizerPanel.setAvgSize(averageSize /= (float)Sizer.this.nodes.length);
                }
            }
        };
        return this.listeners;
    }

    public ToolUI getUI() {
        return new ToolUI(){

            public JPanel getPropertiesBar(Tool tool) {
                Sizer.this.sizerPanel = new SizerPanel();
                return Sizer.this.sizerPanel;
            }

            public String getName() {
                return NbBundle.getMessage(Sizer.class, (String)"Sizer.name");
            }

            public Icon getIcon() {
                return new ImageIcon(this.getClass().getResource("/org/gephi/tools/plugin/resources/sizer.png"));
            }

            public String getDescription() {
                return NbBundle.getMessage(Sizer.class, (String)"Sizer.description");
            }

            public int getPosition() {
                return 105;
            }
        };
    }

    public ToolSelectionType getSelectionType() {
        return ToolSelectionType.SELECTION_AND_DRAGGING;
    }

    static /* synthetic */ Node[] access$002(Sizer x0, Node[] x1) {
        x0.nodes = x1;
        return x1;
    }

    static /* synthetic */ float[] access$102(Sizer x0, float[] x1) {
        x0.sizes = x1;
        return x1;
    }
}

