/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.NumericNode;
import org.jruby.ast.SideEffectFree;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;

public class RationalNode
extends NumericNode
implements SideEffectFree {
    private final NumericNode numerator;
    private final NumericNode denominator;

    public RationalNode(ISourcePosition position, NumericNode numerator2, NumericNode denominator2) {
        super(position);
        this.numerator = numerator2;
        this.denominator = denominator2;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visitRationalNode(this);
    }

    @Override
    public NumericNode negate() {
        return new RationalNode(this.getPosition(), this.numerator.negate(), this.denominator);
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.RATIONALNODE;
    }

    public NumericNode getNumerator() {
        return this.numerator;
    }

    public NumericNode getDenominator() {
        return this.denominator;
    }
}

