/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.OutputStream;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyIO;
import org.jruby.RubyString;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class IOOutputStream
extends OutputStream {
    private final IRubyObject io;
    private final OutputStream out;
    private final CallSite writeAdapter;
    private final CallSite closeAdapter = MethodIndex.getFunctionalCallSite("close");
    private final Encoding encoding;

    public IOOutputStream(IRubyObject io2, Encoding encoding2, boolean checkAppend, boolean verifyCanWrite) {
        this.io = io2;
        OutputStream outputStream = this.out = io2 instanceof RubyIO && !((RubyIO)io2).isClosed() && ((RubyIO)io2).isBuiltin("write") ? ((RubyIO)io2).getOutStream() : null;
        if (this.out == null || verifyCanWrite) {
            String site;
            if (io2.respondsTo("write")) {
                site = "write";
            } else if (checkAppend && io2.respondsTo("<<")) {
                site = "<<";
            } else {
                if (verifyCanWrite) {
                    throw io2.getRuntime().newArgumentError("Object: " + io2 + " is not a legal argument to this wrapper, cause it doesn't respond to \"write\".");
                }
                site = "write";
            }
            this.writeAdapter = MethodIndex.getFunctionalCallSite(site);
        } else {
            this.writeAdapter = null;
        }
        this.encoding = encoding2;
    }

    public IOOutputStream(IRubyObject io2, boolean checkAppend, boolean verifyCanWrite) {
        this(io2, ASCIIEncoding.INSTANCE, checkAppend, verifyCanWrite);
    }

    public IOOutputStream(IRubyObject io2) {
        this(io2, true, true);
    }

    public IOOutputStream(IRubyObject io2, Encoding encoding2) {
        this(io2, encoding2, true, true);
    }

    @Override
    public void write(int bite) throws IOException {
        if (this.out != null) {
            this.out.write(bite);
        } else {
            Ruby runtime2 = this.io.getRuntime();
            this.writeAdapter.call(runtime2.getCurrentContext(), this.io, this.io, (IRubyObject)RubyString.newStringLight(runtime2, new ByteList(new byte[]{(byte)bite}, this.encoding, false)));
        }
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (this.out != null) {
            this.out.write(b2, off, len);
        } else {
            Ruby runtime2 = this.io.getRuntime();
            this.writeAdapter.call(runtime2.getCurrentContext(), this.io, this.io, (IRubyObject)RubyString.newStringLight(runtime2, new ByteList(b2, off, len, this.encoding, false)));
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        } else if (this.io.respondsTo("close")) {
            this.closeAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, this.io);
        }
    }
}

