/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.matcher;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.ivy.plugins.matcher.AbstractPatternMatcher;
import org.apache.ivy.plugins.matcher.Matcher;

public final class RegexpPatternMatcher
extends AbstractPatternMatcher {
    public static final RegexpPatternMatcher INSTANCE = new RegexpPatternMatcher();

    public RegexpPatternMatcher() {
        super("regexp");
    }

    @Override
    protected Matcher newMatcher(String expression) {
        return new RegexpMatcher(expression);
    }

    private static class RegexpMatcher
    implements Matcher {
        private Pattern pattern;
        private String expression;

        public RegexpMatcher(String expression) throws PatternSyntaxException {
            if (expression == null) {
                throw new NullPointerException();
            }
            this.expression = expression;
            this.pattern = Pattern.compile(expression);
        }

        @Override
        public boolean matches(String input) {
            if (input == null) {
                throw new NullPointerException();
            }
            return this.pattern.matcher(input).matches();
        }
    }
}

