"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const pmx_1 = require("../pmx");
const debug = debug_1.default('PM2-IO-APM');
const IO_KEY = Symbol.for('@pm2/io');
class Entrypoint extends pmx_1.default {
    constructor() {
        super();
        this.defaultConf = {
            metrics: {
                eventLoopActive: true,
                eventLoopDelay: true,
                network: {
                    traffic: false,
                    ports: false
                },
                transaction: {
                    http: true,
                    tracing: false
                },
                deepMetrics: false,
                v8: false
            },
            actions: {
                eventLoopDump: false,
                profilingCpu: true,
                profilingHeap: true
            }
        };
        try {
            this.io = global[IO_KEY].init(this.conf());
            this.onStart(err => {
                if (err) {
                    debug(err);
                }
                this.sensors();
                this.events();
                this.actuators();
                this.io.onExit((code, signal) => {
                    this.onStop(err, () => {
                        this.io.destroy();
                    }, code, signal);
                });
                if (process && process.send)
                    process.send('ready');
            });
        }
        catch (e) {
            // properly exit in case onStart/onStop method has not been override
            if (this.io) {
                this.io.destroy();
            }
            throw (e);
        }
    }
    events() {
        debug('No events !');
    }
    sensors() {
        debug('No metrics !');
    }
    actuators() {
        debug('No metrics !');
    }
    onStart(cb) {
        throw new Error('Entrypoint onStart() not specified');
    }
    onStop(err, cb, code, signal) {
        cb(); // by default only execute callback
    }
    conf() {
        return this.defaultConf;
    }
}
exports.default = Entrypoint;
//# sourceMappingURL=data:application/json;base64,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