/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology;

import com.google.common.base.Optional;
import java.awt.Component;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.ontology.OntologyPreferences;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class OntologyIDJDialog
extends JPanel {
    private static final long serialVersionUID = -3786605367035342914L;
    private JTextField ontologyIRIField;
    private JCheckBox enableVersionCheckBox;
    private JTextField versionIRIField;

    public static OWLOntologyID showDialog(OWLEditorKit editorKit, OWLOntologyID id) {
        OntologyIDJDialog dialog = new OntologyIDJDialog(id);
        int response = JOptionPane.showConfirmDialog(SwingUtilities.getAncestorOfClass(JFrame.class, (Component)((Object)editorKit.getOWLWorkspace())), dialog, "Refactor Ontology Name", 2, 3);
        return response == 0 ? dialog.getOntologyID() : null;
    }

    public OntologyIDJDialog(OWLOntologyID id) {
        this.createUI(id);
    }

    public void createUI(OWLOntologyID id) {
        this.ontologyIRIField = new JTextField(OntologyPreferences.getInstance().generateURI().toString());
        if (!id.isAnonymous()) {
            this.ontologyIRIField.setText(((IRI)id.getOntologyIRI().get()).toString());
        }
        this.enableVersionCheckBox = new JCheckBox("Enable Version Iri");
        this.enableVersionCheckBox.setEnabled(true);
        this.enableVersionCheckBox.setSelected(!id.isAnonymous() && id.getVersionIRI().isPresent());
        this.enableVersionCheckBox.addActionListener(e -> {
            this.versionIRIField.setEnabled(this.enableVersionCheckBox.isSelected());
            if (this.versionIRIField.isEnabled()) {
                this.versionIRIField.setText(this.ontologyIRIField.getText());
            }
        });
        this.versionIRIField = new JTextField();
        if (!id.isAnonymous() && id.getVersionIRI().isPresent()) {
            this.versionIRIField.setText(((IRI)id.getVersionIRI().get()).toString());
        } else if (id.getOntologyIRI().isPresent()) {
            this.versionIRIField.setText(((IRI)id.getOntologyIRI().get()).toString());
        }
        this.versionIRIField.setEnabled(!id.isAnonymous() && id.getVersionIRI().isPresent());
        Box holderPanel = new Box(3);
        holderPanel.add(new JLabel("Ontology IRI"));
        holderPanel.add(this.ontologyIRIField);
        holderPanel.add(Box.createVerticalStrut(12));
        holderPanel.add(new JLabel("Version IRI"));
        holderPanel.add(this.versionIRIField);
        holderPanel.add(this.enableVersionCheckBox);
        this.add(holderPanel);
    }

    public OWLOntologyID getOntologyID() {
        try {
            URI ontologyURI = new URI(this.ontologyIRIField.getText());
            IRI ontologyIRI = IRI.create((URI)ontologyURI);
            if (this.enableVersionCheckBox.isSelected()) {
                URI versionURI = new URI(this.versionIRIField.getText());
                IRI versionIRI = IRI.create((URI)versionURI);
                return new OWLOntologyID(Optional.of((Object)ontologyIRI), Optional.of((Object)versionIRI));
            }
            return new OWLOntologyID(Optional.of((Object)ontologyIRI), Optional.absent());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

