/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view;

import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import org.protege.editor.core.HasUpdateState;
import org.protege.editor.core.ui.view.View;
import org.protege.editor.core.ui.view.ViewAction;
import org.protege.editor.core.ui.view.ViewMode;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.protege.editor.owl.model.util.OWLUtilities;
import org.protege.editor.owl.ui.OWLObjectComparatorAdapter;
import org.protege.editor.owl.ui.action.OWLObjectHierarchyDeleter;
import org.protege.editor.owl.ui.framelist.OWLFrameList;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.protege.editor.owl.ui.tree.OWLModelManagerTree;
import org.protege.editor.owl.ui.tree.OWLObjectTree;
import org.protege.editor.owl.ui.view.AbstractOWLSelectionViewComponent;
import org.protege.editor.owl.ui.view.ChangeListenerMediator;
import org.protege.editor.owl.ui.view.Deleteable;
import org.protege.editor.owl.ui.view.Findable;
import org.protege.editor.owl.ui.view.HasDisplayDeprecatedEntities;
import org.protege.editor.owl.ui.view.ViewModeComponent;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOWLEntityHierarchyViewComponent<E extends OWLEntity>
extends AbstractOWLSelectionViewComponent
implements Findable<E>,
Deleteable,
HasDisplayDeprecatedEntities {
    private OWLObjectTree<E> assertedTree;
    private Optional<OWLObjectTree<E>> inferredTree;
    private TreeSelectionListener listener;
    private OWLObjectHierarchyDeleter<E> hierarchyDeleter;
    private final Logger logger = LoggerFactory.getLogger(AbstractOWLEntityHierarchyViewComponent.class);
    private final ViewModeComponent<OWLObjectTree<E>> viewModeComponent = new ViewModeComponent();
    private ChangeListenerMediator deletableChangeListenerMediator = new ChangeListenerMediator();

    @Override
    public final void initialiseView() throws Exception {
        this.setLayout(new BorderLayout(0, 0));
        this.add(this.viewModeComponent, "Center");
        this.assertedTree = new OWLModelManagerTree<E>(this.getOWLEditorKit(), this.getHierarchyProvider());
        OWLObjectComparatorAdapter<OWLObject> treeNodeComp = AbstractOWLEntityHierarchyViewComponent.createComparator(this.getOWLModelManager());
        this.assertedTree.setOWLObjectComparator(treeNodeComp);
        TreeCellRenderer treeCellRenderer = this.assertedTree.getCellRenderer();
        if (treeCellRenderer instanceof OWLCellRenderer) {
            ((OWLCellRenderer)treeCellRenderer).setHighlightKeywords(true);
        }
        this.viewModeComponent.add(this.assertedTree, ViewMode.ASSERTED, true);
        this.performExtraInitialisation();
        E entity = this.getSelectedEntity();
        if (entity != null) {
            this.setGlobalSelection((OWLEntity)entity);
        }
        TreeModelListener treeModelListener = new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                AbstractOWLEntityHierarchyViewComponent.this.ensureSelection();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                AbstractOWLEntityHierarchyViewComponent.this.ensureSelection();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                AbstractOWLEntityHierarchyViewComponent.this.ensureSelection();
            }
        };
        this.assertedTree.getModel().addTreeModelListener(treeModelListener);
        this.assertedTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                AbstractOWLEntityHierarchyViewComponent.this.transmitSelection();
            }
        });
        try {
            Optional<OWLObjectHierarchyProvider<E>> inferredHierarchyProvider = this.getInferredHierarchyProvider();
            if (inferredHierarchyProvider.isPresent()) {
                this.inferredTree = Optional.of(new OWLModelManagerTree<E>(this.getOWLEditorKit(), inferredHierarchyProvider.get()));
                this.inferredTree.get().setBackground(OWLFrameList.INFERRED_BG_COLOR);
                this.inferredTree.get().setOWLObjectComparator(treeNodeComp);
                this.inferredTree.get().getModel().addTreeModelListener(treeModelListener);
                this.inferredTree.get().addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        AbstractOWLEntityHierarchyViewComponent.this.transmitSelection();
                    }
                });
                this.viewModeComponent.add((OWLObjectTree<E>)((JComponent)this.inferredTree.get()), ViewMode.INFERRED, true);
                this.getView().addViewMode(ViewMode.ASSERTED);
                this.getView().addViewMode(ViewMode.INFERRED);
                this.getView().addViewModeChangedHandler(this::switchViewMode);
            } else {
                this.inferredTree = Optional.empty();
            }
        }
        catch (Exception e2) {
            this.logger.error("An error occurred whilst getting the inferred hierarchy provider", (Throwable)e2);
        }
        this.hierarchyDeleter = new OWLObjectHierarchyDeleter<E>(this.getOWLEditorKit(), this.getHierarchyProvider(), () -> new HashSet<E>(this.assertedTree.getSelectedOWLObjects()), this.getCollectiveTypeName());
        this.listener = e -> this.transmitSelection();
        this.assertedTree.addTreeSelectionListener(this.listener);
        if (this.inferredTree.isPresent()) {
            this.inferredTree.get().addTreeSelectionListener(this.listener);
        }
    }

    protected boolean isInAssertedMode() {
        return this.getView().getViewMode().equals(Optional.of(ViewMode.ASSERTED));
    }

    private static OWLObjectComparatorAdapter<OWLObject> createComparator(final OWLModelManager modelManager) {
        final Comparator<OWLObject> comp = modelManager.getOWLObjectComparator();
        return new OWLObjectComparatorAdapter<OWLObject>(comp){

            @Override
            public int compare(OWLObject o1, OWLObject o2) {
                boolean deprecated2;
                if (modelManager.getOWLDataFactory().getOWLNothing().equals(o1)) {
                    return -1;
                }
                if (modelManager.getOWLDataFactory().getOWLNothing().equals(o2)) {
                    return 1;
                }
                boolean deprecated1 = OWLUtilities.isDeprecated(modelManager, o1);
                if (deprecated1 != (deprecated2 = OWLUtilities.isDeprecated(modelManager, o2))) {
                    return deprecated1 ? 1 : -1;
                }
                return comp.compare(o1, o2);
            }
        };
    }

    private void switchViewMode(Optional<ViewMode> viewMode) {
        OWLEntity sel = (OWLEntity)this.viewModeComponent.getComponentForCurrentViewMode().getSelectedOWLObject();
        this.viewModeComponent.setViewMode(viewMode);
        if (sel != null) {
            this.setSelectedEntity(sel);
        }
        this.updateViewActions();
        this.updateView();
    }

    private void updateViewActions() {
        for (ViewAction viewAction : this.getView().getViewActions()) {
            if (!(viewAction instanceof HasUpdateState)) continue;
            ((HasUpdateState)viewAction).updateState();
        }
    }

    protected abstract void performExtraInitialisation() throws Exception;

    protected abstract OWLObjectHierarchyProvider<E> getHierarchyProvider();

    protected abstract Optional<OWLObjectHierarchyProvider<E>> getInferredHierarchyProvider();

    protected String getCollectiveTypeName() {
        return "entities";
    }

    public void setSelectedEntity(E entity) {
        this.getTree().setSelectedOWLObject(entity);
    }

    public OWLObjectTree<E> getAssertedTree() {
        return this.assertedTree;
    }

    public void setSelectedEntities(Set<E> entities) {
        this.getTree().setSelectedOWLObjects(entities);
    }

    public E getSelectedEntity() {
        return (E)((OWLEntity)this.getTree().getSelectedOWLObject());
    }

    public Set<E> getSelectedEntities() {
        return new HashSet<E>(this.getTree().getSelectedOWLObjects());
    }

    private void ensureSelection() {
        SwingUtilities.invokeLater(() -> {
            OWLEntity treeSel;
            E entity = this.getSelectedEntity();
            if (!(entity == null || (treeSel = (OWLEntity)this.getTree().getSelectedOWLObject()) != null && treeSel.equals(entity))) {
                this.getTree().setSelectedOWLObject(entity);
            }
        });
    }

    public boolean requestFocusInWindow() {
        return this.getTree().requestFocusInWindow();
    }

    protected OWLObjectTree<E> getTree() {
        Optional viewMode = this.getView().getViewMode();
        return this.viewModeComponent.getComponentForViewMode(viewMode);
    }

    protected void transmitSelection() {
        this.deletableChangeListenerMediator.fireStateChanged(this);
        E selEntity = this.getSelectedEntity();
        if (selEntity != null) {
            View view = this.getView();
            if (view != null && !view.isPinned()) {
                view.setPinned(true);
                this.setGlobalSelection((OWLEntity)selEntity);
                view.setPinned(false);
            } else {
                this.setGlobalSelection((OWLEntity)selEntity);
            }
        } else {
            this.setGlobalSelection(null);
        }
        this.updateHeader((OWLObject)selEntity);
    }

    protected E updateView(E selEntity) {
        if (this.getTree().getSelectedOWLObject() == null) {
            if (selEntity != null) {
                this.getTree().setSelectedOWLObject(selEntity);
            }
        } else if (!((OWLEntity)this.getTree().getSelectedOWLObject()).equals(selEntity)) {
            this.getTree().setSelectedOWLObject(selEntity);
        }
        return selEntity;
    }

    @Override
    public void disposeView() {
        if (this.assertedTree != null) {
            this.assertedTree.removeTreeSelectionListener(this.listener);
            this.assertedTree.dispose();
        }
        if (this.inferredTree.isPresent()) {
            this.inferredTree.get().removeTreeSelectionListener(this.listener);
            this.inferredTree.get().dispose();
        }
    }

    @Override
    protected OWLObject getObjectToCopy() {
        return this.getTree().getSelectedOWLObject();
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.deletableChangeListenerMediator.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.deletableChangeListenerMediator.removeChangeListener(listener);
    }

    @Override
    public void handleDelete() {
        this.hierarchyDeleter.performDeletion();
    }

    @Override
    public boolean canDelete() {
        return !this.getTree().getSelectedOWLObjects().isEmpty();
    }

    @Override
    public void show(E owlEntity) {
        this.getTree().setSelectedOWLObject(owlEntity);
    }

    @Override
    public void setShowDeprecatedEntities(boolean showDeprecatedEntities) {
        if (showDeprecatedEntities) {
            this.getHierarchyProvider().setFilter((Predicate<E>)((Predicate<OWLEntity>)e -> true));
        } else {
            this.getHierarchyProvider().setFilter((Predicate<E>)((Predicate<OWLEntity>)this::isNotDeprecated));
        }
    }

    private boolean isNotDeprecated(E e) {
        return !OWLUtilities.isDeprecated(this.getOWLModelManager(), e);
    }
}

