/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.update;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.protege.editor.core.log.LogBanner;
import org.protege.editor.core.plugin.PluginUtilities;
import org.protege.editor.core.update.PluginDocumentParseException;
import org.protege.editor.core.update.PluginInfo;
import org.protege.editor.core.update.PluginRegistry;
import org.protege.editor.core.update.UpdateChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class PluginRegistryImpl
implements PluginRegistry {
    public static final Marker AUTO_UPDATE = MarkerFactory.getMarker((String)"Auto-Update");
    private static final Logger logger = LoggerFactory.getLogger(PluginRegistryImpl.class);
    public static final String UPDATE_URL = "Update-Url";
    private final URL root;
    private final List<PluginInfo> availablePlugins = new ArrayList<PluginInfo>();

    public PluginRegistryImpl(URL root) {
        this.root = root;
    }

    @Override
    public void reload() {
        this.availablePlugins.clear();
        Calculator calculator = new Calculator(this.root);
        calculator.run();
        this.availablePlugins.addAll(calculator.getAvailablePlugins());
    }

    @Override
    public List<PluginInfo> getAvailablePlugins() {
        return new ArrayList<PluginInfo>(this.availablePlugins);
    }

    private static void sortPlugins(List<PluginInfo> plugins) {
        Collections.sort(plugins, new Comparator<PluginInfo>(){

            @Override
            public int compare(PluginInfo o1, PluginInfo o2) {
                String l1 = o1.getLabel();
                String l2 = o2.getLabel();
                return l1.compareToIgnoreCase(l2);
            }
        });
    }

    private static String pad(int depth) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            sb.append("    ");
        }
        return sb.toString();
    }

    private static class Calculator {
        private URL root;
        private BundleContext context = PluginUtilities.getInstance().getApplicationContext();
        private Map<String, Bundle> bundleByIds = new HashMap<String, Bundle>();
        private Set<URL> visitedURLs = new HashSet<URL>();
        private final List<PluginInfo> availablePlugins = new ArrayList<PluginInfo>();

        public Calculator(URL root) {
            this.root = root;
        }

        public List<PluginInfo> getAvailablePlugins() {
            return new ArrayList<PluginInfo>(this.availablePlugins);
        }

        public void run() {
            logger.info(LogBanner.start("Running Auto-update"));
            logger.info("");
            this.mapIdsToBundles();
            this.searchForAvailablePlugins(this.root);
            PluginRegistryImpl.sortPlugins(this.availablePlugins);
            logger.info(LogBanner.end());
        }

        private void mapIdsToBundles() {
            if (this.context == null) {
                return;
            }
            for (Bundle bundle : this.context.getBundles()) {
                logger.debug(AUTO_UPDATE, "Existing plugin: {}", (Object)bundle.getSymbolicName());
                this.bundleByIds.put(bundle.getSymbolicName(), bundle);
            }
        }

        private void searchForAvailablePlugins(URL root) {
            logger.info("--- Searching for plugins ---");
            this.processUpdateOrRepositoryDocumentAt(root, 0);
        }

        private void processUpdateOrRepositoryDocumentAt(URL node, int depth) {
            block7: {
                if (this.visitedURLs.contains(node)) {
                    return;
                }
                this.visitedURLs.add(node);
                logger.info(AUTO_UPDATE, "{}Checking {}", (Object)PluginRegistryImpl.pad(depth), (Object)node);
                if (!node.toString().endsWith(".repository")) {
                    UpdateChecker checker = new UpdateChecker(node, Optional.empty());
                    try {
                        Optional<PluginInfo> parsedInfo = checker.run();
                        if (!parsedInfo.isPresent()) break block7;
                        PluginInfo info = parsedInfo.get();
                        logger.debug(AUTO_UPDATE, "{}URL {} has valid plugin info: {}", new Object[]{PluginRegistryImpl.pad(depth), node, info.getId()});
                        Bundle bundle = this.bundleByIds.get(info.getId());
                        if (bundle != null) {
                            boolean newer;
                            boolean bl = newer = bundle.getVersion().compareTo(info.getAvailableVersion()) < 0;
                            if (newer) {
                                info.setPluginDescriptor(bundle);
                                logger.debug(AUTO_UPDATE, "{}URL {} is an update", (Object)PluginRegistryImpl.pad(depth), (Object)node);
                                this.availablePlugins.add(info);
                            }
                            break block7;
                        }
                        this.availablePlugins.add(info);
                    }
                    catch (PluginDocumentParseException e) {
                        logger.info(AUTO_UPDATE, "{}{}", (Object)PluginRegistryImpl.pad(depth + 1), (Object)e.getMessage());
                        this.readRegistry(node, depth + 1);
                    }
                } else {
                    this.readRegistry(node, depth + 1);
                }
            }
        }

        private void readRegistry(URL node, int depth) {
            logger.info(AUTO_UPDATE, "{}Processing {} as a plugin registry", (Object)PluginRegistryImpl.pad(depth), (Object)node);
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(node.openStream())));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0 || line.startsWith("//")) continue;
                    try {
                        URL url = new URL(line);
                        this.processUpdateOrRepositoryDocumentAt(url, depth + 1);
                    }
                    catch (MalformedURLException urlException) {
                        logger.debug(AUTO_UPDATE, "{}    Invalid URL in plugin registry: " + line, (Object)PluginRegistryImpl.pad(depth));
                    }
                }
                reader.close();
            }
            catch (UnknownHostException ex) {
                logger.info(AUTO_UPDATE, "{}    Cannot open remote plugin registry at {} (Unknown Host)", (Object)PluginRegistryImpl.pad(depth), (Object)ex.getMessage());
            }
            catch (IOException ex) {
                logger.info(AUTO_UPDATE, "{}    Cannot read plugin registry at {}.  Reason: {}", new Object[]{PluginRegistryImpl.pad(depth), node, ex.getMessage()});
            }
        }
    }
}

