from pybtex.bibtex.interpreter import (
    Integer, String, QuotedVar, Identifier, FunctionLiteral,
)

bst = [['ENTRY',
  [Identifier('address'),
   Identifier('author'),
   Identifier('booktitle'),
   Identifier('chapter'),
   Identifier('edition'),
   Identifier('editor'),
   Identifier('howpublished'),
   Identifier('institution'),
   Identifier('isbn'),
   Identifier('issn'),
   Identifier('journal'),
   Identifier('key'),
   Identifier('language'),
   Identifier('month'),
   Identifier('note'),
   Identifier('number'),
   Identifier('organization'),
   Identifier('pages'),
   Identifier('publisher'),
   Identifier('school'),
   Identifier('series'),
   Identifier('title'),
   Identifier('type'),
   Identifier('volume'),
   Identifier('year'),
   Identifier('url'),
   Identifier('urldate'),
   Identifier('volumetitle'),
   Identifier('dissyear'),
   Identifier('howcited'),
   Identifier('juratitle'),
   Identifier('juraauthor'),
   Identifier('shorttitle'),
   Identifier('shortauthor'),
   Identifier('ssedition'),
   Identifier('titleaddon'),
   Identifier('booktitleaddon'),
   Identifier('editortype'),
   Identifier('sortkey'),
   Identifier('annote'),
   Identifier('gender'),
   Identifier('translator'),
   Identifier('flanguage'),
   Identifier('oyear'),
   Identifier('oaddress'),
   Identifier('opublisher'),
   Identifier('updated'),
   Identifier('totalpages'),
   Identifier('founder'),
   Identifier('archive'),
   Identifier('subarchive'),
   Identifier('shortarchive'),
   Identifier('shortsubarchive'),
   Identifier('sig1'),
   Identifier('sig2'),
   Identifier('sig3'),
   Identifier('sig4'),
   Identifier('archname')],
  [Identifier('repeat-authors'), Identifier('repeat-titles')],
  [Identifier('label'),
   Identifier('dummy.label'),
   Identifier('extra.label'),
   Identifier('sort.label'),
   Identifier('current-authors')]],
 ['INTEGERS',
  [Identifier('output.state'),
   Identifier('before.all'),
   Identifier('mid.sentence'),
   Identifier('after.sentence'),
   Identifier('after.block')]],
 ['INTEGERS', [Identifier('colon.after'), Identifier('period.dash')]],
 ['FUNCTION',
  [Identifier('init.state.consts')],
  [Integer(0),
   QuotedVar('before.all'),
   Identifier(':='),
   Integer(1),
   QuotedVar('mid.sentence'),
   Identifier(':='),
   Integer(2),
   QuotedVar('after.sentence'),
   Identifier(':='),
   Integer(3),
   QuotedVar('after.block'),
   Identifier(':='),
   Integer(4),
   QuotedVar('colon.after'),
   Identifier(':='),
   Integer(5),
   QuotedVar('period.dash'),
   Identifier(':=')]],
 ['STRINGS',
  [Identifier('s'),
   Identifier('t'),
   Identifier('u'),
   Identifier('v'),
   Identifier('w'),
   Identifier('x')]],
 ['FUNCTION',
  [Identifier('output.nonnull')],
  [QuotedVar('s'),
   Identifier(':='),
   Identifier('output.state'),
   Identifier('after.block'),
   Identifier('='),
   FunctionLiteral([Identifier('write$')]),
   FunctionLiteral([Identifier('output.state'), Identifier('before.all'), Identifier('='), FunctionLiteral([Identifier('write$')]), FunctionLiteral([Identifier('output.state'), Identifier('colon.after'), Identifier('='), FunctionLiteral([String(''), Identifier('*'), Identifier('write$')]), FunctionLiteral([Identifier('output.state'), Identifier('period.dash'), Identifier('='), FunctionLiteral([String(', '), Identifier('*'), Identifier('write$')]), FunctionLiteral([Identifier('output.state'), Identifier('mid.sentence'), Identifier('='), FunctionLiteral([String(' '), Identifier('*'), Identifier('write$')]), FunctionLiteral([Identifier('write$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$'), Identifier('after.block'), QuotedVar('output.state'), Identifier(':=')]),
   Identifier('if$'),
   Identifier('s')]],
 ['FUNCTION',
  [Identifier('output')],
  [Identifier('duplicate$'),
   Identifier('empty$'),
   QuotedVar('pop$'),
   QuotedVar('output.nonnull'),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('output.check')],
  [QuotedVar('t'),
   Identifier(':='),
   Identifier('duplicate$'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('pop$'), String('Empty '), Identifier('t'), Identifier('*'), String(' in '), Identifier('*'), Identifier('cite$'), Identifier('*'), Identifier('warning$')]),
   QuotedVar('output.nonnull'),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('not')],
  [FunctionLiteral([Integer(0)]),
   FunctionLiteral([Integer(1)]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('and')],
  [QuotedVar('skip$'),
   FunctionLiteral([Identifier('pop$'), Integer(0)]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('or')],
  [FunctionLiteral([Identifier('pop$'), Integer(1)]),
   QuotedVar('skip$'),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('is.num')],
  [Identifier('chr.to.int$'),
   Identifier('duplicate$'),
   String('0'),
   Identifier('chr.to.int$'),
   Identifier('<'),
   Identifier('not'),
   Identifier('swap$'),
   String('9'),
   Identifier('chr.to.int$'),
   Identifier('>'),
   Identifier('not'),
   Identifier('and')]],
 ['FUNCTION',
  [Identifier('extract.num')],
  [Identifier('duplicate$'),
   QuotedVar('t'),
   Identifier(':='),
   String(''),
   QuotedVar('s'),
   Identifier(':='),
   FunctionLiteral([Identifier('t'), Identifier('empty$'), Identifier('not')]),
   FunctionLiteral([Identifier('t'), Integer(1), Integer(1), Identifier('substring$'), Identifier('t'), Integer(2), Identifier('global.max$'), Identifier('substring$'), QuotedVar('t'), Identifier(':='), Identifier('duplicate$'), Identifier('is.num'), FunctionLiteral([Identifier('s'), Identifier('swap$'), Identifier('*'), QuotedVar('s'), Identifier(':=')]), FunctionLiteral([Identifier('pop$'), String(''), QuotedVar('t'), Identifier(':=')]), Identifier('if$')]),
   Identifier('while$'),
   Identifier('s'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('pop$'), Identifier('s')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('convert.edition.superscript')],
  [Identifier('edition'),
   Identifier('extract.num'),
   String('l'),
   Identifier('change.case$'),
   QuotedVar('s'),
   Identifier(':='),
   Identifier('s'),
   String('first'),
   Identifier('='),
   Identifier('s'),
   String('1'),
   Identifier('='),
   Identifier('or'),
   Identifier('s'),
   String('erste'),
   Identifier('='),
   Identifier('or'),
   FunctionLiteral([String('1'), QuotedVar('t'), Identifier(':=')]),
   FunctionLiteral([Identifier('s'), String('second'), Identifier('='), Identifier('s'), String('2'), Identifier('='), Identifier('or'), Identifier('s'), String('zweite'), Identifier('='), Identifier('or'), FunctionLiteral([String('2'), QuotedVar('t'), Identifier(':=')]), FunctionLiteral([Identifier('s'), String('third'), Identifier('='), Identifier('s'), String('3'), Identifier('='), Identifier('or'), Identifier('s'), String('dritte'), Identifier('='), Identifier('or'), FunctionLiteral([String('3'), QuotedVar('t'), Identifier(':=')]), FunctionLiteral([Identifier('s'), String('fourth'), Identifier('='), Identifier('s'), String('4'), Identifier('='), Identifier('or'), Identifier('s'), String('vierte'), Identifier('='), Identifier('or'), FunctionLiteral([String('4'), QuotedVar('t'), Identifier(':=')]), FunctionLiteral([Identifier('s'), String('fifth'), Identifier('='), Identifier('s'), String('5'), Identifier('='), Identifier('or'), Identifier('s'), String('fuenfte'), Identifier('='), Identifier('or'), FunctionLiteral([String('5'), QuotedVar('t'), Identifier(':=')]), FunctionLiteral([Identifier('s'), String('sixth'), Identifier('='), Identifier('s'), String('6'), Identifier('='), Identifier('or'), Identifier('s'), String('sechste'), Identifier('='), Identifier('or'), FunctionLiteral([String('6'), QuotedVar('t'), Identifier(':=')]), FunctionLiteral([Identifier('s'), String('seventh'), Identifier('='), Identifier('s'), String('7'), Identifier('='), Identifier('or'), Identifier('s'), String('siebte'), Identifier('='), Identifier('or'), Identifier('s'), String('siebente'), Identifier('='), Identifier('or'), FunctionLiteral([String('7'), QuotedVar('t'), Identifier(':=')]), FunctionLiteral([Identifier('s'), String('eighth'), Identifier('='), Identifier('s'), String('8'), Identifier('='), Identifier('or'), Identifier('s'), String('achte'), Identifier('='), Identifier('or'), FunctionLiteral([String('8'), QuotedVar('t'), Identifier(':=')]), FunctionLiteral([Identifier('s'), String('nineth'), Identifier('='), Identifier('s'), String('9'), Identifier('='), Identifier('or'), Identifier('s'), String('neunte'), Identifier('='), Identifier('or'), FunctionLiteral([String('9'), QuotedVar('t'), Identifier(':=')]), FunctionLiteral([Identifier('s'), Integer(1), Integer(1), Identifier('substring$'), Identifier('is.num'), FunctionLiteral([Identifier('s'), String(''), Identifier('*'), QuotedVar('t'), Identifier(':=')]), FunctionLiteral([Identifier('edition'), QuotedVar('t'), Identifier(':=')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$'),
   Identifier('t')]],
 ['FUNCTION',
  [Identifier('n.dashify')],
  [QuotedVar('t'),
   Identifier(':='),
   String(''),
   FunctionLiteral([Identifier('t'), Identifier('empty$'), Identifier('not')]),
   FunctionLiteral([Identifier('t'), Integer(1), Integer(1), Identifier('substring$'), String('-'), Identifier('='), FunctionLiteral([Identifier('t'), Integer(1), Integer(2), Identifier('substring$'), String('--'), Identifier('='), Identifier('not'), FunctionLiteral([String('--'), Identifier('*'), Identifier('t'), Integer(2), Identifier('global.max$'), Identifier('substring$'), QuotedVar('t'), Identifier(':=')]), FunctionLiteral([FunctionLiteral([Identifier('t'), Integer(1), Integer(1), Identifier('substring$'), String('-'), Identifier('=')]), FunctionLiteral([String('-'), Identifier('*'), Identifier('t'), Integer(2), Identifier('global.max$'), Identifier('substring$'), QuotedVar('t'), Identifier(':=')]), Identifier('while$')]), Identifier('if$')]), FunctionLiteral([Identifier('t'), Integer(1), Integer(1), Identifier('substring$'), Identifier('*'), Identifier('t'), Integer(2), Identifier('global.max$'), Identifier('substring$'), QuotedVar('t'), Identifier(':=')]), Identifier('if$')]),
   Identifier('while$')]],
 ['FUNCTION',
  [Identifier('output.bibitem.fst')],
  [Identifier('newline$'),
   String('\\bibitem[{'),
   Identifier('write$'),
   Identifier('shortauthor'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('juraauthor'), Identifier('empty$'), FunctionLiteral([Identifier('author'), Identifier('empty$'), FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([Identifier('organization'), Identifier('empty$'), FunctionLiteral([Identifier('archive'), Identifier('empty$'), FunctionLiteral([String('empty'), Identifier('write$')]), FunctionLiteral([Identifier('archive'), Identifier('write$')]), Identifier('if$')]), FunctionLiteral([Identifier('organization'), Identifier('write$')]), Identifier('if$')]), FunctionLiteral([Identifier('label'), Identifier('write$')]), Identifier('if$')]), FunctionLiteral([Identifier('label'), Identifier('write$')]), Identifier('if$')]), FunctionLiteral([Identifier('juraauthor'), Identifier('write$')]), Identifier('if$')]),
   FunctionLiteral([Identifier('shortauthor'), Identifier('write$')]),
   Identifier('if$'),
   String('}%'),
   Identifier('write$'),
   Identifier('sortkey'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('newline$'), String('% SORTKEY: ['), Identifier('sortkey'), Identifier('*'), String(']'), Identifier('*'), Identifier('write$')]),
   Identifier('if$'),
   Identifier('newline$'),
   Identifier('shorttitle'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('juratitle'), Identifier('empty$'), FunctionLiteral([Identifier('journal'), Identifier('empty$'), FunctionLiteral([String('         {}%'), Identifier('write$')]), FunctionLiteral([Identifier('volume'), Identifier('empty$'), FunctionLiteral([Identifier('year'), Identifier('empty$'), FunctionLiteral([String('         {'), Identifier('journal'), Identifier('*'), String('}%'), Identifier('*'), Identifier('write$')]), FunctionLiteral([String('         {'), Identifier('journal'), Identifier('*'), String('\\jbsy {'), Identifier('*'), Identifier('year'), Identifier('*'), String('}}%'), Identifier('*'), Identifier('write$')]), Identifier('if$')]), FunctionLiteral([Identifier('year'), Identifier('empty$'), FunctionLiteral([String('         {'), Identifier('journal'), Identifier('*'), String('}%'), Identifier('*'), Identifier('write$')]), FunctionLiteral([String('         {'), Identifier('journal'), Identifier('*'), String(' '), Identifier('*'), Identifier('volume'), Identifier('*'), String(' '), Identifier('*'), String(' \\peryearformat {'), Identifier('year'), Identifier('*'), String('}}%'), Identifier('*'), Identifier('*'), Identifier('write$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), FunctionLiteral([String('         {'), Identifier('juratitle'), Identifier('*'), String('}%'), Identifier('*'), Identifier('write$')]), Identifier('if$')]),
   FunctionLiteral([String('         {'), Identifier('shorttitle'), Identifier('*'), String('}%'), Identifier('*'), Identifier('write$')]),
   Identifier('if$'),
   Identifier('newline$'),
   Identifier('repeat-authors'),
   FunctionLiteral([String('         {{1}'), Identifier('write$')]),
   FunctionLiteral([String('         {{0}'), Identifier('write$')]),
   Identifier('if$'),
   Identifier('howcited'),
   Identifier('empty$'),
   FunctionLiteral([String('{}'), Identifier('write$')]),
   FunctionLiteral([String('{'), Identifier('howcited'), Identifier('*'), String('}'), Identifier('*'), Identifier('write$')]),
   Identifier('if$'),
   Identifier('type$'),
   Identifier('empty$'),
   FunctionLiteral([String('{}'), Identifier('write$')]),
   FunctionLiteral([String('{'), Identifier('type$'), Identifier('*'), String('}'), Identifier('*'), Identifier('write$')]),
   Identifier('if$'),
   Identifier('year'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('type$'), String('book'), Identifier('='), Identifier('dissyear'), Identifier('empty$'), Identifier('not'), Identifier('and'), FunctionLiteral([String('{'), Identifier('dissyear'), Identifier('*'), Identifier('write$'), Identifier('extra.label'), String(''), Identifier('='), Identifier('skip$'), FunctionLiteral([String('\\el {'), Identifier('write$'), Identifier('extra.label'), Identifier('write$'), String('}'), Identifier('write$')]), Identifier('if$'), String('}'), Identifier('write$')]), FunctionLiteral([String('{}'), Identifier('write$')]), Identifier('if$')]),
   FunctionLiteral([String('{'), Identifier('year'), Identifier('*'), Identifier('write$'), Identifier('extra.label'), String(''), Identifier('='), QuotedVar('skip$'), FunctionLiteral([String('\\el {'), Identifier('write$'), Identifier('extra.label'), Identifier('write$'), String('}'), Identifier('write$')]), Identifier('if$'), String('}'), Identifier('write$')]),
   Identifier('if$'),
   Identifier('edition'),
   Identifier('empty$'),
   FunctionLiteral([String('{}'), Identifier('write$')]),
   FunctionLiteral([String('{'), Identifier('convert.edition.superscript'), Identifier('extract.num'), Identifier('*'), String('}'), Identifier('*'), Identifier('write$')]),
   Identifier('if$'),
   Identifier('ssedition'),
   Identifier('empty$'),
   FunctionLiteral([String('{}'), Identifier('write$')]),
   FunctionLiteral([String('{'), Identifier('ssedition'), Identifier('*'), String('}'), Identifier('*'), Identifier('write$')]),
   Identifier('if$'),
   Identifier('language'),
   Identifier('empty$'),
   FunctionLiteral([String('{}'), Identifier('write$')]),
   FunctionLiteral([String('{'), Identifier('language'), Identifier('*'), String('}'), Identifier('*'), Identifier('write$')]),
   Identifier('if$'),
   Identifier('pages'),
   Identifier('empty$'),
   FunctionLiteral([String('{}%'), Identifier('write$')]),
   FunctionLiteral([String('{'), Identifier('write$'), Identifier('pages'), Identifier('n.dashify'), Identifier('write$'), String('}%'), Identifier('write$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('output.bibitem.snd')],
  [Identifier('newline$'),
   Identifier('publisher'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('address'), Identifier('empty$'), FunctionLiteral([Identifier('year'), Identifier('empty$'), FunctionLiteral([String('          {'), Identifier('write$')]), FunctionLiteral([String('          {'), Identifier('write$'), Identifier('year'), Identifier('write$'), Identifier('extra.label'), String(''), Identifier('='), QuotedVar('skip$'), FunctionLiteral([String('\\el {'), Identifier('write$'), Identifier('extra.label'), Identifier('write$'), String('}'), Identifier('write$')]), Identifier('if$')]), Identifier('if$')]), FunctionLiteral([Identifier('year'), Identifier('empty$'), FunctionLiteral([String('          {'), Identifier('write$'), Identifier('address'), Identifier('write$')]), FunctionLiteral([String('          {'), Identifier('write$'), Identifier('address'), Identifier('write$'), String('\\bibbdsep {} '), Identifier('write$'), Identifier('year'), Identifier('write$'), Identifier('extra.label'), String(''), Identifier('='), QuotedVar('skip$'), FunctionLiteral([String('\\el {'), Identifier('write$'), Identifier('extra.label'), Identifier('write$'), String('}'), Identifier('write$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]),
   FunctionLiteral([Identifier('address'), Identifier('empty$'), FunctionLiteral([Identifier('year'), Identifier('empty$'), FunctionLiteral([String('          {'), Identifier('write$'), Identifier('publisher'), Identifier('write$')]), FunctionLiteral([String('          {'), Identifier('write$'), Identifier('publisher'), Identifier('write$'), String('\\bibbdsep {} '), Identifier('write$'), Identifier('year'), Identifier('write$'), Identifier('extra.label'), String(''), Identifier('='), QuotedVar('skip$'), FunctionLiteral([String('\\el {'), Identifier('write$'), Identifier('extra.label'), Identifier('write$'), String('}'), Identifier('write$')]), Identifier('if$')]), Identifier('if$')]), FunctionLiteral([Identifier('year'), Identifier('empty$'), FunctionLiteral([String('          {'), Identifier('write$'), Identifier('address'), Identifier('write$'), String('\\bpubaddr {} '), Identifier('write$'), Identifier('publisher'), Identifier('write$')]), FunctionLiteral([String('          {'), Identifier('write$'), Identifier('address'), Identifier('write$'), String('\\bpubaddr {} '), Identifier('write$'), Identifier('publisher'), Identifier('write$'), String('\\bibbdsep {} '), Identifier('write$'), Identifier('year'), Identifier('write$'), Identifier('extra.label'), String(''), Identifier('='), QuotedVar('skip$'), FunctionLiteral([String('\\el {'), Identifier('write$'), Identifier('extra.label'), Identifier('write$'), String('}'), Identifier('write$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$'),
   String('}}%'),
   Identifier('write$'),
   Identifier('newline$'),
   String('         {'),
   Identifier('write$'),
   Identifier('title'),
   Identifier('empty$'),
   FunctionLiteral([String('{}%'), Identifier('write$'), Identifier('newline$')]),
   FunctionLiteral([String('{'), Identifier('title'), Identifier('*'), Identifier('type$'), String('archival'), Identifier('='), FunctionLiteral([Identifier('shortarchive'), Identifier('empty$'), Identifier('not'), FunctionLiteral([String(', In: '), Identifier('shortarchive'), Identifier('*'), Identifier('*')]), FunctionLiteral([Identifier('archive'), Identifier('empty$'), Identifier('not'), FunctionLiteral([String(', In: '), Identifier('archive'), Identifier('*'), Identifier('*')]), QuotedVar('skip$'), Identifier('if$')]), Identifier('if$'), Identifier('shortsubarchive'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String(', '), Identifier('shortsubarchive'), Identifier('*'), Identifier('*')]), Identifier('if$'), Identifier('sig1'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String(', '), Identifier('sig1'), Identifier('*'), Identifier('*'), Identifier('sig2'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String('. '), Identifier('sig2'), Identifier('*'), Identifier('*'), Identifier('sig3'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String('. '), Identifier('sig3'), Identifier('*'), Identifier('*'), Identifier('sig4'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String('. '), Identifier('sig4'), Identifier('*'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$'), Identifier('pages'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String(' \\jbArchPages {'), Identifier('pages'), Identifier('n.dashify'), Identifier('*'), String('}'), Identifier('*'), Identifier('*')]), Identifier('if$')]), QuotedVar('skip$'), Identifier('if$'), String('}%'), Identifier('*'), Identifier('write$'), Identifier('newline$')]),
   Identifier('if$'),
   Identifier('gender'),
   Identifier('empty$'),
   FunctionLiteral([String('          {}'), Identifier('write$')]),
   FunctionLiteral([String('          {'), Identifier('gender'), Identifier('*'), String('}'), Identifier('*'), Identifier('write$')]),
   Identifier('if$'),
   Identifier('oyear'),
   Identifier('empty$'),
   FunctionLiteral([String('{}'), Identifier('write$')]),
   FunctionLiteral([String('{'), Identifier('oyear'), Identifier('*'), String('}'), Identifier('*'), Identifier('write$')]),
   Identifier('if$'),
   Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([String('{4}'), Identifier('write$')]), FunctionLiteral([String('{3}'), Identifier('write$')]), Identifier('if$')]),
   FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([String('{2}'), Identifier('write$')]), FunctionLiteral([String('{1}'), Identifier('write$')]), Identifier('if$')]),
   Identifier('if$'),
   String('{}{}{}{}{}}%'),
   Identifier('write$'),
   Identifier('newline$'),
   String('        ]{'),
   Identifier('write$'),
   Identifier('cite$'),
   Identifier('write$'),
   String('}'),
   Identifier('write$'),
   Identifier('url'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('newline$'), String(' \\jburldef {'), Identifier('write$'), Identifier('cite$'), Identifier('write$'), String('}{'), Identifier('write$'), Identifier('url'), Identifier('write$'), String('}%'), Identifier('write$')]),
   Identifier('if$'),
   Identifier('newline$'),
   String(' \\jbbibargs {'),
   Identifier('write$'),
   String(''),
   Identifier('before.all'),
   QuotedVar('output.state'),
   Identifier(':=')]],
 ['FUNCTION',
  [Identifier('output.bibitem')],
  [Identifier('output.bibitem.fst'), Identifier('output.bibitem.snd')]],
 ['FUNCTION',
  [Identifier('format.note')],
  [Identifier('note'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('output.state'), Identifier('before.all'), Identifier('='), FunctionLiteral([String(' \\jbnote {} {'), Identifier('*'), Identifier('note'), Identifier('*'), String('} '), Identifier('*')]), FunctionLiteral([String(' \\jbnote {1} {'), Identifier('*'), Identifier('note'), Identifier('*'), String('} '), Identifier('*')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.endnote')],
  [Identifier('note'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([String('  \\jbendnote {'), Identifier('note'), Identifier('*'), String('}'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.juradiss.book')],
  [Identifier('dissyear'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([Identifier('type'), Identifier('empty$'), FunctionLiteral([Identifier('school'), Identifier('empty$'), FunctionLiteral([String('Dissyear but no school in '), Identifier('cite$'), Identifier('*'), Identifier('warning$'), String(' (\\alsothesisname {} \\jurthesisname'), Identifier('*'), Identifier('year'), Identifier('empty$'), Identifier('not'), Identifier('year'), Identifier('missing$'), Identifier('not'), Identifier('and'), FunctionLiteral([String('\\bibbdsep {} '), Identifier('dissyear'), Identifier('*')]), QuotedVar('skip$'), Identifier('if$'), String(')'), Identifier('*')]), FunctionLiteral([String(' (\\alsothesisname {} \\jurthesisname, '), Identifier('school'), Identifier('*'), Identifier('year'), Identifier('empty$'), Identifier('not'), Identifier('year'), Identifier('missing$'), Identifier('not'), Identifier('and'), FunctionLiteral([String('\\bibbdsep {} '), Identifier('dissyear'), Identifier('*'), Identifier('*')]), QuotedVar('skip$'), Identifier('if$'), String(')'), Identifier('*')]), Identifier('if$')]), FunctionLiteral([Identifier('school'), Identifier('empty$'), FunctionLiteral([String('Dissyear but no school in '), Identifier('cite$'), Identifier('*'), Identifier('warning$'), String(' (\\alsothesisname {} '), Identifier('type'), Identifier('*'), Identifier('year'), Identifier('empty$'), Identifier('not'), Identifier('year'), Identifier('missing$'), Identifier('not'), Identifier('and'), FunctionLiteral([String('\\bibbdsep {} '), Identifier('dissyear'), Identifier('*')]), QuotedVar('skip$'), Identifier('if$'), String(')'), Identifier('*')]), FunctionLiteral([String(' (\\alsothesisname {} '), Identifier('type'), Identifier('*'), String(', '), Identifier('school'), Identifier('*'), Identifier('*'), Identifier('year'), Identifier('empty$'), Identifier('not'), Identifier('year'), Identifier('missing$'), Identifier('not'), Identifier('and'), FunctionLiteral([String('\\bibbdsep {} '), Identifier('dissyear'), Identifier('*'), Identifier('*')]), QuotedVar('skip$'), Identifier('if$'), String(')'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.thesis')],
  [Identifier('year'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('school'), Identifier('empty$'), FunctionLiteral([String('No universtiy in '), Identifier('cite$'), Identifier('*'), Identifier('warning$')]), FunctionLiteral([String("There's a university, but no year in "), Identifier('cite$'), Identifier('*'), Identifier('warning$')]), Identifier('if$'), String('')]),
   FunctionLiteral([Identifier('type'), Identifier('empty$'), FunctionLiteral([Identifier('school'), Identifier('empty$'), FunctionLiteral([String('No university in '), Identifier('cite$'), Identifier('*'), Identifier('warning$'), Identifier('type$'), String('mastersthesis'), Identifier('='), FunctionLiteral([String('\\apyformat {\\mastersthesisname'), Identifier('*'), Identifier('address'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String(', '), Identifier('address'), Identifier('*'), Identifier('*')]), Identifier('if$'), String('\\bibbdsep {} '), Identifier('year'), Identifier('*'), String('}'), Identifier('*')]), FunctionLiteral([Identifier('type$'), String('jurthesis'), Identifier('='), FunctionLiteral([String('\\apyformat {\\jurthesisname'), Identifier('*'), Identifier('address'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String(', '), Identifier('address'), Identifier('*'), Identifier('*')]), Identifier('if$'), String('\\bibbdsep {} '), Identifier('year'), Identifier('*'), String('}'), Identifier('*')]), FunctionLiteral([String('\\apyformat {\\phdthesisname'), Identifier('*'), Identifier('address'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String(', '), Identifier('address'), Identifier('*'), Identifier('*')]), Identifier('if$'), String('\\bibbdsep {} '), Identifier('year'), Identifier('*'), String('}'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), FunctionLiteral([Identifier('type$'), String('mastersthesis'), Identifier('='), FunctionLiteral([String('\\mastersthesisname, \\apyformat {'), Identifier('school'), Identifier('*'), Identifier('address'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String(', '), Identifier('address'), Identifier('*'), Identifier('*')]), Identifier('if$'), String('\\bibbdsep {} '), Identifier('year'), Identifier('*'), Identifier('*'), String('}'), Identifier('*')]), FunctionLiteral([Identifier('type$'), String('jurthesis'), Identifier('='), FunctionLiteral([String('\\jurthesisname, \\apyformat {'), Identifier('school'), Identifier('*'), Identifier('address'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String(', '), Identifier('address'), Identifier('*'), Identifier('*')]), Identifier('if$'), String('\\bibbdsep {} '), Identifier('year'), Identifier('*'), Identifier('*'), String('}'), Identifier('*')]), FunctionLiteral([String('\\phdthesisname, \\apyformat {'), Identifier('school'), Identifier('*'), Identifier('address'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String(', '), Identifier('address'), Identifier('*'), Identifier('*')]), Identifier('if$'), String('\\bibbdsep {} '), Identifier('year'), Identifier('*'), Identifier('*'), String('}'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), FunctionLiteral([Identifier('school'), Identifier('empty$'), FunctionLiteral([String('No university in '), Identifier('cite$'), Identifier('*'), Identifier('warning$'), Identifier('type'), Identifier('address'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String(' \\apyformat {'), Identifier('address'), Identifier('*')]), Identifier('if$'), String('\\bibbdsep {} '), Identifier('*'), Identifier('*'), Identifier('year'), Identifier('*'), String('}'), Identifier('*')]), FunctionLiteral([Identifier('type'), String(' \\apyformat {'), Identifier('*'), Identifier('school'), Identifier('*'), Identifier('address'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String(', '), Identifier('address'), Identifier('*'), Identifier('*')]), Identifier('if$'), String('\\bibbdsep {} '), Identifier('year'), Identifier('*'), Identifier('*'), String('}'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('set.comma.pages.check')],
  [Identifier('year'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('pages'), Identifier('empty$'), FunctionLiteral([Identifier('url'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String(', '), Identifier('*')]), Identifier('if$')]), FunctionLiteral([String(', '), Identifier('*')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('set.period.dash')],
  [Identifier('output.state'),
   Identifier('before.all'),
   Identifier('='),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('period.dash'), QuotedVar('output.state'), Identifier(':=')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('set.period.dash.check')],
  [Identifier('empty$'),
   QuotedVar('skip$'),
   QuotedVar('set.period.dash'),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('new.sentence')],
  [Identifier('output.state'),
   Identifier('before.all'),
   Identifier('='),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('after.sentence'), QuotedVar('output.state'), Identifier(':=')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('part.of.sentence')],
  [Identifier('output.state'),
   Identifier('before.all'),
   Identifier('='),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('mid.sentence'), QuotedVar('output.state'), Identifier(':=')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('new.sentence.checka')],
  [Identifier('empty$'),
   QuotedVar('skip$'),
   QuotedVar('new.sentence'),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('field.or.null')],
  [Identifier('duplicate$'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('pop$'), String('')]),
   QuotedVar('skip$'),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('get.final.nonrightbrace.char')],
  [FunctionLiteral([Identifier('duplicate$'), Integer(-1), Integer(1), Identifier('substring$'), Identifier('duplicate$'), String('}'), Identifier('=')]),
   FunctionLiteral([Identifier('pop$'), Integer(-2), Identifier('global.max$'), Identifier('substring$')]),
   Identifier('while$'),
   Identifier('swap$'),
   Identifier('pop$')]],
 ['FUNCTION',
  [Identifier('check.punct.instead.of.add.period')],
  [Identifier('duplicate$'),
   Identifier('get.final.nonrightbrace.char'),
   Identifier('duplicate$'),
   String('.'),
   Identifier('='),
   Identifier('swap$'),
   Identifier('duplicate$'),
   String('!'),
   Identifier('='),
   Identifier('swap$'),
   String('?'),
   Identifier('='),
   Identifier('or'),
   Identifier('or'),
   FunctionLiteral([String('} '), Identifier('*')]),
   FunctionLiteral([String('}\\bibatsep\\ '), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('check.punct.instead.of.add.period.art')],
  [Identifier('duplicate$'),
   Identifier('get.final.nonrightbrace.char'),
   Identifier('duplicate$'),
   String('.'),
   Identifier('='),
   Identifier('swap$'),
   Identifier('duplicate$'),
   String('!'),
   Identifier('='),
   Identifier('swap$'),
   String('?'),
   Identifier('='),
   Identifier('or'),
   Identifier('or'),
   FunctionLiteral([String('} '), Identifier('*')]),
   FunctionLiteral([Identifier('pages'), Identifier('empty$'), Identifier('note'), Identifier('empty$'), Identifier('url'), Identifier('empty$'), Identifier('and'), Identifier('and'), FunctionLiteral([String('} '), Identifier('*')]), FunctionLiteral([Identifier('volume'), Identifier('empty$'), FunctionLiteral([Identifier('pages'), Identifier('empty$'), FunctionLiteral([String('}\\ajtsep\\ '), Identifier('*')]), FunctionLiteral([Identifier('crossref'), Identifier('missing$'), FunctionLiteral([Identifier('month'), Identifier('empty$'), FunctionLiteral([String('}\\ajtsep\\ '), Identifier('*')]), FunctionLiteral([String('}\\ajtsep '), Identifier('*')]), Identifier('if$')]), FunctionLiteral([String('}\\ajtsep '), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), FunctionLiteral([String('}\\ajtsep\\ '), Identifier('*')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('emphasize')],
  [Identifier('duplicate$'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('pop$'), String('')]),
   FunctionLiteral([String('\\bibtfont {'), Identifier('swap$'), Identifier('check.punct.instead.of.add.period'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('journaltitlemarkup')],
  [Identifier('duplicate$'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('pop$'), String('')]),
   FunctionLiteral([String('\\bibJTsep \\bibjtfont {'), Identifier('swap$'), Identifier('check.punct.instead.of.add.period.art'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('incollbooktitlemarkup')],
  [Identifier('duplicate$'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('pop$'), String('')]),
   FunctionLiteral([String('\\bibbtfont {'), Identifier('swap$'), Identifier('check.punct.instead.of.add.period'), Identifier('*')]),
   Identifier('if$')]],
 ['INTEGERS',
  [Identifier('nameptr'), Identifier('namesleft'), Identifier('numnames')]],
 ['FUNCTION',
  [Identifier('lastnamemarkup')],
  [Identifier('duplicate$'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('pop$'), String('')]),
   FunctionLiteral([String('\\bibnf {'), Identifier('swap$'), Identifier('*'), String('}'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('editorlastnamemarkup')],
  [Identifier('duplicate$'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('pop$'), String('')]),
   FunctionLiteral([Identifier('author'), Identifier('empty$'), FunctionLiteral([String('\\biblenf {'), Identifier('swap$'), Identifier('*'), String('}'), Identifier('*')]), FunctionLiteral([String('\\bibenf {'), Identifier('swap$'), Identifier('*'), String('}'), Identifier('*')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('othermarkup')],
  [Identifier('duplicate$'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('pop$'), String(' {}')]),
   FunctionLiteral([String(' {'), Identifier('swap$'), Identifier('*'), String('}'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('article.in.journal')],
  [Identifier('duplicate$'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('pop$'), String('')]),
   FunctionLiteral([Identifier('author'), Identifier('missing$'), FunctionLiteral([Identifier('title'), Identifier('missing$'), QuotedVar('skip$'), FunctionLiteral([Identifier('journaltitlemarkup'), String(''), Identifier('swap$'), Identifier('*')]), Identifier('if$')]), FunctionLiteral([Identifier('journaltitlemarkup'), String(''), Identifier('swap$'), Identifier('*')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.names')],
  [QuotedVar('s'),
   Identifier(':='),
   Integer(1),
   QuotedVar('nameptr'),
   Identifier(':='),
   Identifier('s'),
   Identifier('num.names$'),
   QuotedVar('numnames'),
   Identifier(':='),
   Identifier('numnames'),
   QuotedVar('namesleft'),
   Identifier(':='),
   FunctionLiteral([Identifier('namesleft'), Integer(0), Identifier('>')]),
   FunctionLiteral([Identifier('s'), Identifier('nameptr'), String('{ll}'), Identifier('format.name$'), QuotedVar('t'), Identifier(':='), Identifier('t'), Identifier('lastnamemarkup'), QuotedVar('t'), Identifier(':='), Identifier('s'), Identifier('nameptr'), String('{ff}'), Identifier('format.name$'), Identifier('othermarkup'), QuotedVar('u'), Identifier(':='), Identifier('s'), Identifier('nameptr'), String('{f.}'), Identifier('format.name$'), Identifier('othermarkup'), QuotedVar('v'), Identifier(':='), Identifier('s'), Identifier('nameptr'), String('{vv}'), Identifier('format.name$'), Identifier('othermarkup'), QuotedVar('w'), Identifier(':='), Identifier('s'), Identifier('nameptr'), String('{jj}'), Identifier('format.name$'), Identifier('othermarkup'), QuotedVar('x'), Identifier(':='), Identifier('t'), Identifier('u'), Identifier('*'), Identifier('v'), Identifier('*'), Identifier('w'), Identifier('*'), Identifier('x'), Identifier('*'), QuotedVar('t'), Identifier(':='), Identifier('nameptr'), Integer(1), Identifier('>'), FunctionLiteral([Identifier('namesleft'), Integer(1), Identifier('>'), FunctionLiteral([Identifier('numnames'), Integer(3), Identifier('>'), FunctionLiteral([String(''), Identifier('*')]), FunctionLiteral([Identifier('numnames'), Integer(3), Identifier('<'), FunctionLiteral([String('\\Bibbtasep '), Identifier('*'), Identifier('t'), Identifier('*')]), FunctionLiteral([String('\\Bibbfsasep '), Identifier('*'), Identifier('t'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), FunctionLiteral([Identifier('t'), String('\\bibnf {others} {} {} {} {}'), Identifier('='), Identifier('t'), String('\\bibnf {others} {} {} {} {} \\edfont {\\editorsname}'), Identifier('='), Identifier('or'), Identifier('numnames'), Integer(3), Identifier('>'), Identifier('or'), FunctionLiteral([String('\\bibIMfont {\\Bibetal}'), Identifier('*')]), FunctionLiteral([Identifier('numnames'), Integer(3), Identifier('<'), FunctionLiteral([String('\\Bibbtasep '), Identifier('*'), Identifier('t'), Identifier('*')]), FunctionLiteral([String('\\Bibbstasep '), Identifier('*'), Identifier('t'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), QuotedVar('t'), Identifier('if$'), Identifier('nameptr'), Integer(1), Identifier('+'), QuotedVar('nameptr'), Identifier(':='), Identifier('namesleft'), Integer(1), Identifier('-'), QuotedVar('namesleft'), Identifier(':=')]),
   Identifier('while$')]],
 ['FUNCTION',
  [Identifier('format.editor.names')],
  [QuotedVar('s'),
   Identifier(':='),
   Integer(1),
   QuotedVar('nameptr'),
   Identifier(':='),
   Identifier('s'),
   Identifier('num.names$'),
   QuotedVar('numnames'),
   Identifier(':='),
   Identifier('numnames'),
   QuotedVar('namesleft'),
   Identifier(':='),
   FunctionLiteral([Identifier('namesleft'), Integer(0), Identifier('>')]),
   FunctionLiteral([Identifier('s'), Identifier('nameptr'), String('{ll}'), Identifier('format.name$'), QuotedVar('t'), Identifier(':='), Identifier('t'), Identifier('editorlastnamemarkup'), QuotedVar('t'), Identifier(':='), Identifier('s'), Identifier('nameptr'), String('{ff}'), Identifier('format.name$'), Identifier('othermarkup'), QuotedVar('u'), Identifier(':='), Identifier('s'), Identifier('nameptr'), String('{f.}'), Identifier('format.name$'), Identifier('othermarkup'), QuotedVar('v'), Identifier(':='), Identifier('s'), Identifier('nameptr'), String('{vv}'), Identifier('format.name$'), Identifier('othermarkup'), QuotedVar('w'), Identifier(':='), Identifier('s'), Identifier('nameptr'), String('{jj}'), Identifier('format.name$'), Identifier('othermarkup'), QuotedVar('x'), Identifier(':='), Identifier('t'), Identifier('u'), Identifier('*'), Identifier('v'), Identifier('*'), Identifier('w'), Identifier('*'), Identifier('x'), Identifier('*'), QuotedVar('t'), Identifier(':='), Identifier('nameptr'), Integer(1), Identifier('>'), FunctionLiteral([Identifier('namesleft'), Integer(1), Identifier('>'), FunctionLiteral([Identifier('numnames'), Integer(3), Identifier('>'), FunctionLiteral([String(''), Identifier('*')]), FunctionLiteral([Identifier('numnames'), Integer(3), Identifier('<'), FunctionLiteral([String('\\Bibbtesep '), Identifier('*'), Identifier('t'), Identifier('*')]), FunctionLiteral([String('\\Bibbfsesep '), Identifier('*'), Identifier('t'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), FunctionLiteral([Identifier('t'), String('\\bibenf {others} {} {} {} {}'), Identifier('='), Identifier('t'), String('\\biblenf {others} {} {} {} {}'), Identifier('='), Identifier('or'), Identifier('t'), String('\\bibenf {others} {} {} {} {} \\edfont {\\editorsname}'), Identifier('='), Identifier('or'), Identifier('t'), String('\\biblenf {others} {} {} {} {} \\edfont {\\editorsname}'), Identifier('='), Identifier('or'), Identifier('numnames'), Integer(3), Identifier('>'), Identifier('or'), FunctionLiteral([String('\\bibIMfont {\\Bibetal}'), Identifier('*')]), FunctionLiteral([Identifier('numnames'), Integer(3), Identifier('<'), FunctionLiteral([String('\\Bibbtesep '), Identifier('*'), Identifier('t'), Identifier('*')]), FunctionLiteral([String('\\Bibbstesep '), Identifier('*'), Identifier('t'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), QuotedVar('t'), Identifier('if$'), Identifier('nameptr'), Integer(1), Identifier('+'), QuotedVar('nameptr'), Identifier(':='), Identifier('namesleft'), Integer(1), Identifier('-'), QuotedVar('namesleft'), Identifier(':=')]),
   Identifier('while$')]],
 ['FUNCTION',
  [Identifier('format.name.sig')],
  [QuotedVar('s'),
   Identifier(':='),
   Integer(1),
   QuotedVar('nameptr'),
   Identifier(':='),
   Identifier('s'),
   Identifier('num.names$'),
   QuotedVar('numnames'),
   Identifier(':='),
   Identifier('numnames'),
   QuotedVar('namesleft'),
   Identifier(':='),
   FunctionLiteral([Identifier('namesleft'), Integer(0), Identifier('>')]),
   FunctionLiteral([Identifier('s'), Identifier('nameptr'), String('{ff}{ vv}{ ll}{ jj}'), Identifier('format.name$'), QuotedVar('t'), Identifier(':='), Identifier('nameptr'), Integer(1), Identifier('>'), FunctionLiteral([Identifier('namesleft'), Integer(1), Identifier('>'), FunctionLiteral([String(''), Identifier('*'), Identifier('t'), Identifier('*')]), FunctionLiteral([Identifier('t'), String('others'), Identifier('='), FunctionLiteral([String(' et al.'), Identifier('*')]), FunctionLiteral([String(''), Identifier('*'), Identifier('t'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), QuotedVar('t'), Identifier('if$'), Identifier('nameptr'), Integer(1), Identifier('+'), QuotedVar('nameptr'), Identifier(':='), Identifier('namesleft'), Integer(1), Identifier('-'), QuotedVar('namesleft'), Identifier(':=')]),
   Identifier('while$')]],
 ['FUNCTION',
  [Identifier('indexmarkup')],
  [Identifier('duplicate$'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('pop$'), String('{}')]),
   FunctionLiteral([String('{'), Identifier('swap$'), Identifier('*'), String('}'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.names.for.index')],
  [QuotedVar('s'),
   Identifier(':='),
   Integer(1),
   QuotedVar('nameptr'),
   Identifier(':='),
   Identifier('s'),
   Identifier('num.names$'),
   QuotedVar('numnames'),
   Identifier(':='),
   Identifier('numnames'),
   QuotedVar('namesleft'),
   Identifier(':='),
   FunctionLiteral([Identifier('namesleft'), Integer(0), Identifier('>')]),
   FunctionLiteral([Identifier('s'), Identifier('nameptr'), String('{ll}'), Identifier('format.name$'), QuotedVar('t'), Identifier(':='), Identifier('t'), Identifier('indexmarkup'), QuotedVar('t'), Identifier(':='), Identifier('s'), Identifier('nameptr'), String('{ff}'), Identifier('format.name$'), Identifier('indexmarkup'), QuotedVar('u'), Identifier(':='), Identifier('s'), Identifier('nameptr'), String('{f.}'), Identifier('format.name$'), Identifier('indexmarkup'), QuotedVar('v'), Identifier(':='), Identifier('s'), Identifier('nameptr'), String('{vv}'), Identifier('format.name$'), Identifier('indexmarkup'), QuotedVar('w'), Identifier(':='), Identifier('s'), Identifier('nameptr'), String('{jj}'), Identifier('format.name$'), Identifier('indexmarkup'), QuotedVar('x'), Identifier(':='), Identifier('t'), Identifier('u'), Identifier('*'), Identifier('v'), Identifier('*'), Identifier('w'), Identifier('*'), Identifier('x'), Identifier('*'), QuotedVar('t'), Identifier(':='), Identifier('t'), String('{others}{}{}{}{}'), Identifier('='), QuotedVar('skip$'), FunctionLiteral([Identifier('nameptr'), Integer(1), Identifier('>'), FunctionLiteral([Identifier('namesleft'), Integer(1), Identifier('>'), FunctionLiteral([String('; '), Identifier('*'), Identifier('t'), Identifier('*')]), FunctionLiteral([Identifier('t'), String('others'), Identifier('='), QuotedVar('skip$'), FunctionLiteral([String('; '), Identifier('*'), Identifier('t'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), QuotedVar('t'), Identifier('if$')]), Identifier('if$'), Identifier('nameptr'), Integer(1), Identifier('+'), QuotedVar('nameptr'), Identifier(':='), Identifier('namesleft'), Integer(1), Identifier('-'), QuotedVar('namesleft'), Identifier(':=')]),
   Identifier('while$')]],
 ['FUNCTION',
  [Identifier('format.authors')],
  [Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([Identifier('author'), Identifier('format.names')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.founders')],
  [Identifier('founder'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('author'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String(' in: '), Identifier('*')]), Identifier('if$'), Identifier('founder'), Identifier('format.names'), String('\\foundername'), Identifier('*'), Identifier('*'), Identifier('editor'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('author'), Identifier('empty$'), FunctionLiteral([String('\\afterfoundersep {}'), Identifier('*')]), QuotedVar('skip$'), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.editors')],
  [Identifier('editor'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([Identifier('author'), Identifier('empty$'), FunctionLiteral([Identifier('editor'), Identifier('format.editor.names'), Identifier('editortype'), Identifier('empty$'), FunctionLiteral([Identifier('editor'), Identifier('num.names$'), Integer(1), Identifier('>'), FunctionLiteral([String('\\fsted {\\editorsname}'), Identifier('*')]), FunctionLiteral([String('\\fsted {\\editorname}'), Identifier('*')]), Identifier('if$')]), FunctionLiteral([String('\\fsted {('), Identifier('editortype'), Identifier('*'), String(')}'), Identifier('*'), Identifier('*')]), Identifier('if$')]), FunctionLiteral([Identifier('founder'), Identifier('empty$'), FunctionLiteral([String('\\bibfnfont {;} '), Identifier('*')]), FunctionLiteral([Identifier('type$'), String('commented'), Identifier('='), FunctionLiteral([String('\\afterfoundersep {}'), Identifier('*')]), FunctionLiteral([String('\\bibfnfont {;} '), Identifier('*')]), Identifier('if$')]), Identifier('if$'), Identifier('editor'), Identifier('format.editor.names'), Identifier('*'), Identifier('editortype'), Identifier('empty$'), FunctionLiteral([Identifier('editor'), Identifier('num.names$'), Integer(1), Identifier('>'), FunctionLiteral([String(' \\edfont {\\editorsname}'), Identifier('*')]), FunctionLiteral([String(' \\edfont {\\editorname}'), Identifier('*')]), Identifier('if$')]), FunctionLiteral([String(' \\edfont {('), Identifier('editortype'), Identifier('*'), String(')}'), Identifier('*'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.snd.editors')],
  [Identifier('editor'),
   Identifier('empty$'),
   FunctionLiteral([String(''), Identifier('*')]),
   FunctionLiteral([Identifier('author'), Identifier('empty$'), FunctionLiteral([Identifier('editortype'), Identifier('empty$'), FunctionLiteral([Identifier('editor'), Identifier('num.names$'), Integer(1), Identifier('>'), FunctionLiteral([String('\\snded {\\sndeditorsname}'), Identifier('*')]), FunctionLiteral([String('\\snded {\\sndeditorname}'), Identifier('*')]), Identifier('if$')]), FunctionLiteral([String('\\snded {('), Identifier('editortype'), Identifier('*'), String(')}'), Identifier('*'), Identifier('*')]), Identifier('if$')]), QuotedVar('skip$'), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.howcited')],
  [String('} {\\bibhowcited}'),
   Identifier('format.endnote'),
   Identifier('*')]],
 ['FUNCTION',
  [Identifier('fin.entry.endnote')],
  [String(' \\jbdoitem {'),
   Identifier('*'),
   Identifier('author'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('author'), Identifier('format.names.for.index'), Identifier('*')]),
   Identifier('if$'),
   String('} {'),
   Identifier('editor'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('editor'), Identifier('format.names.for.index'), Identifier('*')]),
   Identifier('if$'),
   String('} {'),
   Identifier('*'),
   Identifier('organization'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([String('{'), Identifier('organization'), Identifier('*'), String('}{}{}{}{}'), Identifier('*'), Identifier('*')]),
   Identifier('if$'),
   String('}'),
   Identifier('*'),
   Identifier('*'),
   Identifier('write$'),
   Identifier('annote'),
   Identifier('missing$'),
   FunctionLiteral([String(' \\bibAnnoteFile {'), Identifier('cite$'), Identifier('*'), String('}'), Identifier('*'), Identifier('write$'), Identifier('newline$')]),
   FunctionLiteral([String(' \\bibAnnote {'), Identifier('annote'), Identifier('*'), String('}'), Identifier('*'), Identifier('write$'), Identifier('newline$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('count.authors.or.editors')],
  [QuotedVar('s'),
   Identifier(':='),
   Integer(1),
   QuotedVar('nameptr'),
   Identifier(':='),
   Identifier('s'),
   Identifier('num.names$'),
   QuotedVar('numnames'),
   Identifier(':='),
   Identifier('numnames'),
   QuotedVar('namesleft'),
   Identifier(':='),
   FunctionLiteral([Identifier('namesleft'), Integer(0), Identifier('>')]),
   FunctionLiteral([String(''), QuotedVar('t'), Identifier(':='), Identifier('nameptr'), Integer(1), Identifier('>'), FunctionLiteral([Identifier('namesleft'), Integer(1), Identifier('>'), FunctionLiteral([String(''), Identifier('*')]), FunctionLiteral([String('s'), Identifier('*')]), Identifier('if$')]), QuotedVar('t'), Identifier('if$'), Identifier('nameptr'), Integer(1), Identifier('+'), QuotedVar('nameptr'), Identifier(':='), Identifier('namesleft'), Integer(1), Identifier('-'), QuotedVar('namesleft'), Identifier(':=')]),
   Identifier('while$')]],
 ['FUNCTION',
  [Identifier('set.after.author.sep')],
  [Identifier('author'),
   Identifier('missing$'),
   FunctionLiteral([Identifier('editor'), Identifier('missing$'), FunctionLiteral([Identifier('organization'), Identifier('missing$'), FunctionLiteral([Identifier('archive'), Identifier('missing$'), FunctionLiteral([String('} {empty} {} {')]), FunctionLiteral([String('} {'), Identifier('archive'), Identifier('format.name.sig'), Identifier('*'), String('} {} {'), Identifier('*')]), Identifier('if$')]), FunctionLiteral([String('} {'), Identifier('organization'), String('} {org} {'), Identifier('*'), Identifier('*')]), Identifier('if$')]), FunctionLiteral([String('} {'), Identifier('editor'), Identifier('format.name.sig'), Identifier('*'), String('} {ed'), Identifier('editor'), Identifier('count.authors.or.editors'), String('} {'), Identifier('*'), Identifier('*'), Identifier('*')]), Identifier('if$')]),
   FunctionLiteral([String('} {'), Identifier('author'), Identifier('format.name.sig'), Identifier('*'), String('} {au'), Identifier('author'), Identifier('count.authors.or.editors'), String('} {'), Identifier('*'), Identifier('*'), Identifier('*')]),
   Identifier('if$'),
   Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('format.snd.editors')]),
   QuotedVar('skip$'),
   Identifier('if$'),
   String(''),
   Identifier('*')]],
 ['FUNCTION',
  [Identifier('format.names.info')],
  [QuotedVar('s'),
   Identifier(':='),
   Integer(1),
   QuotedVar('nameptr'),
   Identifier(':='),
   Identifier('s'),
   Identifier('num.names$'),
   QuotedVar('numnames'),
   Identifier(':='),
   Identifier('numnames'),
   QuotedVar('namesleft'),
   Identifier(':='),
   FunctionLiteral([Identifier('namesleft'), Integer(0), Identifier('>')]),
   FunctionLiteral([Identifier('s'), Identifier('nameptr'), String('{ff }{vv }{ll}'), Identifier('format.name$'), QuotedVar('t'), Identifier(':='), Identifier('nameptr'), Integer(1), Identifier('>'), FunctionLiteral([Identifier('namesleft'), Integer(1), Identifier('>'), FunctionLiteral([String(' '), Identifier('*'), Identifier('t'), Identifier('*')]), FunctionLiteral([Identifier('t'), String('others'), Identifier('='), FunctionLiteral([String(' et al.'), Identifier('*')]), FunctionLiteral([String(' '), Identifier('*'), Identifier('t'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), QuotedVar('t'), Identifier('if$'), Identifier('nameptr'), Integer(1), Identifier('+'), QuotedVar('nameptr'), Identifier(':='), Identifier('namesleft'), Integer(1), Identifier('-'), QuotedVar('namesleft'), Identifier(':=')]),
   Identifier('while$')]],
 ['FUNCTION',
  [Identifier('format.howcited.comment')],
  [Identifier('edition'),
   Identifier('empty$'),
   FunctionLiteral([String('} {\\bibcommenthowcited}'), Identifier('format.endnote'), Identifier('*')]),
   FunctionLiteral([String('} {\\bibcommenthowcited}'), Identifier('format.endnote'), Identifier('*'), Identifier('*'), Identifier('author'), Identifier('empty$'), Identifier('editor'), Identifier('empty$'), Identifier('not'), Identifier('and'), FunctionLiteral([String(' \\jbauthorinfo {'), Identifier('editor'), Identifier('format.names.info'), String(' '), Identifier('title'), Identifier('*'), Identifier('*'), Identifier('*'), String('}{'), Identifier('cite$'), String('}'), Identifier('*'), Identifier('*'), Identifier('*')]), FunctionLiteral([Identifier('author'), Identifier('empty$'), Identifier('shortauthor'), Identifier('empty$'), Identifier('not'), Identifier('and'), FunctionLiteral([String(' \\jbauthorinfo {'), Identifier('shortauthor'), Identifier('format.names.info'), String(' '), Identifier('title'), Identifier('*'), Identifier('*'), Identifier('*'), String('}{'), Identifier('cite$'), String('}'), Identifier('*'), Identifier('*'), Identifier('*')]), FunctionLiteral([String(' \\jbauthorinfo {'), Identifier('author'), Identifier('format.names.info'), String(' '), Identifier('title'), Identifier('*'), Identifier('*'), Identifier('*'), String('}{'), Identifier('cite$'), String('}'), Identifier('*'), Identifier('*'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.howcited.artperiod')],
  [String('} {\\bibartperiodhowcited}'),
   Identifier('format.endnote'),
   Identifier('*')]],
 ['FUNCTION',
  [Identifier('format.proceed.organization')],
  [Identifier('organization'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([Identifier('organization'), String(' \\organizationname {}'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.titleaddon')],
  [Identifier('title'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([Identifier('titleaddon'), Identifier('empty$'), FunctionLiteral([String('')]), FunctionLiteral([Identifier('titleaddon'), String('\\bibatsep\\ '), Identifier('*')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.title')],
  [Identifier('title'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([String('\\bibtfont {'), Identifier('title'), Identifier('check.punct.instead.of.add.period'), Identifier('*'), Identifier('format.titleaddon'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.artperiodincoll.title')],
  [Identifier('title'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([String('\\bibapifont {'), Identifier('title'), Identifier('check.punct.instead.of.add.period'), Identifier('*'), Identifier('format.titleaddon'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.volumetitle')],
  [Identifier('volumetitle'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([Identifier('volume'), Identifier('empty$'), FunctionLiteral([String("There's a volumetitle but no volume in "), Identifier('cite$'), Identifier('*'), Identifier('warning$'), Identifier('volumetitle'), String(', '), Identifier('*')]), FunctionLiteral([Identifier('volumetitle'), String(', '), Identifier('*')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('add.extra.label')],
  [Identifier('extra.label'),
   String(''),
   Identifier('='),
   QuotedVar('skip$'),
   FunctionLiteral([String('\\bibel {'), Identifier('extra.label'), Identifier('*'), String('}'), Identifier('*'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.date')],
  [Identifier('year'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('month'), Identifier('empty$'), FunctionLiteral([String('')]), FunctionLiteral([String("There's a month but no year in "), Identifier('cite$'), Identifier('*'), Identifier('warning$'), Identifier('month')]), Identifier('if$')]),
   FunctionLiteral([Identifier('month'), Identifier('empty$'), FunctionLiteral([Identifier('edition'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String('\\jbssedbd {'), Identifier('convert.edition.superscript'), Identifier('extract.num'), Identifier('*'), String('}'), Identifier('*'), Identifier('*')]), Identifier('if$'), Identifier('year'), Identifier('add.extra.label')]), FunctionLiteral([Identifier('month'), String(' '), Identifier('*'), Identifier('edition'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String('\\jbssedbd {'), Identifier('convert.edition.superscript'), Identifier('extract.num'), Identifier('*'), String('}'), Identifier('*'), Identifier('*')]), Identifier('if$'), Identifier('year'), Identifier('*'), Identifier('add.extra.label')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.update')],
  [Identifier('updated'),
   Identifier('missing$'),
   Identifier('not'),
   FunctionLiteral([String('\\updatesep {} \\updatename {} '), Identifier('*'), Identifier('updated'), Identifier('*')]),
   QuotedVar('skip$'),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('oaddress.opublisher.oyear.format')],
  [Identifier('type$'),
   String('book'),
   Identifier('='),
   Identifier('type$'),
   String('inbook'),
   Identifier('='),
   Identifier('type$'),
   String('incollection'),
   Identifier('='),
   Identifier('or'),
   Identifier('or'),
   FunctionLiteral([Identifier('oyear'), Identifier('empty$'), FunctionLiteral([Identifier('opublisher'), Identifier('empty$'), FunctionLiteral([Identifier('oaddress'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('oaddress'), String('\\osep {} '), Identifier('*'), Identifier('*')]), Identifier('if$')]), FunctionLiteral([Identifier('oaddress'), Identifier('empty$'), FunctionLiteral([Identifier('opublisher'), String('\\osep {} '), Identifier('*'), Identifier('*')]), FunctionLiteral([Identifier('oaddress'), String('\\bpubaddr {} '), Identifier('*'), Identifier('opublisher'), String('\\osep {} '), Identifier('*'), Identifier('*'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), FunctionLiteral([Identifier('year'), Identifier('empty$'), FunctionLiteral([String('oyear without year in '), Identifier('cite$'), Identifier('*'), Identifier('warning$')]), QuotedVar('skip$'), Identifier('if$'), Identifier('opublisher'), Identifier('empty$'), FunctionLiteral([Identifier('oaddress'), Identifier('empty$'), FunctionLiteral([Identifier('oyear'), Identifier('*'), String('\\osep {} \\reprintname {}, '), Identifier('*')]), FunctionLiteral([Identifier('oaddress'), String('\\bibbdsep {} '), Identifier('*'), Identifier('oyear'), String('\\osep {} '), Identifier('*'), Identifier('*'), Identifier('*')]), Identifier('if$')]), FunctionLiteral([Identifier('oaddress'), Identifier('empty$'), FunctionLiteral([Identifier('opublisher'), Identifier('*'), String('\\bibbdsep {} '), Identifier('*'), Identifier('oyear'), String('\\osep {} '), Identifier('*'), Identifier('*')]), FunctionLiteral([Identifier('oaddress'), String('\\bpubaddr {} '), Identifier('*'), Identifier('opublisher'), String('\\bibbdsep {} '), Identifier('*'), Identifier('*'), Identifier('oyear'), String('\\osep {} '), Identifier('*'), Identifier('*'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]),
   QuotedVar('skip$'),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('make.translators')],
  [Identifier('before.all'),
   QuotedVar('output.state'),
   Identifier(':='),
   Identifier('translator'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('flanguage'), Identifier('empty$'), FunctionLiteral([String('')]), FunctionLiteral([String('\\translator {}{'), Identifier('flanguage'), String('l'), Identifier('change.case$'), Identifier('*'), String('}'), Identifier('*'), Identifier('type$'), String('incollection'), Identifier('='), Identifier('not'), Identifier('type$'), String('article'), Identifier('='), Identifier('not'), Identifier('and'), FunctionLiteral([String('{1} '), Identifier('*')]), FunctionLiteral([Identifier('type$'), String('incollection'), Identifier('='), FunctionLiteral([Identifier('booktitle'), Identifier('empty$'), FunctionLiteral([String('{} '), Identifier('*')]), FunctionLiteral([String('{1} '), Identifier('*')]), Identifier('if$')]), FunctionLiteral([Identifier('type$'), String('article'), Identifier('='), FunctionLiteral([String('{1}'), Identifier('*')]), FunctionLiteral([Identifier('series'), Identifier('empty$'), FunctionLiteral([String('{} '), Identifier('*')]), FunctionLiteral([String('{1} '), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]),
   FunctionLiteral([String('\\translator {'), Identifier('translator'), Identifier('*'), String('}'), Identifier('*'), Identifier('flanguage'), Identifier('empty$'), FunctionLiteral([String('{}'), Identifier('*')]), FunctionLiteral([String('{'), Identifier('*'), Identifier('flanguage'), String('l'), Identifier('change.case$'), Identifier('*'), String('}'), Identifier('*')]), Identifier('if$'), Identifier('type$'), String('incollection'), Identifier('='), Identifier('not'), Identifier('type$'), String('article'), Identifier('='), Identifier('not'), Identifier('and'), FunctionLiteral([String('{1} '), Identifier('*')]), FunctionLiteral([Identifier('type$'), String('incollection'), Identifier('='), FunctionLiteral([Identifier('booktitle'), Identifier('empty$'), FunctionLiteral([String('{} '), Identifier('*')]), FunctionLiteral([String('{1} '), Identifier('*')]), Identifier('if$')]), FunctionLiteral([Identifier('type$'), String('article'), Identifier('='), FunctionLiteral([String('{1} '), Identifier('*')]), FunctionLiteral([Identifier('series'), Identifier('empty$'), FunctionLiteral([String('{} '), Identifier('*')]), FunctionLiteral([String('{1} '), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$'),
   Identifier('before.all'),
   QuotedVar('output.state'),
   Identifier(':=')]],
 ['FUNCTION',
  [Identifier('checked.inst')],
  [Identifier('institution'),
   Identifier('empty$'),
   FunctionLiteral([String(' \\apyformat {'), Identifier('*'), Identifier('oaddress.opublisher.oyear.format')]),
   FunctionLiteral([Identifier('address'), Identifier('empty$'), Identifier('not'), FunctionLiteral([String(' \\apyformat {'), Identifier('*')]), QuotedVar('skip$'), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.address.publisher.year')],
  [Identifier('publisher'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('address'), Identifier('empty$'), FunctionLiteral([Identifier('year'), Identifier('empty$'), FunctionLiteral([String('Neither address nor year in '), Identifier('cite$'), Identifier('*'), Identifier('warning$'), String('')]), FunctionLiteral([String('No address in '), Identifier('cite$'), Identifier('*'), Identifier('warning$'), Identifier('institution'), Identifier('empty$'), FunctionLiteral([String(' \\apyformat {'), Identifier('oaddress.opublisher.oyear.format'), Identifier('format.date'), Identifier('*'), String('}'), Identifier('*')]), FunctionLiteral([String(' \\apyformat {'), Identifier('institution'), Identifier('*'), String('\\bibbdsep {} '), Identifier('*'), Identifier('format.date'), String('}'), Identifier('*'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), FunctionLiteral([Identifier('year'), Identifier('empty$'), FunctionLiteral([Identifier('checked.inst'), Identifier('address'), String('}'), Identifier('*')]), FunctionLiteral([Identifier('checked.inst'), Identifier('address'), String('\\bibbdsep {} '), Identifier('format.date'), Identifier('*'), String('}'), Identifier('*'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]),
   FunctionLiteral([Identifier('address'), Identifier('empty$'), FunctionLiteral([Identifier('year'), Identifier('empty$'), FunctionLiteral([String("There's only a publisher (no address, no year) in "), Identifier('cite$'), Identifier('*'), Identifier('warning$'), Identifier('publisher')]), FunctionLiteral([Identifier('checked.inst'), Identifier('publisher'), String('\\bibbdsep {} '), Identifier('*'), Identifier('format.date'), String('}'), Identifier('*'), Identifier('*')]), Identifier('if$')]), FunctionLiteral([Identifier('year'), Identifier('empty$'), FunctionLiteral([Identifier('checked.inst'), Identifier('address'), Identifier('*'), String('\\bpubaddr {} '), Identifier('publisher'), String('}'), Identifier('*'), Identifier('*')]), FunctionLiteral([Identifier('checked.inst'), Identifier('address'), Identifier('*'), String('\\bpubaddr {} '), Identifier('publisher'), String('\\bibbdsep {} '), Identifier('*'), Identifier('format.date'), String('}'), Identifier('*'), Identifier('*'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.howpublished.address.year')],
  [Identifier('howpublished'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('address'), Identifier('empty$'), FunctionLiteral([Identifier('year'), Identifier('empty$'), FunctionLiteral([String('Neither address nor year in '), Identifier('cite$'), Identifier('*'), Identifier('warning$'), String('')]), FunctionLiteral([String('No address in '), Identifier('cite$'), Identifier('*'), Identifier('warning$'), Identifier('format.date')]), Identifier('if$')]), FunctionLiteral([String(' \\apyformat {'), Identifier('oaddress.opublisher.oyear.format'), Identifier('address'), Identifier('*'), String('\\bibbdsep {} '), Identifier('*'), Identifier('format.date'), String('}'), Identifier('*'), Identifier('*')]), Identifier('if$')]),
   FunctionLiteral([Identifier('address'), Identifier('empty$'), FunctionLiteral([Identifier('year'), Identifier('empty$'), FunctionLiteral([String("There's only a howpublished (no address, no year) in "), Identifier('cite$'), Identifier('*'), Identifier('warning$'), Identifier('howpublished')]), FunctionLiteral([String(' \\apyformat {'), Identifier('oaddress.opublisher.oyear.format'), Identifier('howpublished'), Identifier('*'), String('\\bibbdsep {} '), Identifier('*'), Identifier('format.date'), String('}'), Identifier('*'), Identifier('*')]), Identifier('if$')]), FunctionLiteral([Identifier('year'), Identifier('empty$'), FunctionLiteral([String(' \\apyformat {'), Identifier('oaddress.opublisher.oyear.format'), Identifier('address'), Identifier('*'), String('\\bpubaddr {} '), Identifier('*'), Identifier('howpublished'), String('}'), Identifier('*'), Identifier('*')]), FunctionLiteral([String(' \\apyformat {'), Identifier('oaddress.opublisher.oyear.format'), Identifier('address'), Identifier('*'), String('\\bpubaddr {} '), Identifier('*'), Identifier('howpublished'), Identifier('*'), String('\\bibbdsep {} '), Identifier('*'), Identifier('format.date'), String('}'), Identifier('*'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('tie.or.space.connect')],
  [Identifier('duplicate$'),
   Identifier('text.length$'),
   Integer(4),
   Identifier('<'),
   FunctionLiteral([String('~')]),
   FunctionLiteral([String(' ')]),
   Identifier('if$'),
   Identifier('swap$'),
   Identifier('*'),
   Identifier('*')]],
 ['FUNCTION',
  [Identifier('bibvol.tie.or.space.connect')],
  [Identifier('duplicate$'),
   Identifier('text.length$'),
   Integer(4),
   Identifier('<'),
   FunctionLiteral([String('~')]),
   FunctionLiteral([String('{} ')]),
   Identifier('if$'),
   Identifier('swap$'),
   Identifier('*'),
   Identifier('*')]],
 ['FUNCTION',
  [Identifier('format.btitle')],
  [Identifier('title'),
   Identifier('emphasize'),
   Identifier('format.titleaddon'),
   Identifier('*')]],
 ['FUNCTION',
  [Identifier('format.btitle.vol')],
  [Identifier('number'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('series'), Identifier('empty$'), FunctionLiteral([Identifier('volume'), Identifier('empty$'), FunctionLiteral([Identifier('title'), Identifier('emphasize'), Identifier('format.titleaddon'), Identifier('*')]), FunctionLiteral([Identifier('title'), Identifier('emphasize'), Identifier('format.titleaddon'), Identifier('*'), String(' \\volumeformat {'), Identifier('volume'), Identifier('*'), String('} '), Identifier('*'), Identifier('*')]), Identifier('if$')]), FunctionLiteral([Identifier('volume'), Identifier('empty$'), FunctionLiteral([Identifier('title'), Identifier('emphasize'), Identifier('format.titleaddon'), Identifier('*')]), FunctionLiteral([Identifier('title'), Identifier('emphasize'), Identifier('format.titleaddon'), Identifier('*'), String('\\volumeformat {'), Identifier('volume'), Identifier('*'), String('} '), Identifier('*'), Identifier('*'), Identifier('series'), String('\\bibatsep\\ '), Identifier('*'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]),
   FunctionLiteral([Identifier('title'), Identifier('emphasize'), Identifier('format.titleaddon'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.btitle.vol.inbook')],
  [Identifier('number'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('series'), Identifier('empty$'), FunctionLiteral([Identifier('volume'), Identifier('empty$'), FunctionLiteral([String('\\bibapifont {'), Identifier('title'), Identifier('check.punct.instead.of.add.period'), Identifier('*'), Identifier('format.titleaddon'), Identifier('*')]), FunctionLiteral([String('\\bibapifont {'), Identifier('title'), Identifier('check.punct.instead.of.add.period'), Identifier('*'), Identifier('format.titleaddon'), Identifier('*'), String(' \\volumeformat {'), Identifier('volume'), Identifier('*'), String('} '), Identifier('*'), Identifier('*')]), Identifier('if$')]), FunctionLiteral([Identifier('volume'), Identifier('empty$'), FunctionLiteral([String('\\bibapifont {'), Identifier('title'), Identifier('check.punct.instead.of.add.period'), Identifier('*'), Identifier('format.titleaddon'), Identifier('*')]), FunctionLiteral([Identifier('series'), Identifier('emphasize'), String('\\volumeformat {'), Identifier('volume'), Identifier('*'), String('} '), Identifier('*'), Identifier('*'), String('\\bibapifont {'), Identifier('title'), Identifier('check.punct.instead.of.add.period'), Identifier('*'), Identifier('format.titleaddon'), Identifier('*'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]),
   FunctionLiteral([String('\\bibapifont {'), Identifier('title'), Identifier('check.punct.instead.of.add.period'), Identifier('*'), Identifier('format.titleaddon'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.url')],
  [Identifier('url'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([Identifier('author'), Identifier('empty$'), Identifier('title'), Identifier('empty$'), Identifier('and'), QuotedVar('skip$'), FunctionLiteral([String(' '), Identifier('*')]), Identifier('if$'), Identifier('urldate'), Identifier('empty$'), FunctionLiteral([String('\\jburluse {'), Identifier('cite$'), Identifier('*'), String('}'), Identifier('*')]), FunctionLiteral([String('\\jburluse {'), Identifier('cite$'), Identifier('*'), String('}\\bibbudcsep {}\\urldatecomment '), Identifier('*'), Identifier('urldate'), Identifier('*')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.naked.url')],
  [Identifier('url'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([Identifier('urldate'), Identifier('empty$'), FunctionLiteral([Identifier('title'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('title'), Identifier('emphasize'), Identifier('*')]), Identifier('if$'), String('\\jburluse {'), Identifier('cite$'), Identifier('*'), String('}'), Identifier('*')]), FunctionLiteral([Identifier('title'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('title'), Identifier('emphasize'), Identifier('*')]), Identifier('if$'), String('\\jburluse {'), Identifier('cite$'), Identifier('*'), String('}\\bibbudcsep {}\\urldatecomment '), Identifier('*'), Identifier('urldate'), Identifier('*')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.series.number')],
  [Identifier('volume'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('number'), Identifier('empty$'), FunctionLiteral([Identifier('series'), Identifier('empty$'), FunctionLiteral([String('')]), FunctionLiteral([String(' \\numberandseries {}{'), Identifier('series'), Identifier('*'), String('}'), Identifier('*')]), Identifier('if$')]), FunctionLiteral([Identifier('series'), Identifier('empty$'), FunctionLiteral([String(' \\numberandseries {'), Identifier('number'), Identifier('*'), String('}{}'), Identifier('*'), String("There's a number but no series in "), Identifier('cite$'), Identifier('*'), Identifier('warning$')]), FunctionLiteral([String(' \\numberandseries {'), Identifier('number'), Identifier('*'), String('}{'), Identifier('*'), Identifier('series'), String('}'), Identifier('*'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]),
   FunctionLiteral([Identifier('series'), Identifier('empty$'), FunctionLiteral([String('')]), FunctionLiteral([Identifier('type$'), String('proceedings'), Identifier('='), FunctionLiteral([String(' \\numberandseries {}{'), Identifier('series'), Identifier('*'), String('}'), Identifier('*')]), FunctionLiteral([String('')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION', [Identifier('first.ed')], [String('\\firstedname')]],
 ['FUNCTION', [Identifier('second.ed')], [String('\\secondedname')]],
 ['FUNCTION', [Identifier('third.ed')], [String('\\thirdedname')]],
 ['FUNCTION', [Identifier('fourth.ed')], [String('\\fourthedname')]],
 ['FUNCTION', [Identifier('fifth.ed')], [String('\\fifthedname')]],
 ['FUNCTION', [Identifier('th.ed')], [String('\\thedname')]],
 ['FUNCTION',
  [Identifier('convert.edition')],
  [Identifier('edition'),
   Identifier('extract.num'),
   String('l'),
   Identifier('change.case$'),
   QuotedVar('s'),
   Identifier(':='),
   Identifier('s'),
   String('first'),
   Identifier('='),
   Identifier('s'),
   String('1'),
   Identifier('='),
   Identifier('or'),
   FunctionLiteral([Identifier('first.ed'), QuotedVar('t'), Identifier(':=')]),
   FunctionLiteral([Identifier('s'), String('second'), Identifier('='), Identifier('s'), String('2'), Identifier('='), Identifier('or'), FunctionLiteral([Identifier('second.ed'), QuotedVar('t'), Identifier(':=')]), FunctionLiteral([Identifier('s'), String('third'), Identifier('='), Identifier('s'), String('3'), Identifier('='), Identifier('or'), FunctionLiteral([Identifier('third.ed'), QuotedVar('t'), Identifier(':=')]), FunctionLiteral([Identifier('s'), String('fourth'), Identifier('='), Identifier('s'), String('4'), Identifier('='), Identifier('or'), FunctionLiteral([Identifier('fourth.ed'), QuotedVar('t'), Identifier(':=')]), FunctionLiteral([Identifier('s'), String('fifth'), Identifier('='), Identifier('s'), String('5'), Identifier('='), Identifier('or'), FunctionLiteral([Identifier('fifth.ed'), QuotedVar('t'), Identifier(':=')]), FunctionLiteral([Identifier('s'), Integer(1), Integer(1), Identifier('substring$'), Identifier('is.num'), FunctionLiteral([Identifier('s'), Identifier('th.ed'), Identifier('*'), QuotedVar('t'), Identifier(':=')]), FunctionLiteral([Identifier('edition'), QuotedVar('t'), Identifier(':=')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$'),
   Identifier('t')]],
 ['FUNCTION',
  [Identifier('format.edition')],
  [Identifier('edition'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([String('\\jbedition {'), Identifier('*'), Identifier('convert.edition'), String('~\\editionname {}\\jbaensep} '), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.isbn.issn')],
  [Identifier('isbn'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('issn'), Identifier('empty$'), FunctionLiteral([String('')]), FunctionLiteral([String('\\jbissn {'), Identifier('issn'), Identifier('n.dashify'), Identifier('*'), String('}'), Identifier('*')]), Identifier('if$')]),
   FunctionLiteral([String('\\jbisbn {'), Identifier('isbn'), Identifier('n.dashify'), Identifier('*'), String('}'), Identifier('*')]),
   Identifier('if$')]],
 ['INTEGERS', [Identifier('multiresult')]],
 ['FUNCTION',
  [Identifier('multi.page.check')],
  [QuotedVar('t'),
   Identifier(':='),
   Integer(0),
   QuotedVar('multiresult'),
   Identifier(':='),
   FunctionLiteral([Identifier('multiresult'), Identifier('not'), Identifier('t'), Identifier('empty$'), Identifier('not'), Identifier('and')]),
   FunctionLiteral([Identifier('t'), Integer(1), Integer(1), Identifier('substring$'), Identifier('duplicate$'), String('-'), Identifier('='), Identifier('swap$'), Identifier('duplicate$'), String(','), Identifier('='), Identifier('swap$'), String('+'), Identifier('='), Identifier('or'), Identifier('or'), FunctionLiteral([Integer(1), QuotedVar('multiresult'), Identifier(':=')]), FunctionLiteral([Identifier('t'), Integer(2), Identifier('global.max$'), Identifier('substring$'), QuotedVar('t'), Identifier(':=')]), Identifier('if$')]),
   Identifier('while$'),
   Identifier('multiresult')]],
 ['FUNCTION',
  [Identifier('format.pages')],
  [Identifier('pages'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([String(' \\jbPages{'), Identifier('pages'), Identifier('n.dashify'), Identifier('*'), String('}'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('multi.pagerange.check')],
  [QuotedVar('t'),
   Identifier(':='),
   Integer(0),
   QuotedVar('multiresult'),
   Identifier(':='),
   FunctionLiteral([Identifier('multiresult'), Identifier('not'), Identifier('t'), Identifier('empty$'), Identifier('not'), Identifier('and')]),
   FunctionLiteral([Identifier('t'), Integer(1), Integer(1), Identifier('substring$'), Identifier('duplicate$'), String('-'), Identifier('='), Identifier('swap$'), Identifier('duplicate$'), String('b'), Identifier('='), Identifier('swap$'), String('/'), Identifier('='), Identifier('or'), Identifier('or'), FunctionLiteral([Integer(1), QuotedVar('multiresult'), Identifier(':=')]), FunctionLiteral([Identifier('t'), Integer(2), Identifier('global.max$'), Identifier('substring$'), QuotedVar('t'), Identifier(':=')]), Identifier('if$')]),
   Identifier('while$'),
   Identifier('multiresult')]],
 ['FUNCTION',
  [Identifier('check.missing.pages')],
  [Identifier('pages'),
   Identifier('empty$'),
   FunctionLiteral([String('Empty pages in '), Identifier('cite$'), Identifier('*'), Identifier('warning$')]),
   FunctionLiteral([Identifier('pages'), Identifier('multi.pagerange.check'), FunctionLiteral([String(''), Identifier('*')]), FunctionLiteral([Identifier('type$'), String('article'), Identifier('='), Identifier('type$'), String('periodical'), Identifier('='), Identifier('or'), FunctionLiteral([String("There's only a starting page, no pagerange in "), Identifier('cite$'), Identifier('*'), Identifier('warning$')]), QuotedVar('skip$'), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.pages.book')],
  [Identifier('pages'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([String(' \\jbpages {'), Identifier('pages'), String(' \\bibtotalpagesname}'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.totalpages')],
  [Identifier('totalpages'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([String(', '), Identifier('totalpages'), String('~\\bibtotalpagesname'), Identifier('*'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.vol.year.num.pages')],
  [Identifier('volume'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([String(' \\artvolumeformat {'), Identifier('volume'), Identifier('*'), String('}'), Identifier('*'), Identifier('year'), Identifier('empty$'), FunctionLiteral([String("There's a volume but no year in "), Identifier('cite$'), Identifier('*'), Identifier('warning$')]), QuotedVar('skip$'), Identifier('if$')]),
   Identifier('if$'),
   Identifier('month'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([String('\\ '), Identifier('month'), Identifier('*'), Identifier('*')]),
   Identifier('if$'),
   Identifier('year'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([String(' \\artyearformat {'), Identifier('year'), Identifier('*'), Identifier('add.extra.label'), String('}'), Identifier('*'), Identifier('*')]),
   Identifier('if$'),
   Identifier('number'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([String('\\artnumberformat {'), Identifier('number'), Identifier('*'), String('}'), Identifier('*'), Identifier('*')]),
   Identifier('if$'),
   Identifier('pages'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('empty$'), FunctionLiteral([Identifier('pop$'), Identifier('format.pages')]), FunctionLiteral([String(''), Identifier('format.pages'), Identifier('*'), Identifier('*')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.vol.bracedyear.num.pages')],
  [Identifier('volume'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([String(' \\pervolumeformat {'), Identifier('volume'), Identifier('*'), String('}'), Identifier('*'), Identifier('year'), Identifier('empty$'), FunctionLiteral([String("There's a volume but no year in "), Identifier('cite$'), Identifier('*'), Identifier('warning$')]), QuotedVar('skip$'), Identifier('if$')]),
   Identifier('if$'),
   Identifier('year'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([String(' \\peryearformat {'), Identifier('year'), Identifier('*'), Identifier('add.extra.label'), String('}'), Identifier('*'), Identifier('*')]),
   Identifier('if$'),
   Identifier('month'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([String(', '), Identifier('month'), Identifier('*'), Identifier('*')]),
   Identifier('if$'),
   Identifier('number'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([String(', \\pernumberformat {'), Identifier('number'), Identifier('*'), String('}'), Identifier('*'), Identifier('*')]),
   Identifier('if$'),
   Identifier('pages'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('empty$'), FunctionLiteral([Identifier('pop$'), Identifier('format.pages')]), FunctionLiteral([String(''), Identifier('format.pages'), Identifier('*'), Identifier('*')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.chapter.pages')],
  [Identifier('chapter'),
   Identifier('empty$'),
   QuotedVar('format.pages'),
   FunctionLiteral([Identifier('type'), Identifier('empty$'), FunctionLiteral([String('\\unskip.\\,-- \\bibchapterlongname')]), FunctionLiteral([String('\\unskip.\\,-- '), Identifier('type'), Identifier('*')]), Identifier('if$'), Identifier('chapter'), Identifier('tie.or.space.connect'), Identifier('pages'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('format.pages'), Identifier('*')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.booktitleaddon')],
  [Identifier('booktitle'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([Identifier('booktitleaddon'), Identifier('empty$'), FunctionLiteral([String('')]), FunctionLiteral([Identifier('booktitleaddon')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.incoll.editor.booktitle')],
  [Identifier('booktitle'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([Identifier('volume'), Identifier('empty$'), FunctionLiteral([String('\\incolledformat {}{}{'), Identifier('booktitle'), Identifier('incollbooktitlemarkup'), Identifier('format.booktitleaddon'), Identifier('*'), Identifier('*'), String('}{}'), Identifier('*'), Identifier('booktitleaddon'), Identifier('empty$'), FunctionLiteral([String('{} '), Identifier('*')]), FunctionLiteral([String('{1} '), Identifier('*')]), Identifier('if$')]), FunctionLiteral([String('\\incolledformat {}{}{'), Identifier('booktitle'), Identifier('incollbooktitlemarkup'), Identifier('format.booktitleaddon'), Identifier('*'), Identifier('*'), String('}{'), Identifier('*'), Identifier('volume'), Identifier('*'), String('}'), Identifier('*'), Identifier('booktitleaddon'), Identifier('empty$'), FunctionLiteral([String('{} '), Identifier('*')]), FunctionLiteral([String('{1} '), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), FunctionLiteral([Identifier('volume'), Identifier('empty$'), FunctionLiteral([String('\\incolledformat {'), Identifier('editor'), Identifier('empty$'), FunctionLiteral([String('')]), FunctionLiteral([Identifier('editor'), Identifier('format.editor.names'), String('}'), Identifier('*'), Identifier('*'), Identifier('editortype'), Identifier('empty$'), FunctionLiteral([Identifier('editor'), Identifier('num.names$'), Integer(1), Identifier('>'), FunctionLiteral([String('{\\edfont {\\editorsname}}{'), Identifier('*')]), FunctionLiteral([String('{\\edfont {\\editorname}}{'), Identifier('*')]), Identifier('if$')]), FunctionLiteral([String('{\\edfont {('), Identifier('*'), Identifier('editortype'), Identifier('*'), String(')}}{'), Identifier('*')]), Identifier('if$')]), Identifier('if$'), Identifier('booktitle'), Identifier('incollbooktitlemarkup'), Identifier('*'), Identifier('format.booktitleaddon'), Identifier('*'), String('}{}'), Identifier('*'), Identifier('booktitleaddon'), Identifier('empty$'), FunctionLiteral([String('{} '), Identifier('*')]), FunctionLiteral([String('{1} '), Identifier('*')]), Identifier('if$')]), FunctionLiteral([String('\\incolledformat {'), Identifier('*'), Identifier('editor'), Identifier('empty$'), FunctionLiteral([String('')]), FunctionLiteral([Identifier('editor'), Identifier('format.editor.names'), String('}'), Identifier('*'), Identifier('*'), Identifier('editortype'), Identifier('empty$'), FunctionLiteral([Identifier('editor'), Identifier('num.names$'), Integer(1), Identifier('>'), FunctionLiteral([String('{\\edfont {\\editorsname}}{'), Identifier('*')]), FunctionLiteral([String('{\\edfont {\\editorname}}{'), Identifier('*')]), Identifier('if$')]), FunctionLiteral([String('{\\edfont {('), Identifier('*'), Identifier('editortype'), Identifier('*'), String(')}}{'), Identifier('*')]), Identifier('if$')]), Identifier('if$'), Identifier('booktitle'), Identifier('incollbooktitlemarkup'), Identifier('*'), Identifier('format.booktitleaddon'), Identifier('*'), String('}{'), Identifier('volume'), Identifier('*'), String('}'), Identifier('*'), Identifier('booktitleaddon'), Identifier('empty$'), FunctionLiteral([String('{} '), Identifier('*')]), FunctionLiteral([String('{1} '), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.tr.number.jur')],
  [Identifier('type'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('number'), Identifier('empty$'), FunctionLiteral([String(' -- \\technicalreportname {} ')]), FunctionLiteral([String('~('), Identifier('number'), Identifier('*'), String(').\\,-- \\technicalreportname {} '), Identifier('*')]), Identifier('if$')]),
   FunctionLiteral([Identifier('number'), Identifier('empty$'), FunctionLiteral([String(' -- '), Identifier('type'), Identifier('*')]), FunctionLiteral([String('~('), Identifier('number'), Identifier('*'), String(').\\,-- '), Identifier('type'), Identifier('*'), String(' '), Identifier('*'), Identifier('*')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.article.crossref.bracedyear')],
  [Identifier('key'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('journal'), Identifier('empty$'), FunctionLiteral([String('Need key or journal for '), Identifier('cite$'), Identifier('*'), String(' to crossref '), Identifier('*'), Identifier('crossref'), Identifier('*'), Identifier('warning$'), String('')]), FunctionLiteral([String('\\bibJTsep\\bibjtfont {'), Identifier('journal'), Identifier('*'), Identifier('check.punct.instead.of.add.period.art'), Identifier('*')]), Identifier('if$'), Identifier('volume'), Identifier('empty$'), FunctionLiteral([String('No volume in '), Identifier('cite$'), Identifier('*'), Identifier('warning$')]), FunctionLiteral([String(' \\pervolumeformat {'), Identifier('volume'), Identifier('*'), String('} '), Identifier('*')]), Identifier('if$'), Identifier('year'), Identifier('empty$'), FunctionLiteral([String('No year in '), Identifier('cite$'), Identifier('*'), Identifier('warning$')]), FunctionLiteral([String('\\peryearformat {'), Identifier('year'), Identifier('*'), Identifier('add.extra.label'), String('}'), Identifier('*'), Identifier('*')]), Identifier('if$'), Identifier('pages'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('duplicate$'), Identifier('empty$'), FunctionLiteral([Identifier('pop$'), Identifier('format.pages')]), FunctionLiteral([Identifier('format.pages'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]),
   FunctionLiteral([String(''), Identifier('key'), Identifier('*')]),
   Identifier('if$'),
   String('\\ \\protect\\jbcrossrefchecked {'),
   Identifier('*'),
   Identifier('crossref'),
   Identifier('*'),
   String('}\\unskip'),
   Identifier('*')]],
 ['FUNCTION',
  [Identifier('format.article.crossref')],
  [Identifier('key'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('journal'), Identifier('empty$'), FunctionLiteral([String('Need key or journal for '), Identifier('cite$'), Identifier('*'), String(' to crossref '), Identifier('*'), Identifier('crossref'), Identifier('*'), Identifier('warning$'), String('')]), FunctionLiteral([String('\\bibJTsep\\bibjtfont {'), Identifier('journal'), Identifier('*'), Identifier('check.punct.instead.of.add.period.art'), Identifier('*')]), Identifier('if$')]),
   FunctionLiteral([String(''), Identifier('key'), Identifier('*')]),
   Identifier('if$'),
   Identifier('year'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('year'), Identifier('*')]),
   Identifier('if$'),
   String(' \\protect\\jbcrossrefchecked {'),
   Identifier('crossref'),
   Identifier('*'),
   String('}'),
   Identifier('*')]],
 ['FUNCTION',
  [Identifier('format.book.crossref')],
  [Identifier('editor'),
   Identifier('empty$'),
   Identifier('editor'),
   Identifier('field.or.null'),
   Identifier('author'),
   Identifier('field.or.null'),
   Identifier('='),
   Identifier('or'),
   FunctionLiteral([Identifier('key'), Identifier('empty$'), FunctionLiteral([Identifier('series'), Identifier('empty$'), FunctionLiteral([String('Need editor, key, or series for '), Identifier('cite$'), Identifier('*'), String(' to crossref '), Identifier('*'), Identifier('crossref'), Identifier('*'), Identifier('warning$'), String(''), Identifier('*')]), FunctionLiteral([String(''), Identifier('*')]), Identifier('if$')]), FunctionLiteral([Identifier('key'), Identifier('*')]), Identifier('if$')]),
   FunctionLiteral([String(''), Identifier('*')]),
   Identifier('if$'),
   Identifier('volume'),
   Identifier('empty$'),
   FunctionLiteral([String('Empty volume in '), Identifier('cite$'), Identifier('*'), String("'s crossref of "), Identifier('*'), Identifier('crossref'), Identifier('*'), Identifier('warning$'), String(''), String(' \\protect\\jbcrossrefchecked {'), Identifier('*'), Identifier('crossref'), Identifier('*'), String('}\\unskip'), Identifier('*')]),
   FunctionLiteral([String(' \\protect\\jbcrossrefchecked['), Identifier('*'), Identifier('volume'), Identifier('*'), String(']{'), Identifier('*'), Identifier('crossref'), String('}\\unskip'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.incoll.inproc.crossref')],
  [String(' \\protect\\jbincollcrossref {'),
   Identifier('*'),
   Identifier('crossref'),
   Identifier('*'),
   String('}'),
   Identifier('*'),
   Identifier('editor'),
   Identifier('empty$'),
   FunctionLiteral([String('{}'), Identifier('*')]),
   FunctionLiteral([String('{1}'), Identifier('*')]),
   Identifier('if$'),
   Identifier('format.pages')]],
 ['FUNCTION',
  [Identifier('format.editors.organization')],
  [Identifier('organization'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('type$'), String('misc'), Identifier('='), FunctionLiteral([Identifier('organization')]), FunctionLiteral([Identifier('author'), Identifier('empty$'), FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([String(' '), Identifier('organization'), Identifier('*'), String(' \\organizationname {}'), Identifier('*')]), FunctionLiteral([String('; '), Identifier('organization'), Identifier('*'), String(' \\organizationname {}'), Identifier('*')]), Identifier('if$')]), FunctionLiteral([String('; '), Identifier('organization'), Identifier('*'), String(' \\organizationname {}'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.address.organization.manual')],
  [Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('organization'), Identifier('empty$'), FunctionLiteral([Identifier('address'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('address'), Identifier('output'), Identifier('part.of.sentence'), Identifier('year'), Identifier('empty$'), Identifier('not'), FunctionLiteral([String('\\bibbdsep {}'), Identifier('*')]), QuotedVar('skip$'), Identifier('if$')]), Identifier('if$')]), QuotedVar('skip$'), Identifier('if$')]),
   FunctionLiteral([Identifier('address'), Identifier('empty$'), FunctionLiteral([Identifier('organization'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('organization'), Identifier('output'), Identifier('part.of.sentence'), Identifier('year'), Identifier('empty$'), Identifier('not'), FunctionLiteral([String('\\bibbdsep {}'), Identifier('*')]), QuotedVar('skip$'), Identifier('if$')]), Identifier('if$')]), FunctionLiteral([Identifier('organization'), Identifier('empty$'), FunctionLiteral([Identifier('address'), Identifier('output'), Identifier('part.of.sentence')]), FunctionLiteral([Identifier('address'), String('\\bpubaddr {} '), Identifier('*'), Identifier('organization'), Identifier('*'), Identifier('output'), Identifier('part.of.sentence')]), Identifier('if$'), Identifier('year'), Identifier('empty$'), Identifier('not'), FunctionLiteral([String('\\bibbdsep {}'), Identifier('*')]), QuotedVar('skip$'), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('article')],
  [Identifier('output.bibitem'),
   Identifier('format.authors'),
   String('author'),
   Identifier('output.check'),
   Identifier('set.after.author.sep'),
   Identifier('output'),
   Identifier('format.artperiodincoll.title'),
   String('title'),
   Identifier('output.check'),
   Identifier('crossref'),
   Identifier('missing$'),
   FunctionLiteral([Identifier('journal'), Identifier('article.in.journal'), Identifier('output.nonnull'), Identifier('new.sentence'), Identifier('format.vol.year.num.pages'), Identifier('output')]),
   FunctionLiteral([Identifier('format.article.crossref'), Identifier('output.nonnull')]),
   Identifier('if$'),
   Identifier('format.url'),
   Identifier('output'),
   Identifier('format.note'),
   Identifier('format.isbn.issn'),
   Identifier('output'),
   Identifier('format.howcited.artperiod'),
   Identifier('output'),
   Identifier('check.missing.pages'),
   Identifier('fin.entry.endnote')]],
 ['FUNCTION',
  [Identifier('commented')],
  [Identifier('output.bibitem'),
   Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([Identifier('format.founders')]), FunctionLiteral([Identifier('format.founders'), Identifier('format.editors'), String('editor'), Identifier('output.check')]), Identifier('if$')]),
   FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([Identifier('format.authors'), Identifier('format.founders'), Identifier('output.nonnull')]), FunctionLiteral([Identifier('format.authors'), Identifier('format.founders'), Identifier('format.editors'), Identifier('output.nonnull')]), Identifier('if$')]),
   Identifier('if$'),
   Identifier('set.after.author.sep'),
   Identifier('output'),
   Identifier('crossref'),
   Identifier('missing$'),
   FunctionLiteral([Identifier('format.btitle.vol'), String('title'), Identifier('output.check')]),
   FunctionLiteral([Identifier('format.btitle'), String('title'), Identifier('output.check')]),
   Identifier('if$'),
   Identifier('format.volumetitle'),
   Identifier('output'),
   Identifier('format.edition'),
   Identifier('output'),
   Identifier('format.address.publisher.year'),
   String('publisher'),
   Identifier('output.check'),
   Identifier('format.update'),
   Identifier('new.sentence'),
   Identifier('crossref'),
   Identifier('missing$'),
   FunctionLiteral([Identifier('format.series.number'), Identifier('output')]),
   FunctionLiteral([Identifier('format.book.crossref'), Identifier('output.nonnull')]),
   Identifier('if$'),
   Identifier('format.url'),
   Identifier('output'),
   Identifier('format.pages'),
   Identifier('output'),
   Identifier('format.note'),
   Identifier('format.howcited.comment'),
   Identifier('output'),
   Identifier('fin.entry.endnote')]],
 ['FUNCTION',
  [Identifier('periodical')],
  [Identifier('output.bibitem'),
   Identifier('format.authors'),
   String('author'),
   Identifier('output.check'),
   Identifier('set.after.author.sep'),
   Identifier('output'),
   Identifier('format.artperiodincoll.title'),
   String('title'),
   Identifier('output.check'),
   Identifier('crossref'),
   Identifier('missing$'),
   FunctionLiteral([Identifier('journal'), Identifier('article.in.journal'), Identifier('output.nonnull'), Identifier('new.sentence'), Identifier('format.vol.bracedyear.num.pages'), Identifier('output')]),
   FunctionLiteral([Identifier('new.sentence'), Identifier('format.article.crossref.bracedyear'), Identifier('output.nonnull')]),
   Identifier('if$'),
   Identifier('format.url'),
   Identifier('output'),
   Identifier('format.note'),
   Identifier('format.isbn.issn'),
   Identifier('output'),
   Identifier('format.howcited.artperiod'),
   Identifier('output'),
   Identifier('fin.entry.endnote')]],
 ['FUNCTION',
  [Identifier('book')],
  [Identifier('output.bibitem'),
   Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([String(''), String('author and editor'), Identifier('output.check')]), FunctionLiteral([Identifier('format.editors'), Identifier('output.nonnull')]), Identifier('if$')]),
   FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([Identifier('format.authors'), Identifier('output.nonnull')]), FunctionLiteral([Identifier('format.authors'), String('\\jbtiafed {'), Identifier('format.editors'), Identifier('*'), String('}'), Identifier('*'), Identifier('output.nonnull')]), Identifier('if$')]),
   Identifier('if$'),
   Identifier('set.after.author.sep'),
   Identifier('output'),
   Identifier('crossref'),
   Identifier('missing$'),
   FunctionLiteral([Identifier('format.btitle.vol'), String('title'), Identifier('output.check')]),
   FunctionLiteral([Identifier('format.btitle'), String('title'), Identifier('output.check')]),
   Identifier('if$'),
   Identifier('author'),
   Identifier('empty$'),
   Identifier('not'),
   Identifier('editor'),
   Identifier('empty$'),
   Identifier('not'),
   Identifier('and'),
   FunctionLiteral([String('\\jbedafti {\\edbyname {} '), Identifier('editor'), Identifier('*'), String(','), Identifier('*'), Identifier('*'), String('} '), Identifier('*')]),
   QuotedVar('skip$'),
   Identifier('if$'),
   Identifier('make.translators'),
   Identifier('output'),
   Identifier('format.volumetitle'),
   Identifier('output'),
   Identifier('format.edition'),
   Identifier('output'),
   Identifier('format.address.publisher.year'),
   String('publisher'),
   Identifier('output.check'),
   Identifier('new.sentence'),
   Identifier('format.juradiss.book'),
   Identifier('output'),
   Identifier('crossref'),
   Identifier('missing$'),
   FunctionLiteral([Identifier('format.series.number'), Identifier('output')]),
   FunctionLiteral([Identifier('format.book.crossref'), Identifier('output.nonnull')]),
   Identifier('if$'),
   Identifier('format.url'),
   Identifier('output'),
   Identifier('format.pages'),
   Identifier('output'),
   Identifier('format.totalpages'),
   Identifier('output'),
   Identifier('format.note'),
   Identifier('format.isbn.issn'),
   Identifier('output'),
   Identifier('format.howcited'),
   Identifier('output'),
   Identifier('fin.entry.endnote')]],
 ['FUNCTION',
  [Identifier('inbook')],
  [Identifier('output.bibitem'),
   Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('format.editors'), String('author and editor'), Identifier('output.check')]),
   FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([Identifier('format.authors'), Identifier('output.nonnull')]), FunctionLiteral([Identifier('format.authors'), Identifier('format.editors'), Identifier('output.nonnull')]), Identifier('if$')]),
   Identifier('if$'),
   Identifier('set.after.author.sep'),
   Identifier('output'),
   Identifier('crossref'),
   Identifier('missing$'),
   FunctionLiteral([Identifier('chapter'), Identifier('empty$'), FunctionLiteral([String("There's no chapter in "), Identifier('cite$'), Identifier('*'), Identifier('warning$'), String(''), Identifier('*')]), FunctionLiteral([Identifier('type'), Identifier('empty$'), FunctionLiteral([String('\\Bibchaptername{}')]), FunctionLiteral([Identifier('type')]), Identifier('if$'), Identifier('chapter'), Identifier('tie.or.space.connect'), String(' In '), Identifier('*'), Identifier('*')]), Identifier('if$'), Identifier('format.btitle.vol.inbook'), String('title'), Identifier('output.check'), Identifier('make.translators'), Identifier('output'), Identifier('format.volumetitle'), Identifier('output'), Identifier('format.edition'), Identifier('output'), Identifier('format.address.publisher.year'), String('publisher'), Identifier('output.check'), Identifier('new.sentence'), Identifier('format.series.number'), Identifier('output'), Identifier('format.url'), Identifier('output'), Identifier('format.pages'), String('pages'), Identifier('output.check'), Identifier('format.note'), Identifier('format.isbn.issn'), Identifier('output')]),
   FunctionLiteral([Identifier('chapter'), Identifier('empty$'), FunctionLiteral([String("There's no chapter in "), Identifier('cite$'), Identifier('*'), Identifier('warning$'), String(''), Identifier('*'), Identifier('format.btitle.vol.inbook'), String('title'), Identifier('output.check')]), FunctionLiteral([Identifier('type'), Identifier('empty$'), FunctionLiteral([String('\\Bibchaptername{}')]), FunctionLiteral([Identifier('type')]), Identifier('if$'), Identifier('chapter'), Identifier('tie.or.space.connect'), String(''), Identifier('*'), Identifier('*')]), Identifier('if$'), Identifier('format.volumetitle'), Identifier('output'), Identifier('format.book.crossref'), Identifier('output.nonnull'), Identifier('format.url'), Identifier('output'), Identifier('format.pages'), String('pages'), Identifier('output.check'), Identifier('format.note')]),
   Identifier('if$'),
   Identifier('part.of.sentence'),
   Identifier('format.howcited'),
   Identifier('output'),
   Identifier('fin.entry.endnote')]],
 ['FUNCTION',
  [Identifier('incollection')],
  [Identifier('output.bibitem'),
   Identifier('format.authors'),
   String('author'),
   Identifier('output.check'),
   Identifier('set.after.author.sep'),
   Identifier('output'),
   Identifier('format.artperiodincoll.title'),
   String('title'),
   Identifier('output.check'),
   Identifier('make.translators'),
   Identifier('output'),
   Identifier('crossref'),
   Identifier('missing$'),
   FunctionLiteral([Identifier('format.incoll.editor.booktitle'), String('booktitle'), Identifier('output.check'), Identifier('format.volumetitle'), Identifier('output'), Identifier('format.edition'), Identifier('output'), Identifier('format.address.publisher.year'), String('publisher'), Identifier('output.check'), Identifier('new.sentence'), Identifier('format.series.number'), Identifier('output'), Identifier('format.url'), Identifier('output'), Identifier('format.isbn.issn'), Identifier('output'), Identifier('part.of.sentence'), Identifier('format.chapter.pages'), Identifier('output'), Identifier('format.note')]),
   FunctionLiteral([Identifier('format.volumetitle'), Identifier('output'), Identifier('format.incoll.inproc.crossref'), Identifier('output.nonnull'), Identifier('format.url'), Identifier('output'), Identifier('format.note')]),
   Identifier('if$'),
   Identifier('format.howcited'),
   Identifier('output'),
   Identifier('check.missing.pages'),
   Identifier('fin.entry.endnote')]],
 ['FUNCTION',
  [Identifier('inproceedings')],
  [Identifier('output.bibitem'),
   Identifier('format.authors'),
   String('author'),
   Identifier('output.check'),
   Identifier('set.after.author.sep'),
   Identifier('output'),
   Identifier('format.artperiodincoll.title'),
   String('title'),
   Identifier('output.check'),
   Identifier('crossref'),
   Identifier('missing$'),
   FunctionLiteral([Identifier('format.incoll.editor.booktitle'), String('booktitle'), Identifier('output.check'), Identifier('address'), Identifier('empty$'), FunctionLiteral([Identifier('organization'), Identifier('new.sentence.checka'), Identifier('organization'), Identifier('output'), Identifier('part.of.sentence'), Identifier('format.address.publisher.year'), Identifier('output')]), FunctionLiteral([Identifier('format.address.publisher.year'), String('publisher'), Identifier('output.check')]), Identifier('if$'), Identifier('new.sentence'), Identifier('series'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('format.series.number'), Identifier('output')]), Identifier('if$'), Identifier('format.url'), Identifier('output'), Identifier('format.note'), Identifier('format.isbn.issn'), Identifier('output'), Identifier('part.of.sentence'), Identifier('format.pages'), Identifier('output')]),
   FunctionLiteral([Identifier('format.incoll.inproc.crossref'), Identifier('output.nonnull'), Identifier('format.url'), Identifier('output'), Identifier('format.note')]),
   Identifier('if$'),
   Identifier('format.howcited'),
   Identifier('output'),
   Identifier('fin.entry.endnote')]],
 ['FUNCTION', [Identifier('conference')], [Identifier('inproceedings')]],
 ['FUNCTION',
  [Identifier('manual')],
  [Identifier('output.bibitem'),
   Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('organization'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String('\\bibnf{'), Identifier('organization'), Identifier('*'), String('} {} {} {} {}'), Identifier('*'), Identifier('output.nonnull')]), Identifier('if$')]),
   FunctionLiteral([Identifier('format.authors'), Identifier('output.nonnull')]),
   Identifier('if$'),
   Identifier('set.after.author.sep'),
   Identifier('output'),
   Identifier('format.btitle'),
   String('title'),
   Identifier('output.check'),
   Identifier('format.edition'),
   Identifier('output'),
   Identifier('format.address.organization.manual'),
   Identifier('format.date'),
   Identifier('output'),
   Identifier('pages'),
   Identifier('set.period.dash.check'),
   Identifier('format.pages.book'),
   Identifier('output'),
   Identifier('format.url'),
   Identifier('output'),
   Identifier('format.note'),
   Identifier('format.howcited'),
   Identifier('output'),
   Identifier('fin.entry.endnote')]],
 ['FUNCTION',
  [Identifier('mastersthesis')],
  [Identifier('output.bibitem'),
   Identifier('format.authors'),
   String('author'),
   Identifier('output.check'),
   Identifier('set.after.author.sep'),
   Identifier('output'),
   Identifier('format.btitle'),
   String('title'),
   Identifier('output.check'),
   Identifier('format.thesis'),
   Identifier('output'),
   Identifier('set.comma.pages.check'),
   Identifier('pages'),
   Identifier('new.sentence.checka'),
   Identifier('format.pages'),
   Identifier('output'),
   Identifier('format.url'),
   Identifier('output'),
   Identifier('format.note'),
   Identifier('format.howcited'),
   Identifier('output'),
   Identifier('fin.entry.endnote')]],
 ['FUNCTION',
  [Identifier('phdthesis')],
  [Identifier('output.bibitem'),
   Identifier('format.authors'),
   String('author'),
   Identifier('output.check'),
   Identifier('set.after.author.sep'),
   Identifier('output'),
   Identifier('format.btitle'),
   String('title'),
   Identifier('output.check'),
   Identifier('format.thesis'),
   Identifier('output'),
   Identifier('set.comma.pages.check'),
   Identifier('pages'),
   Identifier('new.sentence.checka'),
   Identifier('format.pages'),
   Identifier('output'),
   Identifier('format.url'),
   Identifier('output'),
   Identifier('format.note'),
   Identifier('format.howcited'),
   Identifier('output'),
   Identifier('fin.entry.endnote')]],
 ['FUNCTION',
  [Identifier('jurthesis')],
  [Identifier('output.bibitem'),
   Identifier('format.authors'),
   String('author'),
   Identifier('output.check'),
   Identifier('set.after.author.sep'),
   Identifier('output'),
   Identifier('format.btitle'),
   String('title'),
   Identifier('output.check'),
   Identifier('format.thesis'),
   Identifier('output'),
   Identifier('set.comma.pages.check'),
   Identifier('pages'),
   Identifier('new.sentence.checka'),
   Identifier('format.pages'),
   Identifier('output'),
   Identifier('format.url'),
   Identifier('output'),
   Identifier('format.note'),
   Identifier('format.howcited'),
   Identifier('output'),
   Identifier('fin.entry.endnote')]],
 ['FUNCTION',
  [Identifier('booklet')],
  [Identifier('output.bibitem'),
   Identifier('format.authors'),
   String('author'),
   Identifier('output.check'),
   Identifier('set.after.author.sep'),
   Identifier('output'),
   Identifier('format.title'),
   String('title'),
   Identifier('output.check'),
   Identifier('format.howpublished.address.year'),
   Identifier('output'),
   Identifier('format.note'),
   Identifier('format.url'),
   Identifier('output'),
   Identifier('format.howcited'),
   Identifier('output'),
   Identifier('fin.entry.endnote')]],
 ['FUNCTION',
  [Identifier('misc')],
  [Identifier('output.bibitem'),
   Identifier('format.authors'),
   String('author'),
   Identifier('output.check'),
   Identifier('set.after.author.sep'),
   Identifier('output'),
   Identifier('format.title'),
   Identifier('output'),
   Identifier('format.howpublished.address.year'),
   Identifier('output'),
   Identifier('format.note'),
   Identifier('format.url'),
   Identifier('output'),
   Identifier('format.howcited'),
   Identifier('output'),
   Identifier('fin.entry.endnote')]],
 ['FUNCTION',
  [Identifier('proceedings')],
  [Identifier('output.bibitem'),
   Identifier('editor'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('organization'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String('\\biblnfont {'), Identifier('organization'), Identifier('*'), String(' \\organizationname}'), Identifier('*'), Identifier('output')]), Identifier('if$')]),
   FunctionLiteral([Identifier('format.editors'), Identifier('output.nonnull')]),
   Identifier('if$'),
   Identifier('set.after.author.sep'),
   Identifier('output'),
   Identifier('format.btitle'),
   String('title'),
   Identifier('output.check'),
   Identifier('new.sentence'),
   Identifier('editor'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('format.proceed.organization'), Identifier('output')]),
   Identifier('if$'),
   Identifier('new.sentence'),
   Identifier('format.series.number'),
   Identifier('output.nonnull'),
   Identifier('volume'),
   Identifier('empty$'),
   FunctionLiteral([String(''), Identifier('output.nonnull')]),
   FunctionLiteral([String('\\volumeformat {'), Identifier('volume'), Identifier('*'), String('} '), Identifier('*'), String('volume'), Identifier('output.check')]),
   Identifier('if$'),
   Identifier('format.address.publisher.year'),
   String('publisher'),
   Identifier('output.check'),
   Identifier('pages'),
   Identifier('set.period.dash.check'),
   Identifier('format.pages.book'),
   Identifier('output'),
   Identifier('format.url'),
   Identifier('output'),
   Identifier('format.note'),
   Identifier('format.isbn.issn'),
   Identifier('output'),
   Identifier('format.howcited'),
   Identifier('output'),
   Identifier('fin.entry.endnote')]],
 ['FUNCTION',
  [Identifier('techreport')],
  [Identifier('output.bibitem'),
   Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('format.editors'), String('author and editor'), Identifier('output.check')]),
   FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([Identifier('format.authors'), Identifier('output.nonnull')]), FunctionLiteral([Identifier('format.authors'), Identifier('format.editors'), Identifier('output.nonnull')]), Identifier('if$')]),
   Identifier('if$'),
   Identifier('set.after.author.sep'),
   Identifier('output'),
   Identifier('format.title'),
   String('title'),
   Identifier('output.check'),
   Identifier('institution'),
   Identifier('new.sentence.checka'),
   Identifier('format.address.publisher.year'),
   Identifier('output'),
   Identifier('number'),
   Identifier('new.sentence.checka'),
   Identifier('format.tr.number.jur'),
   String('number'),
   Identifier('output.check'),
   Identifier('pages'),
   Identifier('set.period.dash.check'),
   Identifier('format.pages.book'),
   Identifier('output'),
   Identifier('format.url'),
   Identifier('output'),
   Identifier('format.note'),
   Identifier('format.isbn.issn'),
   Identifier('output'),
   Identifier('format.howcited'),
   Identifier('output'),
   Identifier('fin.entry.endnote')]],
 ['FUNCTION',
  [Identifier('www')],
  [Identifier('output.bibitem'),
   Identifier('format.authors'),
   String('author'),
   Identifier('output.check'),
   Identifier('set.after.author.sep'),
   Identifier('output'),
   Identifier('format.naked.url'),
   Identifier('output'),
   Identifier('format.howcited'),
   Identifier('output'),
   Identifier('fin.entry.endnote')]],
 ['FUNCTION',
  [Identifier('lexicon')],
  [Identifier('output.bibitem'),
   Identifier('set.after.author.sep'),
   Identifier('output'),
   Identifier('crossref'),
   Identifier('missing$'),
   FunctionLiteral([Identifier('format.btitle.vol'), String('title'), Identifier('output.check')]),
   FunctionLiteral([Identifier('format.btitle'), String('title'), Identifier('output.check')]),
   Identifier('if$'),
   Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('editor'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String('\\edbyname{} '), Identifier('*'), Identifier('editor'), Identifier('format.editor.names'), String(','), Identifier('*'), Identifier('*')]), Identifier('if$')]),
   FunctionLiteral([String('\\byname{} '), Identifier('author'), Identifier('format.names'), Identifier('*'), String(','), Identifier('*'), Identifier('*')]),
   Identifier('if$'),
   Identifier('make.translators'),
   Identifier('output'),
   Identifier('format.volumetitle'),
   Identifier('output'),
   Identifier('format.edition'),
   Identifier('output'),
   Identifier('format.address.publisher.year'),
   String('publisher'),
   Identifier('output.check'),
   Identifier('new.sentence'),
   Identifier('format.juradiss.book'),
   Identifier('output'),
   Identifier('crossref'),
   Identifier('missing$'),
   FunctionLiteral([Identifier('format.series.number'), Identifier('output')]),
   FunctionLiteral([Identifier('format.book.crossref'), Identifier('output.nonnull')]),
   Identifier('if$'),
   Identifier('format.url'),
   Identifier('output'),
   Identifier('format.pages'),
   Identifier('output'),
   Identifier('format.totalpages'),
   Identifier('output'),
   Identifier('format.note'),
   Identifier('format.isbn.issn'),
   Identifier('output'),
   Identifier('format.howcited'),
   Identifier('output'),
   Identifier('fin.entry.endnote')]],
 ['STRINGS', [Identifier('last.archive'), Identifier('last.subarchive')]],
 ['FUNCTION',
  [Identifier('init.last.archive')],
  [String(''),
   QuotedVar('last.archive'),
   Identifier(':='),
   String(''),
   QuotedVar('last.subarchive'),
   Identifier(':=')]],
 ['FUNCTION',
  [Identifier('archival')],
  [Identifier('output.bibitem'),
   Identifier('archive'),
   Identifier('empty$'),
   FunctionLiteral([String(''), QuotedVar('last.archive'), Identifier(':=')]),
   FunctionLiteral([Identifier('archive'), Identifier('last.archive'), Identifier('='), FunctionLiteral([String('} {'), Identifier('archive'), Identifier('format.name.sig'), Identifier('*'), String('} {} {\\jbsamearch{} '), Identifier('*'), Identifier('*')]), FunctionLiteral([String('\\bibanfont{'), Identifier('archive'), Identifier('*'), String('archive'), Identifier('output.check'), Identifier('shortarchive'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String(' \\jbshortarchformat{'), Identifier('shortarchive'), Identifier('*'), String('}'), Identifier('*'), Identifier('*')]), Identifier('if$'), String('}'), Identifier('*'), String('} {'), Identifier('archive'), Identifier('format.name.sig'), Identifier('*'), String('} {} {\\jbnotsamearch{} '), Identifier('*'), Identifier('*')]), Identifier('if$'), Identifier('archive'), QuotedVar('last.archive'), Identifier(':=')]),
   Identifier('if$'),
   Identifier('subarchive'),
   Identifier('empty$'),
   FunctionLiteral([String(''), QuotedVar('last.subarchive'), Identifier(':=')]),
   FunctionLiteral([Identifier('subarchive'), Identifier('last.subarchive'), Identifier('='), QuotedVar('skip$'), FunctionLiteral([Identifier('subarchive'), Identifier('output'), Identifier('shortsubarchive'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String(' \\jbshortsubarchformat{'), Identifier('shortsubarchive'), Identifier('*'), String('}'), Identifier('*'), Identifier('*')]), Identifier('if$'), String('\\jbsubarchsep{} '), Identifier('*')]), Identifier('if$'), Identifier('subarchive'), QuotedVar('last.subarchive'), Identifier(':=')]),
   Identifier('if$'),
   Identifier('sig1'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([String('\\jbarchsig {'), Identifier('*'), Identifier('subarchive'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String('\\jbsamesubarchindent{} '), Identifier('*')]), Identifier('if$'), Identifier('sig1'), Identifier('*'), Identifier('sig2'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String('. '), Identifier('sig2'), Identifier('*'), Identifier('*'), Identifier('sig3'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String('. '), Identifier('sig3'), Identifier('*'), Identifier('*'), Identifier('sig4'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String('. '), Identifier('sig4'), Identifier('*'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$'), String('} {'), Identifier('*')]),
   Identifier('if$'),
   Identifier('archname'),
   Identifier('missing$'),
   FunctionLiteral([String('}'), Identifier('*')]),
   FunctionLiteral([Identifier('archname'), String('}'), Identifier('*'), Identifier('output')]),
   Identifier('if$'),
   Identifier('format.howcited'),
   Identifier('output'),
   Identifier('fin.entry.endnote')]],
 ['FUNCTION', [Identifier('unpublished')], [Identifier('misc')]],
 ['FUNCTION', [Identifier('default.type')], [Identifier('misc')]],
 ['MACRO', [Identifier('jan')], [String('\\janname\\ ')]],
 ['MACRO', [Identifier('feb')], [String('\\febname\\ ')]],
 ['MACRO', [Identifier('mar')], [String('\\marname\\ ')]],
 ['MACRO', [Identifier('apr')], [String('\\aprname\\ ')]],
 ['MACRO', [Identifier('may')], [String('\\mayname\\ ')]],
 ['MACRO', [Identifier('jun')], [String('\\junname\\ ')]],
 ['MACRO', [Identifier('jul')], [String('\\julname\\ ')]],
 ['MACRO', [Identifier('aug')], [String('\\augname\\ ')]],
 ['MACRO', [Identifier('sep')], [String('\\sepname\\ ')]],
 ['MACRO', [Identifier('oct')], [String('\\octname\\ ')]],
 ['MACRO', [Identifier('nov')], [String('\\novname\\ ')]],
 ['MACRO', [Identifier('dec')], [String('\\decname\\ ')]],
 ['READ'],
 ['FUNCTION',
  [Identifier('sortify')],
  [Identifier('purify$'), String('l'), Identifier('change.case$')]],
 ['INTEGERS', [Identifier('len')]],
 ['FUNCTION',
  [Identifier('chop.word')],
  [QuotedVar('s'),
   Identifier(':='),
   QuotedVar('len'),
   Identifier(':='),
   Identifier('s'),
   Integer(1),
   Identifier('len'),
   Identifier('substring$'),
   Identifier('='),
   FunctionLiteral([Identifier('s'), Identifier('len'), Integer(1), Identifier('+'), Identifier('global.max$'), Identifier('substring$')]),
   QuotedVar('s'),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.lab.names')],
  [QuotedVar('s'),
   Identifier(':='),
   Identifier('s'),
   Integer(1),
   String('{vv~}{ll}'),
   Identifier('format.name$'),
   Identifier('s'),
   Identifier('num.names$'),
   Identifier('duplicate$'),
   Integer(2),
   Identifier('<'),
   QuotedVar('pop$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('duplicate$'), Integer(3), Identifier('>'), Identifier('swap$'), Identifier('s'), Identifier('swap$'), String('{ff }{vv }{ll}{ jj}'), Identifier('format.name$'), String('others'), Identifier('='), Identifier('or'), FunctionLiteral([Identifier('pop$'), String('\\Bibetal'), Identifier('*')]), FunctionLiteral([Integer(2), Identifier('='), FunctionLiteral([String('\\jbbtasep '), Identifier('*'), Identifier('s'), Integer(2), String('{vv~}{ll}'), Identifier('format.name$'), Identifier('*')]), FunctionLiteral([String('\\jbbfsasep '), Identifier('*'), Identifier('s'), Integer(2), String('{vv~}{ll}'), Identifier('format.name$'), Identifier('*'), String('\\jbbstasep '), Identifier('*'), Identifier('s'), Integer(3), String('{vv~}{ll}'), Identifier('format.name$'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$'),
   Identifier('year'),
   Identifier('missing$'),
   QuotedVar('skip$'),
   FunctionLiteral([String('\\jbdy {'), Identifier('year'), Identifier('*'), String('}'), Identifier('*'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.editor.lab.names')],
  [QuotedVar('s'),
   Identifier(':='),
   Identifier('s'),
   Integer(1),
   String('{vv~}{ll}'),
   Identifier('format.name$'),
   Identifier('s'),
   Identifier('num.names$'),
   Identifier('duplicate$'),
   Integer(2),
   Identifier('<'),
   QuotedVar('pop$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('duplicate$'), Integer(3), Identifier('>'), Identifier('swap$'), Identifier('s'), Identifier('swap$'), String('{ff }{vv }{ll}{ jj}'), Identifier('format.name$'), String('others'), Identifier('='), Identifier('or'), FunctionLiteral([Identifier('pop$'), String('\\Bibetal'), Identifier('*')]), FunctionLiteral([Integer(2), Identifier('='), FunctionLiteral([String('\\jbbtesep '), Identifier('*'), Identifier('s'), Integer(2), String('{vv~}{ll}'), Identifier('format.name$'), Identifier('*')]), FunctionLiteral([String('\\jbbfsesep '), Identifier('*'), Identifier('s'), Integer(2), String('{vv~}{ll}'), Identifier('format.name$'), Identifier('*'), String('\\jbbstesep '), Identifier('*'), Identifier('s'), Integer(3), String('{vv~}{ll}'), Identifier('format.name$'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$'),
   Identifier('year'),
   Identifier('missing$'),
   QuotedVar('skip$'),
   FunctionLiteral([String('\\jbdy {'), Identifier('year'), Identifier('*'), String('}'), Identifier('*'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('author.key.label')],
  [Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('key'), Identifier('empty$'), FunctionLiteral([Identifier('cite$'), Integer(1), Integer(3), Identifier('substring$')]), QuotedVar('key'), Identifier('if$')]),
   FunctionLiteral([Identifier('author'), Identifier('format.lab.names')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('author.editor.key.label')],
  [Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([Identifier('key'), Identifier('empty$'), FunctionLiteral([Identifier('cite$'), Integer(1), Integer(3), Identifier('substring$')]), QuotedVar('key'), Identifier('if$')]), FunctionLiteral([Identifier('editor'), Identifier('format.editor.lab.names')]), Identifier('if$')]),
   FunctionLiteral([Identifier('author'), Identifier('format.lab.names')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('editor.key.label')],
  [Identifier('editor'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('key'), Identifier('empty$'), FunctionLiteral([Identifier('cite$'), Integer(1), Integer(3), Identifier('substring$')]), QuotedVar('key'), Identifier('if$')]),
   FunctionLiteral([Identifier('editor'), Identifier('format.editor.lab.names')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('calc.label')],
  [Identifier('type$'),
   String('book'),
   Identifier('='),
   Identifier('type$'),
   String('inbook'),
   Identifier('='),
   Identifier('or'),
   Identifier('type$'),
   String('incollection'),
   Identifier('='),
   Identifier('or'),
   Identifier('type$'),
   String('commented'),
   Identifier('='),
   Identifier('or'),
   Identifier('type$'),
   String('lexicon'),
   Identifier('='),
   Identifier('or'),
   QuotedVar('author.editor.key.label'),
   FunctionLiteral([Identifier('type$'), String('proceedings'), Identifier('='), QuotedVar('editor.key.label'), QuotedVar('author.key.label'), Identifier('if$')]),
   Identifier('if$'),
   QuotedVar('label'),
   Identifier(':=')]],
 ['FUNCTION',
  [Identifier('calc.dummy.label')],
  [Identifier('type$'),
   String('book'),
   Identifier('='),
   Identifier('type$'),
   String('inbook'),
   Identifier('='),
   Identifier('or'),
   Identifier('type$'),
   String('incollection'),
   Identifier('='),
   Identifier('or'),
   Identifier('type$'),
   String('commented'),
   Identifier('='),
   Identifier('or'),
   QuotedVar('author.editor.key.label'),
   FunctionLiteral([Identifier('type$'), String('proceedings'), Identifier('='), QuotedVar('editor.key.label'), QuotedVar('author.key.label'), Identifier('if$')]),
   Identifier('if$'),
   QuotedVar('dummy.label'),
   Identifier(':=')]],
 ['FUNCTION',
  [Identifier('sort.format.names')],
  [QuotedVar('s'),
   Identifier(':='),
   Integer(1),
   QuotedVar('nameptr'),
   Identifier(':='),
   String(''),
   Identifier('s'),
   Identifier('num.names$'),
   QuotedVar('numnames'),
   Identifier(':='),
   Identifier('numnames'),
   QuotedVar('namesleft'),
   Identifier(':='),
   FunctionLiteral([Identifier('namesleft'), Integer(0), Identifier('>')]),
   FunctionLiteral([Identifier('nameptr'), Integer(1), Identifier('>'), FunctionLiteral([String('   '), Identifier('*')]), QuotedVar('skip$'), Identifier('if$'), Identifier('s'), Identifier('nameptr'), String('{ll{ }}{  ff{ }}{ vv{ }}{  jj{ }}'), Identifier('format.name$'), QuotedVar('t'), Identifier(':='), Identifier('nameptr'), Identifier('numnames'), Identifier('='), Identifier('t'), String('\\bibnf {others} {} {} {} {}'), Identifier('='), Identifier('and'), FunctionLiteral([String('\\Bibetal'), Identifier('*')]), FunctionLiteral([Identifier('t'), Identifier('sortify'), Identifier('*')]), Identifier('if$'), Identifier('nameptr'), Integer(1), Identifier('+'), QuotedVar('nameptr'), Identifier(':='), Identifier('namesleft'), Integer(1), Identifier('-'), QuotedVar('namesleft'), Identifier(':=')]),
   Identifier('while$')]],
 ['FUNCTION',
  [Identifier('sort.format.title')],
  [QuotedVar('t'),
   Identifier(':='),
   String('A '),
   Integer(2),
   String('An '),
   Integer(3),
   String('Der '),
   Integer(4),
   String('Die '),
   Integer(4),
   String('Das '),
   Integer(4),
   String('Ein '),
   Integer(4),
   String('Eine '),
   Integer(5),
   String('The '),
   Integer(4),
   Identifier('t'),
   Identifier('chop.word'),
   Identifier('chop.word'),
   Identifier('chop.word'),
   Identifier('chop.word'),
   Identifier('chop.word'),
   Identifier('chop.word'),
   Identifier('chop.word'),
   Identifier('chop.word'),
   Identifier('sortify'),
   Integer(1),
   Identifier('global.max$'),
   Identifier('substring$')]],
 ['FUNCTION',
  [Identifier('author.sort')],
  [Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('key'), Identifier('empty$'), FunctionLiteral([String('')]), FunctionLiteral([Identifier('key'), Identifier('sortify')]), Identifier('if$')]),
   FunctionLiteral([Identifier('author'), Identifier('sort.format.names')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('author.editor.sort')],
  [Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([Identifier('key'), Identifier('empty$'), FunctionLiteral([String('')]), FunctionLiteral([Identifier('key'), Identifier('sortify')]), Identifier('if$')]), FunctionLiteral([Identifier('editor'), Identifier('sort.format.names')]), Identifier('if$')]),
   FunctionLiteral([Identifier('author'), Identifier('sort.format.names')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('editor.sort')],
  [Identifier('editor'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('key'), Identifier('empty$'), FunctionLiteral([String('to sort, need editor or key in '), Identifier('cite$'), Identifier('*'), Identifier('warning$'), String('')]), FunctionLiteral([Identifier('key'), Identifier('sortify')]), Identifier('if$')]),
   FunctionLiteral([Identifier('editor'), Identifier('sort.format.names')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('archival.sort')],
  [Identifier('archive'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('shortarchive'), Identifier('empty$'), FunctionLiteral([String('to sort, need archive or shortarchive in '), Identifier('cite$'), Identifier('*'), Identifier('warning$'), String('')]), FunctionLiteral([Identifier('shortarchive'), Identifier('sortify')]), Identifier('if$')]),
   FunctionLiteral([Identifier('archive'), Identifier('sortify')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('presort')],
  [Identifier('calc.label'),
   Identifier('calc.dummy.label'),
   Identifier('dummy.label'),
   Identifier('sortify'),
   String(' '),
   Identifier('*'),
   Identifier('sortkey'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('type$'), String('book'), Identifier('='), Identifier('type$'), String('incollection'), Identifier('='), Identifier('or'), Identifier('type$'), String('inbook'), Identifier('='), Identifier('or'), Identifier('type$'), String('commented'), Identifier('='), Identifier('or'), QuotedVar('author.editor.sort'), FunctionLiteral([Identifier('type$'), String('proceedings'), Identifier('='), QuotedVar('editor.sort'), FunctionLiteral([Identifier('type$'), String('archival'), Identifier('='), QuotedVar('archival.sort'), QuotedVar('author.sort'), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]),
   FunctionLiteral([Identifier('sortkey'), Identifier('sort.format.names')]),
   Identifier('if$'),
   Identifier('type$'),
   String('archival'),
   Identifier('='),
   Identifier('not'),
   FunctionLiteral([String('    '), Identifier('*'), Identifier('year'), Identifier('field.or.null'), Identifier('sortify'), Identifier('*'), String('    '), Identifier('*'), Identifier('title'), Identifier('field.or.null'), Identifier('sort.format.title'), Identifier('*')]),
   FunctionLiteral([String('    '), Identifier('*'), Identifier('subarchive'), Identifier('field.or.null'), Identifier('sortify'), Identifier('*'), String('    '), Identifier('*'), Identifier('sig1'), Identifier('field.or.null'), Identifier('sortify'), Identifier('*'), String('    '), Identifier('*'), Identifier('sig2'), Identifier('field.or.null'), Identifier('sortify'), Identifier('*'), String('    '), Identifier('*'), Identifier('sig3'), Identifier('field.or.null'), Identifier('sortify'), Identifier('*'), String('    '), Identifier('*'), Identifier('sig4'), Identifier('field.or.null'), Identifier('sortify'), Identifier('*')]),
   Identifier('if$'),
   Integer(1),
   Identifier('entry.max$'),
   Identifier('substring$'),
   QuotedVar('sort.label'),
   Identifier(':='),
   Identifier('sort.label'),
   Identifier('*'),
   Integer(1),
   Identifier('entry.max$'),
   Identifier('substring$'),
   QuotedVar('sort.key$'),
   Identifier(':=')]],
 ['ITERATE', [Identifier('presort')]],
 ['SORT'],
 ['INTEGERS',
  [Identifier('last.extra.num'),
   Identifier('number.label'),
   Identifier('extra.extra.num')]],
 ['FUNCTION',
  [Identifier('make.extra.label')],
  [Identifier('last.extra.num'),
   Integer(122),
   Identifier('<'),
   FunctionLiteral([Identifier('last.extra.num'), Integer(1), Identifier('+')]),
   FunctionLiteral([Identifier('extra.extra.num'), Integer(0), Identifier('='), FunctionLiteral([String('a'), Identifier('chr.to.int$')]), FunctionLiteral([Identifier('extra.extra.num'), Integer(1), Identifier('+')]), Identifier('if$'), QuotedVar('extra.extra.num'), Identifier(':='), String('a'), Identifier('chr.to.int$')]),
   Identifier('if$'),
   QuotedVar('last.extra.num'),
   Identifier(':='),
   Identifier('extra.extra.num'),
   Integer(0),
   Identifier('='),
   FunctionLiteral([Identifier('last.extra.num'), Identifier('int.to.chr$')]),
   FunctionLiteral([Identifier('extra.extra.num'), Identifier('int.to.chr$'), QuotedVar('extra.label'), Identifier(':='), Identifier('extra.label'), Identifier('last.extra.num'), Identifier('int.to.chr$'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('forward.pass')],
  [Identifier('w'),
   Identifier('dummy.label'),
   Identifier('='),
   FunctionLiteral([Identifier('make.extra.label'), QuotedVar('extra.label'), Identifier(':=')]),
   FunctionLiteral([String('a'), Identifier('chr.to.int$'), QuotedVar('last.extra.num'), Identifier(':='), Integer(0), QuotedVar('extra.extra.num'), Identifier(':='), String(''), QuotedVar('extra.label'), Identifier(':='), Identifier('dummy.label'), QuotedVar('w'), Identifier(':=')]),
   Identifier('if$'),
   Identifier('number.label'),
   Integer(1),
   Identifier('+'),
   QuotedVar('number.label'),
   Identifier(':=')]],
 ['FUNCTION',
  [Identifier('reverse.pass')],
  [Identifier('x'),
   String('b'),
   Identifier('='),
   FunctionLiteral([String('a'), QuotedVar('extra.label'), Identifier(':=')]),
   QuotedVar('skip$'),
   Identifier('if$'),
   Identifier('extra.label'),
   QuotedVar('x'),
   Identifier(':='),
   Identifier('extra.label'),
   Identifier('duplicate$'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([String(''), Identifier('swap$'), Identifier('*')]),
   Identifier('if$'),
   QuotedVar('extra.label'),
   Identifier(':='),
   Identifier('dummy.label'),
   Identifier('extra.label'),
   Identifier('*'),
   QuotedVar('dummy.label'),
   Identifier(':=')]],
 ['ITERATE', [Identifier('forward.pass')]],
 ['REVERSE', [Identifier('reverse.pass')]],
 ['FUNCTION',
  [Identifier('bib.sort.order')],
  [Identifier('sort.label'), QuotedVar('sort.key$'), Identifier(':=')]],
 ['ITERATE', [Identifier('bib.sort.order')]],
 ['SORT'],
 ['FUNCTION',
  [Identifier('set.current.authors')],
  [Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([Identifier('organization'), Identifier('empty$'), FunctionLiteral([Identifier('cite$'), QuotedVar('current-authors'), Identifier(':=')]), FunctionLiteral([Identifier('organization'), QuotedVar('current-authors'), Identifier(':=')]), Identifier('if$')]), FunctionLiteral([Identifier('editor'), Identifier('format.names'), Integer(1), Identifier('entry.max$'), Identifier('substring$'), QuotedVar('current-authors'), Identifier(':=')]), Identifier('if$')]),
   FunctionLiteral([Identifier('author'), Identifier('format.names'), Integer(1), Identifier('entry.max$'), Identifier('substring$'), QuotedVar('current-authors'), Identifier(':=')]),
   Identifier('if$')]],
 ['STRINGS', [Identifier('previous-authors')]],
 ['FUNCTION',
  [Identifier('initialize.previous.authors')],
  [String(''), QuotedVar('previous-authors'), Identifier(':=')]],
 ['FUNCTION',
  [Identifier('mark.repeat.authors')],
  [Identifier('current-authors'),
   Identifier('previous-authors'),
   Identifier('='),
   FunctionLiteral([Integer(1), QuotedVar('repeat-authors'), Identifier(':=')]),
   QuotedVar('skip$'),
   Identifier('if$'),
   Identifier('current-authors'),
   QuotedVar('previous-authors'),
   Identifier(':=')]],
 ['ITERATE', [Identifier('set.current.authors')]],
 ['EXECUTE', [Identifier('initialize.previous.authors')]],
 ['ITERATE', [Identifier('mark.repeat.authors')]],
 ['EXECUTE', [Identifier('initialize.previous.authors')]],
 ['REVERSE', [Identifier('mark.repeat.authors')]],
 ['FUNCTION',
  [Identifier('begin.bib')],
  [Identifier('preamble$'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('preamble$'), Identifier('write$'), Identifier('newline$')]),
   Identifier('if$'),
   String('%'),
   Identifier('write$'),
   Identifier('newline$'),
   String('% This bibliography was produced by using jurabib.bst'),
   Identifier('write$'),
   Identifier('newline$'),
   String('%'),
   Identifier('write$'),
   Identifier('newline$'),
   String('\\begin{thebibliography}{}'),
   Identifier('write$'),
   Identifier('newline$')]],
 ['EXECUTE', [Identifier('begin.bib')]],
 ['EXECUTE', [Identifier('init.state.consts')]],
 ['ITERATE', [Identifier('call.type$')]],
 ['FUNCTION',
  [Identifier('end.bib')],
  [Identifier('newline$'),
   String('\\end{thebibliography}'),
   Identifier('write$'),
   Identifier('newline$')]],
 ['EXECUTE', [Identifier('end.bib')]]]
