/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.report;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.plugins.report.ReportOutputter;
import org.apache.ivy.plugins.report.XmlReportWriter;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;

public class XmlReportOutputter
implements ReportOutputter {
    private XmlReportWriter writer = new XmlReportWriter();

    @Override
    public String getName() {
        return "xml";
    }

    @Override
    public void output(ResolveReport resolveReport, ResolutionCacheManager resolutionCacheManager, ResolveOptions resolveOptions) throws IOException {
        String[] stringArray = resolveReport.getConfigurations();
        for (int i = 0; i < stringArray.length; ++i) {
            this.output(resolveReport.getConfigurationReport(stringArray[i]), resolveReport.getResolveId(), stringArray, resolutionCacheManager);
        }
    }

    public void output(ConfigurationResolveReport configurationResolveReport, String string, String[] stringArray, ResolutionCacheManager resolutionCacheManager) throws IOException {
        File file = resolutionCacheManager.getConfigurationResolveReportInCache(string, configurationResolveReport.getConfiguration());
        File file2 = file.getParentFile();
        file2.mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.writer.output(configurationResolveReport, stringArray, fileOutputStream);
        ((OutputStream)fileOutputStream).close();
        Message.verbose("\treport for " + configurationResolveReport.getModuleDescriptor().getModuleRevisionId() + " " + configurationResolveReport.getConfiguration() + " produced in " + file);
        File file3 = new File(file2, "ivy-report.xsl");
        File file4 = new File(file2, "ivy-report.css");
        if (!file3.exists()) {
            FileUtil.copy(XmlReportOutputter.class.getResourceAsStream("ivy-report.xsl"), file3, null);
        }
        if (!file4.exists()) {
            FileUtil.copy(XmlReportOutputter.class.getResourceAsStream("ivy-report.css"), file4, null);
        }
    }
}

