/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import com.sun.webpane.webkit.dom.NodeImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeListImpl
implements NodeList {
    protected final long peer;

    NodeListImpl(long peer) {
        this.peer = peer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static NodeList create(long peer) {
        if (peer == 0L) {
            return null;
        }
        return new NodeListImpl(peer);
    }

    public boolean equals(Object that) {
        return that instanceof NodeListImpl && this.peer == ((NodeListImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    long getPeer() {
        return this.peer;
    }

    static long getPeer(NodeList arg) {
        return arg == null ? 0L : ((NodeListImpl)arg).getPeer();
    }

    private static native void dispose(long var0);

    static NodeList getImpl(long peer) {
        return NodeListImpl.create(peer);
    }

    @Override
    public int getLength() {
        return NodeListImpl.getLengthImpl(this.getPeer());
    }

    static native int getLengthImpl(long var0);

    @Override
    public Node item(int index) {
        return NodeImpl.getImpl(NodeListImpl.itemImpl(this.getPeer(), index));
    }

    static native long itemImpl(long var0, int var2);

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            NodeListImpl.dispose(this.peer);
        }
    }
}

