// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `ImplicitContext.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Ice_ImplicitContext_h__
#define __Ice_ImplicitContext_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/LocalException.h>
#include <Ice/Current.h>
#include <IceUtil/UndefSysMacros.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 1
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICE_API
#   if defined(ICE_STATIC_LIBS)
#       define ICE_API /**/
#   elif defined(ICE_API_EXPORTS)
#       define ICE_API ICE_DECLSPEC_EXPORT
#   else
#       define ICE_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace Ice
{

class ImplicitContext;

}

namespace Ice
{

/**
 * An interface to associate implict contexts with communicators.
 *
 * When you make a remote invocation without an explicit context parameter,
 * Ice uses the per-proxy context (if any) combined with the <tt>ImplicitContext</tt>
 * associated with the communicator.
 *
 * Ice provides several implementations of <tt>ImplicitContext</tt>. The implementation
 * used depends on the value of the <tt>Ice.ImplicitContext</tt> property.
 * <dl>
 * <dt><tt>None</tt> (default)</dt>
 * <dd>No implicit context at all.</dd>
 * <dt><tt>PerThread</tt></dt>
 * <dd>The implementation maintains a context per thread.</dd>
 * <dt><tt>Shared</tt></dt>
 * <dd>The implementation maintains a single context shared by all threads.</dd>
 * </dl>
 *
 * <tt>ImplicitContext</tt> also provides a number of operations to create, update or retrieve
 * an entry in the underlying context without first retrieving a copy of the entire
 * context. These operations correspond to a subset of the <tt>java.util.Map</tt> methods,
 * with <tt>java.lang.Object</tt> replaced by <tt>string</tt> and null replaced by the empty-string.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) ImplicitContext
{
public:

    ICE_MEMBER(ICE_API) virtual ~ImplicitContext();

    /**
     * Get a copy of the underlying context.
     * @return A copy of the underlying context.
     */
    virtual ::Ice::Context getContext() const = 0;

    /**
     * Set the underlying context.
     * @param newContext The new context.
     */
    virtual void setContext(const Context& newContext) = 0;

    /**
     * Check if this key has an associated value in the underlying context.
     * @param key The key.
     * @return True if the key has an associated value, False otherwise.
     */
    virtual bool containsKey(const ::std::string& key) const = 0;

    /**
     * Get the value associated with the given key in the underlying context.
     * Returns an empty string if no value is associated with the key.
     * {@link #containsKey} allows you to distinguish between an empty-string value and
     * no value at all.
     * @param key The key.
     * @return The value associated with the key.
     */
    virtual ::std::string get(const ::std::string& key) const = 0;

    /**
     * Create or update a key/value entry in the underlying context.
     * @param key The key.
     * @param value The value.
     * @return The previous value associated with the key, if any.
     */
    virtual ::std::string put(const ::std::string& key, const ::std::string& value) = 0;

    /**
     * Remove the entry for the given key in the underlying context.
     * @param key The key.
     * @return The value associated with the key, if any.
     */
    virtual ::std::string remove(const ::std::string& key) = 0;
};

}

/// \cond STREAM
namespace Ice
{

}
/// \endcond

/// \cond INTERNAL
namespace Ice
{

using ImplicitContextPtr = ::std::shared_ptr<ImplicitContext>;

}
/// \endcond

#else // C++98 mapping

namespace Ice
{

class ImplicitContext;
/// \cond INTERNAL
ICE_API LocalObject* upCast(ImplicitContext*);
/// \endcond
typedef ::IceInternal::Handle< ImplicitContext> ImplicitContextPtr;

}

namespace Ice
{

/**
 * An interface to associate implict contexts with communicators.
 *
 * When you make a remote invocation without an explicit context parameter,
 * Ice uses the per-proxy context (if any) combined with the <tt>ImplicitContext</tt>
 * associated with the communicator.
 *
 * Ice provides several implementations of <tt>ImplicitContext</tt>. The implementation
 * used depends on the value of the <tt>Ice.ImplicitContext</tt> property.
 * <dl>
 * <dt><tt>None</tt> (default)</dt>
 * <dd>No implicit context at all.</dd>
 * <dt><tt>PerThread</tt></dt>
 * <dd>The implementation maintains a context per thread.</dd>
 * <dt><tt>Shared</tt></dt>
 * <dd>The implementation maintains a single context shared by all threads.</dd>
 * </dl>
 *
 * <tt>ImplicitContext</tt> also provides a number of operations to create, update or retrieve
 * an entry in the underlying context without first retrieving a copy of the entire
 * context. These operations correspond to a subset of the <tt>java.util.Map</tt> methods,
 * with <tt>java.lang.Object</tt> replaced by <tt>string</tt> and null replaced by the empty-string.
 * \headerfile Ice/Ice.h
 */
class ICE_API ImplicitContext : public virtual LocalObject
{
public:

    typedef ImplicitContextPtr PointerType;

    virtual ~ImplicitContext();

    /**
     * Get a copy of the underlying context.
     * @return A copy of the underlying context.
     */
    virtual Context getContext() const = 0;

    /**
     * Set the underlying context.
     * @param newContext The new context.
     */
    virtual void setContext(const Context& newContext) = 0;

    /**
     * Check if this key has an associated value in the underlying context.
     * @param key The key.
     * @return True if the key has an associated value, False otherwise.
     */
    virtual bool containsKey(const ::std::string& key) const = 0;

    /**
     * Get the value associated with the given key in the underlying context.
     * Returns an empty string if no value is associated with the key.
     * {@link #containsKey} allows you to distinguish between an empty-string value and
     * no value at all.
     * @param key The key.
     * @return The value associated with the key.
     */
    virtual ::std::string get(const ::std::string& key) const = 0;

    /**
     * Create or update a key/value entry in the underlying context.
     * @param key The key.
     * @param value The value.
     * @return The previous value associated with the key, if any.
     */
    virtual ::std::string put(const ::std::string& key, const ::std::string& value) = 0;

    /**
     * Remove the entry for the given key in the underlying context.
     * @param key The key.
     * @return The value associated with the key, if any.
     */
    virtual ::std::string remove(const ::std::string& key) = 0;
};

/// \cond INTERNAL
inline bool operator==(const ImplicitContext& lhs, const ImplicitContext& rhs)
{
    return static_cast<const LocalObject&>(lhs) == static_cast<const LocalObject&>(rhs);
}

inline bool operator<(const ImplicitContext& lhs, const ImplicitContext& rhs)
{
    return static_cast<const LocalObject&>(lhs) < static_cast<const LocalObject&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

}
/// \endcond

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
