/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Logger;
import Ice.Properties;
import IceInternal.MetricsAdminI;
import IceInternal.MetricsMap;
import IceMX.Metrics;
import IceMX.MetricsFailures;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class MetricsViewI {
    private final String _name;
    private final Map<String, MetricsMap<?>> _maps = new HashMap();

    MetricsViewI(String name) {
        this._name = name;
    }

    public boolean addOrUpdateMap(Properties properties, String mapName, MetricsAdminI.MetricsMapFactory<?> factory, Logger logger) {
        String mapPrefix;
        String viewPrefix = "IceMX.Metrics." + this._name + ".";
        String mapsPrefix = viewPrefix + "Map.";
        Map<String, String> mapsProps = properties.getPropertiesForPrefix(mapsPrefix);
        Map<Object, Object> mapProps = new HashMap();
        if (!mapsProps.isEmpty()) {
            mapPrefix = mapsPrefix + mapName + ".";
            mapProps = properties.getPropertiesForPrefix(mapPrefix);
            if (mapProps.isEmpty()) {
                return this._maps.remove(mapName) != null;
            }
        } else {
            mapPrefix = viewPrefix;
            mapProps = properties.getPropertiesForPrefix(mapPrefix);
        }
        if (properties.getPropertyAsInt(mapPrefix + "Disabled") > 0) {
            return this._maps.remove(mapName) != null;
        }
        MetricsMap<?> m = this._maps.get(mapName);
        if (m != null && m.getProperties().equals(mapProps)) {
            return false;
        }
        try {
            this._maps.put(mapName, factory.create(mapPrefix, properties));
        }
        catch (Exception ex) {
            logger.warning("unexpected exception while creating metrics map:\n" + ex);
            this._maps.remove(mapName);
        }
        return true;
    }

    public boolean removeMap(String mapName) {
        return this._maps.remove(mapName) != null;
    }

    public Map<String, Metrics[]> getMetrics() {
        HashMap<String, Metrics[]> metrics = new HashMap<String, Metrics[]>();
        for (Map.Entry<String, MetricsMap<?>> e : this._maps.entrySet()) {
            metrics.put(e.getKey(), e.getValue().getMetrics());
        }
        return metrics;
    }

    public MetricsFailures[] getFailures(String mapName) {
        MetricsMap<?> m = this._maps.get(mapName);
        if (m != null) {
            return m.getFailures();
        }
        return null;
    }

    public MetricsFailures getFailures(String mapName, String id) {
        MetricsMap<?> m = this._maps.get(mapName);
        if (m != null) {
            return m.getFailures(id);
        }
        return null;
    }

    public Collection<String> getMaps() {
        return this._maps.keySet();
    }

    public <T extends Metrics> MetricsMap<T> getMap(String mapName, Class<T> cl) {
        return this._maps.get(mapName);
    }
}

