/*
 * Decompiled with CFR 0.152.
 */
package IceSSL;

import Ice.LocalException;
import java.util.LinkedList;
import java.util.List;

class RFC2253 {
    private static final String special = ",=+<>#;";
    private static final String hexvalid = "0123456789abcdefABCDEF";

    RFC2253() {
    }

    public static List<RDNEntry> parse(String data) throws ParseException {
        LinkedList<RDNEntry> results = new LinkedList<RDNEntry>();
        RDNEntry current = new RDNEntry();
        ParseState state = new ParseState();
        state.data = data;
        state.pos = 0;
        while (state.pos < state.data.length()) {
            RFC2253.eatWhite(state);
            if (state.pos < state.data.length() && state.data.charAt(state.pos) == '!') {
                if (!current.rdn.isEmpty()) {
                    throw new ParseException("negation symbol '!' must appear at start of list");
                }
                ++state.pos;
                current.negate = true;
            }
            current.rdn.add(RFC2253.parseNameComponent(state));
            RFC2253.eatWhite(state);
            if (state.pos < state.data.length() && state.data.charAt(state.pos) == ',') {
                ++state.pos;
                continue;
            }
            if (state.pos < state.data.length() && state.data.charAt(state.pos) == ';') {
                ++state.pos;
                results.add(current);
                current = new RDNEntry();
                continue;
            }
            if (state.pos >= state.data.length()) continue;
            throw new ParseException("expected ',' or ';' at `" + state.data.substring(state.pos) + "'");
        }
        if (!current.rdn.isEmpty()) {
            results.add(current);
        }
        return results;
    }

    public static List<RDNPair> parseStrict(String data) throws ParseException {
        LinkedList<RDNPair> results = new LinkedList<RDNPair>();
        ParseState state = new ParseState();
        state.data = data;
        state.pos = 0;
        while (state.pos < state.data.length()) {
            results.add(RFC2253.parseNameComponent(state));
            RFC2253.eatWhite(state);
            if (state.pos < state.data.length() && (state.data.charAt(state.pos) == ',' || state.data.charAt(state.pos) == ';')) {
                ++state.pos;
                continue;
            }
            if (state.pos >= state.data.length()) continue;
            throw new ParseException("expected ',' or ';' at `" + state.data.substring(state.pos) + "'");
        }
        return results;
    }

    private static RDNPair parseNameComponent(ParseState state) throws ParseException {
        RDNPair result = RFC2253.parseAttributeTypeAndValue(state);
        while (state.pos < state.data.length()) {
            RFC2253.eatWhite(state);
            if (state.pos >= state.data.length() || state.data.charAt(state.pos) != '+') break;
            ++state.pos;
            RDNPair p = RFC2253.parseAttributeTypeAndValue(state);
            result.value = result.value + "+";
            result.value = result.value + p.key;
            result.value = result.value + '=';
            result.value = result.value + p.value;
        }
        return result;
    }

    private static RDNPair parseAttributeTypeAndValue(ParseState state) throws ParseException {
        RDNPair p = new RDNPair();
        p.key = RFC2253.parseAttributeType(state);
        RFC2253.eatWhite(state);
        if (state.pos >= state.data.length()) {
            throw new ParseException("invalid attribute type/value pair (unexpected end of state.data)");
        }
        if (state.data.charAt(state.pos) != '=') {
            throw new ParseException("invalid attribute type/value pair (missing =)");
        }
        ++state.pos;
        p.value = RFC2253.parseAttributeValue(state);
        return p;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String parseAttributeType(ParseState state) throws ParseException {
        RFC2253.eatWhite(state);
        if (state.pos >= state.data.length()) {
            throw new ParseException("invalid attribute type (expected end of state.data)");
        }
        StringBuffer result = new StringBuffer();
        if (Character.isDigit(state.data.charAt(state.pos)) || state.data.length() - state.pos >= 4 && (state.data.substring(state.pos, state.pos + 4).equals("oid.") || state.data.substring(state.pos, state.pos + 4).equals("OID."))) {
            if (!Character.isDigit(state.data.charAt(state.pos))) {
                result.append(state.data.substring(state.pos, state.pos + 4));
                state.pos += 4;
            }
            while (true) {
                if (state.pos < state.data.length() && Character.isDigit(state.data.charAt(state.pos))) {
                    result.append(state.data.charAt(state.pos));
                    ++state.pos;
                    continue;
                }
                if (state.pos >= state.data.length() || state.data.charAt(state.pos) != '.') return result.toString();
                result.append(state.data.charAt(state.pos));
                ++state.pos;
                if (state.pos < state.data.length() && !Character.isDigit(state.data.charAt(state.pos))) throw new ParseException("invalid attribute type (expected end of state.data)");
            }
        }
        if (!Character.isUpperCase(state.data.charAt(state.pos)) && !Character.isLowerCase(state.data.charAt(state.pos))) throw new ParseException("invalid attribute type");
        result.append(state.data.charAt(state.pos));
        ++state.pos;
        while (state.pos < state.data.length() && (Character.isDigit(state.data.charAt(state.pos)) || Character.isUpperCase(state.data.charAt(state.pos)) || Character.isLowerCase(state.data.charAt(state.pos)) || state.data.charAt(state.pos) == '-')) {
            result.append(state.data.charAt(state.pos));
            ++state.pos;
        }
        return result.toString();
    }

    private static String parseAttributeValue(ParseState state) throws ParseException {
        StringBuffer result;
        block12: {
            RFC2253.eatWhite(state);
            if (state.pos >= state.data.length()) {
                return "";
            }
            result = new StringBuffer();
            if (state.data.charAt(state.pos) == '#') {
                String h;
                result.append(state.data.charAt(state.pos));
                ++state.pos;
                while ((h = RFC2253.parseHexPair(state, true)).length() != 0) {
                    result.append(h);
                }
            } else {
                if (state.data.charAt(state.pos) == '\"') {
                    result.append(state.data.charAt(state.pos));
                    ++state.pos;
                    while (true) {
                        if (state.pos >= state.data.length()) {
                            throw new ParseException("invalid attribute value (unexpected end of state.data)");
                        }
                        if (state.data.charAt(state.pos) == '\"') {
                            result.append(state.data.charAt(state.pos));
                            ++state.pos;
                            break block12;
                        }
                        if (state.data.charAt(state.pos) != '\\') {
                            result.append(state.data.charAt(state.pos));
                            ++state.pos;
                            continue;
                        }
                        result.append(RFC2253.parsePair(state));
                    }
                }
                while (state.pos < state.data.length()) {
                    if (state.data.charAt(state.pos) == '\\') {
                        result.append(RFC2253.parsePair(state));
                        continue;
                    }
                    if (special.indexOf(state.data.charAt(state.pos)) == -1 && state.data.charAt(state.pos) != '\"') {
                        result.append(state.data.charAt(state.pos));
                        ++state.pos;
                        continue;
                    }
                    break;
                }
            }
        }
        return result.toString();
    }

    private static String parsePair(ParseState state) throws ParseException {
        String result = "";
        assert (state.data.charAt(state.pos) == '\\');
        result = result + state.data.charAt(state.pos);
        ++state.pos;
        if (state.pos >= state.data.length()) {
            throw new ParseException("invalid escape format (unexpected end of state.data)");
        }
        if (special.indexOf(state.data.charAt(state.pos)) != -1 || state.data.charAt(state.pos) != '\\' || state.data.charAt(state.pos) != '\"') {
            result = result + state.data.charAt(state.pos);
            ++state.pos;
            return result;
        }
        return RFC2253.parseHexPair(state, false);
    }

    private static String parseHexPair(ParseState state, boolean allowEmpty) throws ParseException {
        String result = "";
        if (state.pos < state.data.length() && hexvalid.indexOf(state.data.charAt(state.pos)) != -1) {
            result = result + state.data.charAt(state.pos);
            ++state.pos;
        }
        if (state.pos < state.data.length() && hexvalid.indexOf(state.data.charAt(state.pos)) != -1) {
            result = result + state.data.charAt(state.pos);
            ++state.pos;
        }
        if (result.length() != 2) {
            if (allowEmpty && result.length() == 0) {
                return result;
            }
            throw new ParseException("invalid hex format");
        }
        return result;
    }

    private static void eatWhite(ParseState state) {
        while (state.pos < state.data.length() && state.data.charAt(state.pos) == ' ') {
            ++state.pos;
        }
    }

    private static class ParseState {
        String data;
        int pos;

        private ParseState() {
        }
    }

    static class RDNEntry {
        List<RDNPair> rdn = new LinkedList<RDNPair>();
        boolean negate = false;

        RDNEntry() {
        }
    }

    static class RDNPair {
        String key;
        String value;

        RDNPair() {
        }
    }

    static class ParseException
    extends LocalException {
        public String reason;

        public ParseException() {
        }

        public ParseException(String reason) {
            this.reason = reason;
        }

        @Override
        public String ice_id() {
            return "::RFC2253::ParseException";
        }
    }
}

