/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.Glacier2;

import com.zeroc.Glacier2.CannotCreateSessionException;
import com.zeroc.Glacier2.PermissionDeniedException;
import com.zeroc.Glacier2.SessionNotExistException;
import com.zeroc.Glacier2.SessionPrx;
import com.zeroc.Ice.Current;
import com.zeroc.Ice.FormatType;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.UserException;
import com.zeroc.IceInternal.Incoming;
import java.util.Arrays;
import java.util.concurrent.CompletionStage;

public interface Router
extends com.zeroc.Ice.Router {
    public static final String[] _iceIds;
    public static final String[] _iceOps;

    public String getCategoryForClient(Current var1);

    public CompletionStage<SessionPrx> createSessionAsync(String var1, String var2, Current var3) throws CannotCreateSessionException, PermissionDeniedException;

    public CompletionStage<SessionPrx> createSessionFromSecureConnectionAsync(Current var1) throws CannotCreateSessionException, PermissionDeniedException;

    public CompletionStage<Void> refreshSessionAsync(Current var1) throws SessionNotExistException;

    public void destroySession(Current var1) throws SessionNotExistException;

    public long getSessionTimeout(Current var1);

    public int getACMTimeout(Current var1);

    @Override
    default public String[] ice_ids(Current current) {
        return _iceIds;
    }

    @Override
    default public String ice_id(Current current) {
        return Router.ice_staticId();
    }

    public static String ice_staticId() {
        return "::Glacier2::Router";
    }

    public static CompletionStage<OutputStream> _iceD_getCategoryForClient(Router obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        String ret = obj.getCategoryForClient(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeString(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_createSession(Router obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_userId = istr.readString();
        String iceP_password = istr.readString();
        inS.endReadParams();
        inS.setFormat(FormatType.SlicedFormat);
        return inS.setResultFuture(obj.createSessionAsync(iceP_userId, iceP_password, current), (ostr, ret) -> ostr.writeProxy((ObjectPrx)ret));
    }

    public static CompletionStage<OutputStream> _iceD_createSessionFromSecureConnection(Router obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        inS.readEmptyParams();
        inS.setFormat(FormatType.SlicedFormat);
        return inS.setResultFuture(obj.createSessionFromSecureConnectionAsync(current), (ostr, ret) -> ostr.writeProxy((ObjectPrx)ret));
    }

    public static CompletionStage<OutputStream> _iceD_refreshSession(Router obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        inS.readEmptyParams();
        return inS.setResultFuture(obj.refreshSessionAsync(current));
    }

    public static CompletionStage<OutputStream> _iceD_destroySession(Router obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        inS.readEmptyParams();
        obj.destroySession(current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_getSessionTimeout(Router obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        long ret = obj.getSessionTimeout(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeLong(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getACMTimeout(Router obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        int ret = obj.getACMTimeout(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeInt(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    @Override
    default public CompletionStage<OutputStream> _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_iceOps, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return com.zeroc.Ice.Router._iceD_addProxies(this, in, current);
            }
            case 1: {
                return Router._iceD_createSession(this, in, current);
            }
            case 2: {
                return Router._iceD_createSessionFromSecureConnection(this, in, current);
            }
            case 3: {
                return Router._iceD_destroySession(this, in, current);
            }
            case 4: {
                return Router._iceD_getACMTimeout(this, in, current);
            }
            case 5: {
                return Router._iceD_getCategoryForClient(this, in, current);
            }
            case 6: {
                return com.zeroc.Ice.Router._iceD_getClientProxy(this, in, current);
            }
            case 7: {
                return com.zeroc.Ice.Router._iceD_getServerProxy(this, in, current);
            }
            case 8: {
                return Router._iceD_getSessionTimeout(this, in, current);
            }
            case 9: {
                return Object._iceD_ice_id(this, in, current);
            }
            case 10: {
                return Object._iceD_ice_ids(this, in, current);
            }
            case 11: {
                return Object._iceD_ice_isA(this, in, current);
            }
            case 12: {
                return Object._iceD_ice_ping(this, in, current);
            }
            case 13: {
                return Router._iceD_refreshSession(this, in, current);
            }
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        _iceIds = new String[]{"::Glacier2::Router", "::Ice::Object", "::Ice::Router"};
        _iceOps = new String[]{"addProxies", "createSession", "createSessionFromSecureConnection", "destroySession", "getACMTimeout", "getCategoryForClient", "getClientProxy", "getServerProxy", "getSessionTimeout", "ice_id", "ice_ids", "ice_isA", "ice_ping", "refreshSession"};
    }
}

