/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Color;
import org.netbeans.modules.profiler.snaptracer.ProbeItemDescriptor;
import org.netbeans.modules.profiler.snaptracer.impl.IdeSnapshot;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.ContinuousXYPainter;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.DiscreteXYPainter;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.PointsComputer;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineColorFactory;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineIconPainter;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineXYPainter;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.items.ContinuousXYItemDescriptor;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.items.DiscreteXYItemDescriptor;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.items.IconItemDescriptor;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.items.ValueItemDescriptor;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.items.XYItemDescriptor;

final class TimelinePaintersFactory {
    TimelinePaintersFactory() {
    }

    static TimelineXYPainter createPainter(ProbeItemDescriptor probeItemDescriptor, int n, PointsComputer pointsComputer, IdeSnapshot ideSnapshot) {
        if (probeItemDescriptor instanceof ValueItemDescriptor) {
            return TimelinePaintersFactory.createValuePainter((ValueItemDescriptor)probeItemDescriptor, n, pointsComputer, ideSnapshot);
        }
        return null;
    }

    private static TimelineXYPainter createValuePainter(ValueItemDescriptor valueItemDescriptor, int n, PointsComputer pointsComputer, IdeSnapshot ideSnapshot) {
        if (valueItemDescriptor instanceof ContinuousXYItemDescriptor) {
            return TimelinePaintersFactory.createContinuousPainter((ContinuousXYItemDescriptor)valueItemDescriptor, n, pointsComputer);
        }
        if (valueItemDescriptor instanceof DiscreteXYItemDescriptor) {
            return TimelinePaintersFactory.createDiscretePainter((DiscreteXYItemDescriptor)valueItemDescriptor, n, pointsComputer);
        }
        if (valueItemDescriptor instanceof IconItemDescriptor) {
            return TimelinePaintersFactory.createIconPainter((IconItemDescriptor)valueItemDescriptor, n, ideSnapshot);
        }
        return null;
    }

    private static TimelineXYPainter createContinuousPainter(XYItemDescriptor xYItemDescriptor, int n, PointsComputer pointsComputer) {
        Color color;
        Color color2;
        double d = xYItemDescriptor.getDataFactor();
        float f = xYItemDescriptor.getLineWidth();
        if (f == -1.0f) {
            f = 2.0f;
        }
        if ((color2 = xYItemDescriptor.getLineColor()) == ProbeItemDescriptor.DEFAULT_COLOR) {
            color2 = TimelineColorFactory.getColor(n);
        }
        if ((color = xYItemDescriptor.getFillColor()) == ProbeItemDescriptor.DEFAULT_COLOR) {
            color = color2 == null ? TimelineColorFactory.getColor(n) : TimelineColorFactory.getGradient(n)[0];
        }
        return new ContinuousXYPainter(f, color2, color, d, pointsComputer);
    }

    private static DiscreteXYPainter createDiscretePainter(DiscreteXYItemDescriptor discreteXYItemDescriptor, int n, PointsComputer pointsComputer) {
        Color color;
        Color color2;
        double d = discreteXYItemDescriptor.getDataFactor();
        float f = discreteXYItemDescriptor.getLineWidth();
        if (f == -1.0f) {
            f = 2.0f;
        }
        if ((color2 = discreteXYItemDescriptor.getLineColor()) == ProbeItemDescriptor.DEFAULT_COLOR) {
            color2 = TimelineColorFactory.getColor(n);
        }
        if ((color = discreteXYItemDescriptor.getFillColor()) == ProbeItemDescriptor.DEFAULT_COLOR) {
            color = color2 == null ? TimelineColorFactory.getColor(n) : TimelineColorFactory.getGradient(n)[0];
        }
        return new DiscreteXYPainter(f, color2, color, discreteXYItemDescriptor.getWidth(), discreteXYItemDescriptor.isFixedWidth(), discreteXYItemDescriptor.isTopLineOnly(), discreteXYItemDescriptor.isOutlineOnly(), d, pointsComputer);
    }

    private static TimelineIconPainter createIconPainter(IconItemDescriptor iconItemDescriptor, int n, IdeSnapshot ideSnapshot) {
        Color color = iconItemDescriptor.getColor();
        if (color == ProbeItemDescriptor.DEFAULT_COLOR) {
            color = TimelineColorFactory.getColor(n);
        }
        return new TimelineIconPainter(color, ideSnapshot);
    }
}

