/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

class CacheDirectory {
    private static final String DIR_EXT = ".hwcache";
    private static final String DUMP_AUX_FILE = "NBProfiler.nphd";
    private File cacheDirectory;

    static CacheDirectory getHeapDumpCacheDirectory(File file) {
        String string = file.getName();
        File file2 = file.getParentFile();
        File file3 = new File(file2, string + DIR_EXT);
        return new CacheDirectory(file3);
    }

    CacheDirectory(File file) {
        this.cacheDirectory = file;
        if (file != null && !file.exists() && !file.mkdir()) {
            this.cacheDirectory = null;
        }
        if (this.cacheDirectory != null) assert (this.cacheDirectory.isDirectory() && this.cacheDirectory.canRead() && this.cacheDirectory.canWrite());
    }

    File createTempFile(String string, String string2) throws IOException {
        File file;
        if (this.isTemporary()) {
            file = File.createTempFile(string, string2);
            file.deleteOnExit();
        } else {
            file = File.createTempFile(string, string2, this.cacheDirectory);
        }
        return file;
    }

    File getHeapDumpAuxFile() {
        assert (!this.isTemporary());
        return new File(this.cacheDirectory, DUMP_AUX_FILE);
    }

    boolean isTemporary() {
        return this.cacheDirectory == null;
    }

    File getCacheFile(String string) throws FileNotFoundException {
        File file = new File(string);
        if (CacheDirectory.isFileRW(file)) {
            return file;
        }
        if (CacheDirectory.isFileRW(file = new File(this.cacheDirectory, file.getName()))) {
            return file;
        }
        throw new FileNotFoundException(string);
    }

    File getHeapFile(String string) throws FileNotFoundException {
        File file = new File(string);
        if (CacheDirectory.isFileR(file)) {
            return file;
        }
        file = new File(this.cacheDirectory.getParentFile(), file.getName());
        if (CacheDirectory.isFileR(file)) {
            return file;
        }
        throw new FileNotFoundException(string);
    }

    private static boolean isFileR(File file) {
        return file.exists() && file.isFile() && file.canRead();
    }

    private static boolean isFileRW(File file) {
        return CacheDirectory.isFileR(file) && file.canWrite();
    }

    private static boolean isLinux() {
        String string = System.getProperty("os.name");
        return string.endsWith("Linux");
    }
}

