/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Utils;

public class UrlLabel
extends JLabel
implements MouseListener {
    private String url = "";
    private String description = "";

    public UrlLabel() {
        this.addMouseListener(this);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public UrlLabel(String url) {
        this(url, url, 0);
    }

    public UrlLabel(String url, int fontPlus) {
        this(url, url, fontPlus);
    }

    public UrlLabel(String url, String description) {
        this(url, description, 0);
    }

    public UrlLabel(String url, String description, int fontPlus) {
        this();
        this.setUrl(url);
        this.setDescription(description);
        if (fontPlus != 0) {
            this.setFont(this.getFont().deriveFont(0, (float)this.getFont().getSize() + (float)fontPlus));
        }
        this.refresh();
    }

    protected final void refresh() {
        if (this.url != null && !this.url.isEmpty()) {
            this.setText("<html><a href=\"" + this.url + "\">" + this.description + "</a></html>");
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setToolTipText(String.format("<html>%s<br/>%s</html>", this.url, I18n.tr("Right click = copy to clipboard", new Object[0])));
        } else {
            this.setText("<html>" + this.description + "</html>");
            this.setCursor(null);
            this.setToolTipText(null);
        }
    }

    public final void setUrl(String url) {
        this.url = url;
        this.refresh();
    }

    public final void setDescription(String description) {
        this.setDescription(description, true);
    }

    public final void setDescription(String description, boolean escapeReservedCharacters) {
        String string = this.description = description == null ? "" : description;
        if (escapeReservedCharacters) {
            this.description = Utils.escapeReservedCharactersHTML(this.description);
        }
        this.refresh();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.url != null && !this.url.isEmpty()) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                OpenBrowser.displayUrl(this.url);
            } else if (SwingUtilities.isRightMouseButton(e)) {
                ClipboardUtils.copyString(this.url);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

