/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.actions.JoinAreasAction;
import org.openstreetmap.josm.command.PurgeCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DownloadPolicy;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.UploadPolicy;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.io.OsmWriterFactory;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.DefaultGeoProperty;
import org.openstreetmap.josm.tools.GeoPropertyIndex;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Territories;
import org.openstreetmap.josm.tools.UserCancelException;

public final class RightAndLefthandTraffic {
    private static final String DRIVING_SIDE = "driving_side";
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static volatile GeoPropertyIndex<Boolean> rlCache;

    private RightAndLefthandTraffic() {
    }

    public static synchronized boolean isRightHandTraffic(LatLon ll) {
        Boolean value = rlCache.get(ll);
        return value == null || value == false;
    }

    public static synchronized void initialize() {
        Collection<Way> optimizedWays = RightAndLefthandTraffic.loadOptimizedBoundaries();
        if (optimizedWays.isEmpty()) {
            optimizedWays = RightAndLefthandTraffic.computeOptimizedBoundaries();
            try {
                RightAndLefthandTraffic.saveOptimizedBoundaries(optimizedWays);
            }
            catch (IOException | SecurityException e) {
                Logging.log(Logging.LEVEL_ERROR, "Unable to save optimized boundaries", e);
            }
        }
        rlCache = new GeoPropertyIndex<Boolean>(new DefaultGeoProperty(optimizedWays), 24);
    }

    private static Collection<Way> computeOptimizedBoundaries() {
        ArrayList<Way> ways = new ArrayList<Way>();
        ArrayList<OsmPrimitive> toPurge = new ArrayList<OsmPrimitive>();
        DataSet data = Territories.getDataSet();
        Collection<Relation> allRelations = data.getRelations();
        Collection<Way> allWays = data.getWays();
        for (Way w : allWays) {
            if (!LEFT.equals(w.get(DRIVING_SIDE))) continue;
            RightAndLefthandTraffic.addWayIfNotInner(ways, w);
        }
        for (Relation r : allRelations) {
            if (!r.isMultipolygon() || !LEFT.equals(r.get(DRIVING_SIDE))) continue;
            for (RelationMember rm : r.getMembers()) {
                if (!rm.isWay() || !"outer".equals(rm.getRole()) || RIGHT.equals(rm.getMember().get(DRIVING_SIDE))) continue;
                RightAndLefthandTraffic.addWayIfNotInner(ways, (Way)rm.getMember());
            }
        }
        toPurge.addAll(allRelations);
        toPurge.addAll(allWays);
        toPurge.removeAll(ways);
        for (Relation r : OsmPrimitive.getParentRelations(ways)) {
            r.setMembers((List<RelationMember>)null);
        }
        for (Way w : ways) {
            w.removeAll();
        }
        PurgeCommand.build(toPurge, null).executeCommand();
        ArrayList<Way> optimizedWays = new ArrayList<Way>();
        List<JoinAreasAction.Multipolygon> areas = JoinAreasAction.collectMultipolygons(ways);
        if (areas != null) {
            try {
                JoinAreasAction.JoinAreasResult result = new JoinAreasAction(false).joinAreas(areas);
                if (result.hasChanges()) {
                    for (JoinAreasAction.Multipolygon mp : result.getPolygons()) {
                        optimizedWays.add(mp.getOuterWay());
                    }
                }
            }
            catch (UserCancelException ex) {
                Logging.warn(ex);
            }
            catch (JosmRuntimeException ex) {
                Logging.error(ex);
            }
        }
        if (optimizedWays.isEmpty()) {
            Logging.warn("Unable to join left-driving countries polygons");
            optimizedWays.addAll(ways);
        }
        return optimizedWays;
    }

    private static void addWayIfNotInner(Collection<Way> ways, Way w) {
        Set<Way> s = Collections.singleton(w);
        for (Relation r : OsmPrimitive.getParentRelations(s)) {
            if (!r.isMultipolygon() || !LEFT.equals(r.get(DRIVING_SIDE)) || !"inner".equals(r.getMembersFor(s).iterator().next().getRole())) continue;
            if (Logging.isDebugEnabled()) {
                Logging.debug("Skipping {0} because inner part of {1}", w.get("name:en"), r.get("name:en"));
            }
            return;
        }
        ways.add(w);
    }

    private static void saveOptimizedBoundaries(Collection<Way> optimizedWays) throws IOException {
        DataSet ds = optimizedWays.iterator().next().getDataSet();
        File file = new File(Config.getDirs().getCacheDirectory(true), "left-right-hand-traffic.osm");
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
             OsmWriter w = OsmWriterFactory.createOsmWriter(new PrintWriter(writer), false, ds.getVersion());){
            w.header(DownloadPolicy.NORMAL, UploadPolicy.DISCOURAGED);
            w.writeContent(ds);
            w.footer();
        }
    }

    private static Collection<Way> loadOptimizedBoundaries() {
        Collection<Way> collection;
        block8: {
            InputStream is = Files.newInputStream(Paths.get(Config.getDirs().getCacheDirectory(false).getPath(), "left-right-hand-traffic.osm"), new OpenOption[0]);
            Throwable throwable = null;
            try {
                collection = OsmReader.parseDataSet(is, null).getWays();
                if (is == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (is != null) {
                            RightAndLefthandTraffic.$closeResource(throwable, is);
                        }
                        throw throwable3;
                    }
                }
                catch (IOException | SecurityException | InvalidPathException | IllegalDataException ex) {
                    Logging.trace(ex);
                    return Collections.emptyList();
                }
            }
            RightAndLefthandTraffic.$closeResource(throwable, is);
        }
        return collection;
    }
}

