/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.base.Joiner;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainModuleSource;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.AttributeDesugaring;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyGraphBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.VariantNameBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.VersionConflictResolutionDetails;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.ResolvableSelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.DefaultComponentOverrideMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.RejectedByAttributesVersion;
import org.gradle.internal.resolve.RejectedByRuleVersion;
import org.gradle.internal.resolve.RejectedBySelectorVersion;
import org.gradle.internal.resolve.RejectedVersion;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.result.DefaultBuildableComponentResolveResult;
import org.gradle.internal.text.TreeFormatter;

public class ComponentState
implements ComponentResolutionState,
DependencyGraphComponent {
    private static final DisplayName UNKNOWN_VARIANT = Describables.of((Object)"unknown");
    private final ComponentIdentifier componentIdentifier;
    private final ModuleVersionIdentifier id;
    private final ComponentMetaDataResolver resolver;
    private final VariantNameBuilder variantNameBuilder;
    private final List<NodeState> nodes = Lists.newLinkedList();
    private final Long resultId;
    private final ModuleResolveState module;
    private final List<ComponentSelectionDescriptorInternal> selectionCauses = Lists.newArrayList();
    private final ImmutableCapability implicitCapability;
    private Multimap<VersionSelector, String> rejectedBySelectors;
    private volatile ComponentResolveMetadata metadata;
    private ComponentSelectionState state = ComponentSelectionState.Selectable;
    private ModuleVersionResolveException metadataResolveFailure;
    private SelectorState firstSelectedBy;
    private DependencyGraphBuilder.VisitState visitState = DependencyGraphBuilder.VisitState.NotSeen;
    private boolean rejected;
    private boolean root;

    ComponentState(Long resultId, ModuleResolveState module, ModuleVersionIdentifier id, ComponentIdentifier componentIdentifier, ComponentMetaDataResolver resolver, VariantNameBuilder variantNameBuilder) {
        this.resultId = resultId;
        this.module = module;
        this.id = id;
        this.componentIdentifier = componentIdentifier;
        this.resolver = resolver;
        this.variantNameBuilder = variantNameBuilder;
        this.implicitCapability = new ImmutableCapability(id.getGroup(), id.getName(), id.getVersion());
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public String getVersion() {
        return this.id.getVersion();
    }

    @Override
    public Long getResultId() {
        return this.resultId;
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.id;
    }

    @Override
    public String getRepositoryName() {
        ModuleSource moduleSource = this.metadata.getSource();
        if (moduleSource instanceof RepositoryChainModuleSource) {
            return ((RepositoryChainModuleSource)moduleSource).getRepositoryName();
        }
        return null;
    }

    @Override
    public ModuleVersionIdentifier getModuleVersion() {
        return this.id;
    }

    public ModuleVersionResolveException getMetadataResolveFailure() {
        return this.metadataResolveFailure;
    }

    public DependencyGraphBuilder.VisitState getVisitState() {
        return this.visitState;
    }

    public void setVisitState(DependencyGraphBuilder.VisitState visitState) {
        this.visitState = visitState;
    }

    public List<NodeState> getNodes() {
        return this.nodes;
    }

    public ModuleResolveState getModule() {
        return this.module;
    }

    @Override
    public ComponentResolveMetadata getMetadata() {
        this.resolve();
        return this.metadata;
    }

    ComponentResolveMetadata getMetadataWithoutRetryMissing() {
        this.resolve(false);
        return this.metadata;
    }

    @Override
    public ComponentIdentifier getComponentId() {
        if (this.metadata != null) {
            return this.metadata.getId();
        }
        return this.componentIdentifier;
    }

    public void restartIncomingEdges(ComponentState selected) {
        for (NodeState configuration : this.nodes) {
            configuration.restart(selected);
        }
    }

    @Override
    public void selectedBy(ResolvableSelectorState selectorState) {
        if (this.firstSelectedBy == null) {
            this.firstSelectedBy = (SelectorState)selectorState;
        }
    }

    public boolean alreadyResolved() {
        return this.metadata != null || this.metadataResolveFailure != null;
    }

    public void resolve() {
        this.resolve(true);
    }

    public void resolve(boolean retryMissing) {
        if (this.alreadyResolved()) {
            return;
        }
        ComponentOverrideMetadata componentOverrideMetadata = DefaultComponentOverrideMetadata.forDependency(this.firstSelectedBy.getDependencyMetadata());
        DefaultBuildableComponentResolveResult result = new DefaultBuildableComponentResolveResult(retryMissing);
        this.resolver.resolve(this.componentIdentifier, componentOverrideMetadata, result);
        if (result.getFailure() != null) {
            this.metadataResolveFailure = result.getFailure();
            return;
        }
        this.metadata = result.getMetadata();
    }

    public void setMetadata(ComponentResolveMetadata metaData) {
        this.metadata = metaData;
        this.metadataResolveFailure = null;
    }

    public void addConfiguration(NodeState node) {
        this.nodes.add(node);
    }

    @Override
    public ComponentSelectionReasonInternal getSelectionReason() {
        if (this.root) {
            return VersionSelectionReasons.root();
        }
        ComponentSelectionReasonInternal reason = VersionSelectionReasons.empty();
        for (SelectorState selectorState : this.module.getSelectors()) {
            if (selectorState.getFailure() != null) continue;
            selectorState.addReasonsForSelector(reason, new RejectedBySelectorDescriptorBuilder(selectorState));
        }
        for (ComponentSelectionDescriptorInternal selectionCause : VersionConflictResolutionDetails.mergeCauses(this.selectionCauses)) {
            reason.addCause(selectionCause);
        }
        return reason;
    }

    @Override
    public void addCause(ComponentSelectionDescriptorInternal reason) {
        this.selectionCauses.add(reason);
    }

    public void setRoot() {
        this.root = true;
    }

    @Override
    public DisplayName getVariantName() {
        DisplayName name = null;
        ArrayList names = null;
        for (NodeState node : this.nodes) {
            if (!node.isSelected()) continue;
            if (names == null) {
                names = Lists.newArrayListWithCapacity((int)this.nodes.size());
            }
            names.add(node.getMetadata().getName());
        }
        name = this.variantNameBuilder.getVariantName(names);
        return name == null ? UNKNOWN_VARIANT : name;
    }

    @Override
    public AttributeContainer getVariantAttributes() {
        NodeState selected = this.getSelectedNode();
        return selected == null ? ImmutableAttributes.EMPTY : AttributeDesugaring.desugar(selected.getMetadata().getAttributes(), selected.getAttributesFactory());
    }

    private NodeState getSelectedNode() {
        for (NodeState node : this.nodes) {
            if (!node.isSelected()) continue;
            return node;
        }
        return null;
    }

    public List<ComponentState> getDependents() {
        ArrayList incoming = Lists.newArrayListWithCapacity((int)this.nodes.size());
        for (NodeState configuration : this.nodes) {
            for (EdgeState dependencyEdge : configuration.getIncomingEdges()) {
                incoming.add(dependencyEdge.getFrom().getComponent());
            }
        }
        return incoming;
    }

    @Override
    public Collection<? extends ModuleVersionIdentifier> getAllVersions() {
        Collection<ComponentState> moduleVersions = this.module.getAllVersions();
        ArrayList out = Lists.newArrayListWithCapacity((int)moduleVersions.size());
        for (ComponentState moduleVersion : moduleVersions) {
            out.add(moduleVersion.id);
        }
        return out;
    }

    public boolean isSelected() {
        return this.state == ComponentSelectionState.Selected;
    }

    public boolean isCandidateForConflictResolution() {
        return this.state.isCandidateForConflictResolution();
    }

    void evict() {
        this.state = ComponentSelectionState.Evicted;
    }

    void select() {
        this.state = ComponentSelectionState.Selected;
    }

    void makeSelectable() {
        this.state = ComponentSelectionState.Selectable;
    }

    @Override
    public void reject() {
        this.rejected = true;
    }

    @Override
    public boolean isRejected() {
        return this.rejected;
    }

    @Override
    public void unmatched(Collection<RejectedBySelectorVersion> unmatchedVersions) {
        for (RejectedBySelectorVersion unmatchedVersion : unmatchedVersions) {
            this.registerRejections(unmatchedVersion, unmatchedVersion.getId().getVersion());
        }
    }

    @Override
    public void rejected(Collection<RejectedVersion> rejectedVersions) {
        for (RejectedVersion rejectedVersion : rejectedVersions) {
            String version = rejectedVersion.getId().getVersion();
            if (rejectedVersion instanceof RejectedBySelectorVersion) {
                this.registerRejections((RejectedBySelectorVersion)rejectedVersion, version);
                continue;
            }
            if (rejectedVersion instanceof RejectedByRuleVersion) {
                String reason = ((RejectedByRuleVersion)rejectedVersion).getReason();
                this.addCause(VersionSelectionReasons.REJECTION.withReason(new RejectedByRuleReason(version, reason)));
                continue;
            }
            if (!(rejectedVersion instanceof RejectedByAttributesVersion)) continue;
            this.addCause(VersionSelectionReasons.REJECTION.withReason(new RejectedByAttributesReason((RejectedByAttributesVersion)rejectedVersion)));
        }
    }

    private void registerRejections(RejectedBySelectorVersion rejectedVersion, String version) {
        if (this.rejectedBySelectors == null) {
            this.rejectedBySelectors = LinkedHashMultimap.create();
        }
        this.rejectedBySelectors.put((Object)rejectedVersion.getRejectionSelector(), (Object)version);
    }

    public void removeOutgoingEdges() {
        for (NodeState configuration : this.getNodes()) {
            configuration.deselect();
        }
    }

    public void forEachCapability(Action<? super Capability> action) {
        for (NodeState target : this.nodes) {
            List capabilities = target.getMetadata().getCapabilities().getCapabilities();
            if (capabilities.isEmpty()) continue;
            for (Capability capability : capabilities) {
                action.execute((Object)capability);
            }
        }
    }

    public Capability findCapability(String group, String name) {
        if (this.id.getGroup().equals(group) && this.id.getName().equals(name)) {
            return this.implicitCapability;
        }
        return this.findCapabilityOnTarget(group, name);
    }

    private Capability findCapabilityOnTarget(String group, String name) {
        for (NodeState target : this.nodes) {
            List capabilities = target.getMetadata().getCapabilities().getCapabilities();
            if (capabilities.isEmpty()) continue;
            for (Capability capability : capabilities) {
                if (!capability.getGroup().equals(group) || !capability.getName().equals(name)) continue;
                return capability;
            }
        }
        return null;
    }

    private static class UnmatchedVersionsReason
    implements Describable {
        private final Collection<String> rejectedVersions;
        private final ComponentSelectionDescriptorInternal descriptor;

        private UnmatchedVersionsReason(Collection<String> rejectedVersions, ComponentSelectionDescriptorInternal descriptor) {
            this.rejectedVersions = rejectedVersions;
            this.descriptor = descriptor;
        }

        public String getDisplayName() {
            boolean hasCustomDescription = this.descriptor.hasCustomDescription();
            StringBuilder sb = new StringBuilder(this.estimateSize(hasCustomDescription));
            sb.append(this.rejectedVersions.size() > 1 ? "didn't match versions " : "didn't match version ");
            Joiner.on((String)", ").appendTo(sb, this.rejectedVersions);
            if (hasCustomDescription) {
                sb.append(" because ").append(this.descriptor.getDescription());
            }
            return sb.toString();
        }

        private int estimateSize(boolean hasCustomDescription) {
            return 24 + this.rejectedVersions.size() * 8 + (hasCustomDescription ? 24 : 0);
        }
    }

    private static class RejectedBySelectorReason
    implements Describable {
        private final Collection<String> rejectedVersions;
        private final ComponentSelectionDescriptorInternal descriptor;

        private RejectedBySelectorReason(Collection<String> rejectedVersions, ComponentSelectionDescriptorInternal descriptor) {
            this.rejectedVersions = rejectedVersions;
            this.descriptor = descriptor;
        }

        public String getDisplayName() {
            boolean hasCustomDescription = this.descriptor.hasCustomDescription();
            StringBuilder sb = new StringBuilder(this.estimateSize(hasCustomDescription));
            sb.append(this.rejectedVersions.size() > 1 ? "rejected versions " : "rejected version ");
            Joiner.on((String)", ").appendTo(sb, this.rejectedVersions);
            if (hasCustomDescription) {
                sb.append(" because ").append(this.descriptor.getDescription());
            }
            return sb.toString();
        }

        private int estimateSize(boolean hasCustomDescription) {
            return 20 + this.rejectedVersions.size() * 8 + (hasCustomDescription ? 24 : 0);
        }
    }

    private static class RejectedByAttributesReason
    implements Describable {
        private final RejectedByAttributesVersion version;

        private RejectedByAttributesReason(RejectedByAttributesVersion version) {
            this.version = version;
        }

        public String getDisplayName() {
            TreeFormatter formatter = new TreeFormatter();
            this.version.describeTo(formatter);
            return "version " + formatter;
        }
    }

    private static class RejectedByRuleReason
    implements Describable {
        private final String version;
        private final String reason;

        private RejectedByRuleReason(String version, String reason) {
            this.version = version;
            this.reason = reason;
        }

        public String getDisplayName() {
            return this.version + " by rule" + (this.reason != null ? " because " + this.reason : "");
        }
    }

    private class RejectedBySelectorDescriptorBuilder
    implements Transformer<ComponentSelectionDescriptorInternal, ComponentSelectionDescriptorInternal> {
        private final SelectorState selectorState;

        public RejectedBySelectorDescriptorBuilder(SelectorState selectorState) {
            this.selectorState = selectorState;
        }

        public ComponentSelectionDescriptorInternal transform(ComponentSelectionDescriptorInternal descriptor) {
            if (ComponentState.this.rejectedBySelectors != null) {
                Collection rejectedByThisSelector = ComponentState.this.rejectedBySelectors.get((Object)this.selectorState.getVersionConstraint().getRejectedSelector());
                if (!rejectedByThisSelector.isEmpty()) {
                    descriptor = descriptor.withReason(new RejectedBySelectorReason(rejectedByThisSelector, descriptor));
                } else {
                    rejectedByThisSelector = ComponentState.this.rejectedBySelectors.get((Object)this.selectorState.getVersionConstraint().getPreferredSelector());
                    if (!rejectedByThisSelector.isEmpty()) {
                        descriptor = descriptor.withReason(new UnmatchedVersionsReason(rejectedByThisSelector, descriptor));
                    }
                }
            }
            return descriptor;
        }
    }

    static enum ComponentSelectionState {
        Selectable(true),
        Selected(true),
        Evicted(false);

        private final boolean candidateForConflictResolution;

        private ComponentSelectionState(boolean candidateForConflictResolution) {
            this.candidateForConflictResolution = candidateForConflictResolution;
        }

        boolean isCandidateForConflictResolution() {
            return this.candidateForConflictResolution;
        }
    }
}

