/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.typeregistration;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.internal.Cast;
import org.gradle.internal.MutableReference;
import org.gradle.internal.reflect.Types;
import org.gradle.model.Managed;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.typeregistration.InstanceFactory;

public class BaseInstanceFactory<PUBLIC>
implements InstanceFactory<PUBLIC> {
    private final ModelType<PUBLIC> baseInterface;
    private final Map<ModelType<? extends PUBLIC>, TypeRegistration<? extends PUBLIC>> registrations = Maps.newLinkedHashMap();
    private final Map<Class<?>, ImplementationFactory<? extends PUBLIC, ?>> factories = Maps.newLinkedHashMap();

    public BaseInstanceFactory(Class<PUBLIC> baseInterface) {
        this.baseInterface = ModelType.of(baseInterface);
    }

    @Override
    public ModelType<PUBLIC> getBaseInterface() {
        return this.baseInterface;
    }

    public <S extends PUBLIC> void register(ModelType<S> publicType, Set<Class<?>> internalViews, @Nullable ModelType<?> implementationType, ModelRuleDescriptor definedBy) {
        TypeRegistrationBuilder<S> registration = this.register(publicType, definedBy);
        if (implementationType != null) {
            registration.withImplementation(implementationType);
        }
        for (Class<?> internalView : internalViews) {
            registration.withInternalView(ModelType.of(internalView));
        }
    }

    public <S extends PUBLIC, I> void registerFactory(Class<I> implementationType, ImplementationFactory<S, I> implementationFactory) {
        this.factories.put(implementationType, implementationFactory);
    }

    public <S extends PUBLIC> TypeRegistrationBuilder<S> register(ModelType<S> publicType, ModelRuleDescriptor source) {
        TypeRegistration<S> registration = (TypeRegistration<S>)Cast.uncheckedCast(this.registrations.get(publicType));
        if (registration == null) {
            registration = new TypeRegistration<S>(publicType);
            this.registrations.put(publicType, registration);
        }
        return new TypeRegistrationBuilderImpl<S>(source, registration);
    }

    @Override
    @Nullable
    public <S extends PUBLIC> InstanceFactory.ImplementationInfo getImplementationInfo(ModelType<S> publicType) {
        ImplementationRegistration<S> implementationRegistration = this.getImplementationRegistration(publicType);
        if (implementationRegistration == null) {
            return null;
        }
        return new ImplementationInfoImpl<S>(publicType, implementationRegistration, this.getInternalViews(publicType));
    }

    @Override
    public <S extends PUBLIC> InstanceFactory.ImplementationInfo getManagedSubtypeImplementationInfo(final ModelType<S> publicType) {
        if (!BaseInstanceFactory.isManaged(publicType)) {
            throw new IllegalArgumentException(String.format("Type '%s' is not managed", publicType));
        }
        final MutableReference implementationInfo = MutableReference.empty();
        Types.walkTypeHierarchy(publicType.getConcreteClass(), (Types.TypeVisitor)new RegistrationHierarchyVisitor<S>(){

            @Override
            protected void visitRegistration(TypeRegistration<? extends PUBLIC> registration) {
                if (registration == null || registration.implementationRegistration == null) {
                    return;
                }
                ImplementationInfoImpl currentImplementationInfo = (ImplementationInfoImpl)implementationInfo.get();
                if (currentImplementationInfo == null || currentImplementationInfo.implementationRegistration.implementationType.isAssignableFrom(registration.implementationRegistration.implementationType)) {
                    implementationInfo.set(new ImplementationInfoImpl(publicType, registration.implementationRegistration, BaseInstanceFactory.this.getInternalViews(publicType)));
                }
            }
        });
        if (implementationInfo.get() == null) {
            throw new IllegalStateException(String.format("Factory registration for '%s' is invalid because it doesn't extend an interface with a default implementation", publicType));
        }
        return (InstanceFactory.ImplementationInfo)implementationInfo.get();
    }

    private <S extends PUBLIC> Set<ModelType<?>> getInternalViews(ModelType<S> publicType) {
        final ImmutableSet.Builder builder = ImmutableSet.builder();
        Types.walkTypeHierarchy(publicType.getConcreteClass(), (Types.TypeVisitor)new RegistrationHierarchyVisitor<S>(){

            @Override
            protected void visitRegistration(TypeRegistration<? extends PUBLIC> registration) {
                for (InternalViewRegistration internalViewRegistration : registration.internalViewRegistrations) {
                    builder.add(internalViewRegistration.getInternalView());
                }
            }
        });
        return builder.build();
    }

    /*
     * Exception decompiling
     */
    @Override
    public Set<ModelType<? extends PUBLIC>> getSupportedTypes() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <S extends PUBLIC> TypeRegistration<S> getRegistration(ModelType<S> type) {
        return (TypeRegistration)Cast.uncheckedCast(this.registrations.get(type));
    }

    private <S extends PUBLIC> ImplementationRegistration<S> getImplementationRegistration(ModelType<S> type) {
        TypeRegistration<S> registration = this.getRegistration(type);
        if (registration == null) {
            return null;
        }
        if (((TypeRegistration)registration).implementationRegistration == null) {
            throw new IllegalArgumentException(String.format("Cannot create a '%s' because this type does not have an implementation registered.", type));
        }
        return ((TypeRegistration)registration).implementationRegistration;
    }

    public void validateRegistrations() {
        for (TypeRegistration<PUBLIC> registration : this.registrations.values()) {
            registration.validate();
        }
    }

    private static boolean isManaged(ModelType<?> type) {
        return type.isAnnotationPresent(Managed.class);
    }

    @Nullable
    private <S extends PUBLIC> ImplementationFactory<S, ?> findFactory(Class<?> implementationClass) {
        ImplementationFactory<Object, ?> implementationFactory = this.factories.get(implementationClass);
        if (implementationFactory != null) {
            return (ImplementationFactory)Cast.uncheckedCast(implementationFactory);
        }
        Class<?> superclass = implementationClass.getSuperclass();
        if (superclass != null && superclass != Object.class) {
            implementationFactory = this.findFactory(superclass);
            this.factories.put(implementationClass, implementationFactory);
            return (ImplementationFactory)Cast.uncheckedCast(implementationFactory);
        }
        return null;
    }

    private abstract class RegistrationHierarchyVisitor<S>
    implements Types.TypeVisitor<S> {
        private RegistrationHierarchyVisitor() {
        }

        public void visitType(Class<? super S> type) {
            if (!BaseInstanceFactory.this.baseInterface.getConcreteClass().isAssignableFrom(type)) {
                return;
            }
            Class superTypeClassAsBaseType = type.asSubclass(BaseInstanceFactory.this.baseInterface.getConcreteClass());
            ModelType superTypeAsBaseType = ModelType.of(superTypeClassAsBaseType);
            TypeRegistration registration = BaseInstanceFactory.this.getRegistration(superTypeAsBaseType);
            if (registration != null) {
                this.visitRegistration(registration);
            }
        }

        protected abstract void visitRegistration(TypeRegistration<? extends PUBLIC> var1);
    }

    private static class ImplementationInfoImpl<PUBLIC>
    implements InstanceFactory.ImplementationInfo {
        private final ModelType<PUBLIC> publicType;
        private final ImplementationRegistration<? super PUBLIC> implementationRegistration;
        private final Set<ModelType<?>> internalViews;

        public ImplementationInfoImpl(ModelType<PUBLIC> publicType, ImplementationRegistration<?> implementationRegistration, Set<ModelType<?>> internalViews) {
            this.publicType = publicType;
            this.internalViews = internalViews;
            this.implementationRegistration = (ImplementationRegistration)Cast.uncheckedCast(implementationRegistration);
        }

        @Override
        public Object create(MutableModelNode modelNode) {
            ImplementationFactory implementationFactory = (ImplementationFactory)Cast.uncheckedCast((Object)((ImplementationRegistration)this.implementationRegistration).factory);
            return implementationFactory.create(this.publicType, ((ImplementationRegistration)this.implementationRegistration).implementationType, modelNode.getPath().getName(), modelNode);
        }

        @Override
        public ModelType<?> getDelegateType() {
            return ((ImplementationRegistration)this.implementationRegistration).implementationType;
        }

        @Override
        public Set<ModelType<?>> getInternalViews() {
            return this.internalViews;
        }

        public String toString() {
            return String.valueOf(this.publicType);
        }
    }

    private static class InternalViewRegistration<T> {
        private final ModelRuleDescriptor source;
        private final ModelType<T> internalView;

        private InternalViewRegistration(ModelRuleDescriptor source, ModelType<T> internalView) {
            this.source = source;
            this.internalView = internalView;
        }

        public ModelRuleDescriptor getSource() {
            return this.source;
        }

        public ModelType<T> getInternalView() {
            return this.internalView;
        }
    }

    private static class ImplementationRegistration<PUBLIC> {
        private final ModelRuleDescriptor source;
        private final ModelType<?> implementationType;
        private final ImplementationFactory<? super PUBLIC, ?> factory;

        private ImplementationRegistration(ModelRuleDescriptor source, ModelType<?> implementationType, ImplementationFactory<? super PUBLIC, ?> factory) {
            this.source = source;
            this.implementationType = implementationType;
            this.factory = factory;
        }

        public ModelRuleDescriptor getSource() {
            return this.source;
        }

        public ModelType<?> getImplementationType() {
            return this.implementationType;
        }

        public ImplementationFactory<? super PUBLIC, ?> getFactory() {
            return this.factory;
        }
    }

    private class TypeRegistration<S extends PUBLIC> {
        private final ModelType<S> publicType;
        private final boolean managedPublicType;
        private ImplementationRegistration<S> implementationRegistration;
        private final List<InternalViewRegistration<?>> internalViewRegistrations = Lists.newArrayList();

        public TypeRegistration(ModelType<S> publicType) {
            this.publicType = publicType;
            this.managedPublicType = BaseInstanceFactory.isManaged(publicType);
        }

        public void setImplementation(ModelType<?> implementationType, ModelRuleDescriptor source) {
            if (this.implementationRegistration != null) {
                throw new IllegalStateException(String.format("Cannot register implementation for type '%s' because an implementation for this type was already registered by %s", this.publicType, this.implementationRegistration.getSource()));
            }
            if (this.managedPublicType) {
                throw new IllegalArgumentException(String.format("Cannot specify default implementation for managed type '%s'", this.publicType));
            }
            if (Modifier.isAbstract(implementationType.getConcreteClass().getModifiers())) {
                throw new IllegalArgumentException(String.format("Implementation type '%s' registered for '%s' must not be abstract", implementationType, this.publicType));
            }
            try {
                implementationType.getConcreteClass().getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(String.format("Implementation type '%s' registered for '%s' must have a public default constructor", implementationType, this.publicType));
            }
            Class<?> implementationClass = implementationType.getConcreteClass();
            ImplementationFactory factory = BaseInstanceFactory.this.findFactory(implementationClass);
            if (factory == null) {
                throw new IllegalArgumentException(String.format("No factory registered to create an instance of implementation class '%s'.", implementationType));
            }
            this.implementationRegistration = new ImplementationRegistration(source, implementationType, factory);
        }

        public <V> void addInternalView(ModelType<V> internalView, ModelRuleDescriptor source) {
            if (!internalView.getConcreteClass().isInterface()) {
                throw new IllegalArgumentException(String.format("Internal view '%s' registered for '%s' must be an interface", internalView, this.publicType));
            }
            if (this.managedPublicType && !BaseInstanceFactory.isManaged(internalView)) {
                throw new IllegalArgumentException(String.format("Internal view '%s' registered for managed type '%s' must be managed", internalView, this.publicType));
            }
            this.internalViewRegistrations.add(new InternalViewRegistration(source, internalView));
        }

        public void validate() {
            if (this.managedPublicType) {
                this.validateManaged();
            } else {
                this.validateUnmanaged();
            }
        }

        public boolean isConstructible() {
            return this.managedPublicType || this.implementationRegistration != null;
        }

        private void validateManaged() {
            InstanceFactory.ImplementationInfo implementationInfo = BaseInstanceFactory.this.getManagedSubtypeImplementationInfo(this.publicType);
            ModelType<?> delegateType = implementationInfo.getDelegateType();
            for (InternalViewRegistration<?> internalViewRegistration : this.internalViewRegistrations) {
                this.validateManagedInternalView(internalViewRegistration, delegateType);
            }
        }

        private <V> void validateManagedInternalView(final InternalViewRegistration<V> internalViewRegistration, final ModelType<?> delegateType) {
            Types.walkTypeHierarchy(internalViewRegistration.getInternalView().getConcreteClass(), (Types.TypeVisitor)new Types.TypeVisitor<V>(){

                public void visitType(Class<? super V> type) {
                    if (!type.isAnnotationPresent(Managed.class) && !type.isAssignableFrom(delegateType.getConcreteClass())) {
                        throw new IllegalStateException(String.format("Factory registration for '%s' is invalid because the default implementation type '%s' does not implement unmanaged internal view '%s', internal view was registered by %s", TypeRegistration.this.publicType, delegateType, ModelType.of(type), internalViewRegistration.getSource()));
                    }
                }
            });
        }

        private void validateUnmanaged() {
            if (this.implementationRegistration == null) {
                return;
            }
            ModelType<?> implementationType = this.implementationRegistration.getImplementationType();
            for (InternalViewRegistration<?> internalViewRegistration : this.internalViewRegistrations) {
                ModelType<?> internalView = internalViewRegistration.getInternalView();
                if (BaseInstanceFactory.isManaged(internalView) || internalView.isAssignableFrom(implementationType)) continue;
                throw new IllegalStateException(String.format("Factory registration for '%s' is invalid because the implementation type '%s' does not implement internal view '%s', implementation type was registered by %s, internal view was registered by %s", this.publicType, implementationType, internalView, this.implementationRegistration.getSource(), internalViewRegistration.getSource()));
            }
        }
    }

    private class TypeRegistrationBuilderImpl<S extends PUBLIC>
    implements TypeRegistrationBuilder<S> {
        private final ModelRuleDescriptor source;
        private final TypeRegistration<S> registration;

        public TypeRegistrationBuilderImpl(ModelRuleDescriptor source, TypeRegistration<S> registration) {
            this.source = source;
            this.registration = registration;
        }

        @Override
        public TypeRegistrationBuilder<S> withImplementation(ModelType<?> implementationType) {
            this.registration.setImplementation(implementationType, this.source);
            return this;
        }

        @Override
        public TypeRegistrationBuilder<S> withInternalView(ModelType<?> internalView) {
            this.registration.addInternalView(internalView, this.source);
            return this;
        }
    }

    public static interface TypeRegistrationBuilder<T> {
        public TypeRegistrationBuilder<T> withImplementation(ModelType<?> var1);

        public TypeRegistrationBuilder<T> withInternalView(ModelType<?> var1);
    }

    public static interface ImplementationFactory<PUBLIC, BASEIMPL> {
        public <T extends BASEIMPL> T create(ModelType<? extends PUBLIC> var1, ModelType<T> var2, String var3, MutableModelNode var4);
    }
}

