/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.exec;

import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.launcher.daemon.server.api.DaemonCommandAction;
import org.gradle.launcher.daemon.server.api.DaemonCommandExecution;

public class WatchForDisconnection
implements DaemonCommandAction {
    private static final Logger LOGGER = Logging.getLogger(WatchForDisconnection.class);
    public static final String EXPIRATION_REASON = "client disconnected";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final DaemonCommandExecution execution) {
        execution.getConnection().onDisconnect(new Runnable(){

            @Override
            public void run() {
                LOGGER.warn("thread {}: client disconnection detected, canceling the build", (Object)Thread.currentThread().getId());
                execution.getDaemonStateControl().requestCancel();
            }
        });
        try {
            execution.proceed();
        }
        finally {
            execution.getConnection().onDisconnect(null);
        }
    }
}

