/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.File;
import java.util.List;
import net.rubygrapefruit.platform.DirEntry;
import net.rubygrapefruit.platform.FileInfo;
import net.rubygrapefruit.platform.FilePermissionException;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.PosixFileInfo;
import net.rubygrapefruit.platform.PosixFiles;
import net.rubygrapefruit.platform.internal.AbstractFiles;
import net.rubygrapefruit.platform.internal.DirList;
import net.rubygrapefruit.platform.internal.FileStat;
import net.rubygrapefruit.platform.internal.FunctionResult;
import net.rubygrapefruit.platform.internal.jni.PosixFileFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPosixFiles
extends AbstractFiles
implements PosixFiles {
    @Override
    public PosixFileInfo stat(File file2) throws NativeException {
        return this.stat(file2, false);
    }

    @Override
    public PosixFileInfo stat(File file2, boolean linkTarget) throws NativeException {
        FunctionResult result2 = new FunctionResult();
        FileStat stat = new FileStat(file2.getPath());
        PosixFileFunctions.stat(file2.getPath(), linkTarget, stat, result2);
        if (result2.isFailed()) {
            if (result2.getFailure() == FunctionResult.Failure.Permissions) {
                throw new FilePermissionException(String.format("Could not get file details of %s: permission denied", file2));
            }
            throw new NativeException(String.format("Could not get file details of %s: %s", file2, result2.getMessage()));
        }
        return stat;
    }

    public List<DirEntry> listDir(File dir) throws NativeException {
        return this.listDir(dir, false);
    }

    public List<DirEntry> listDir(File dir, boolean linkTarget) throws NativeException {
        FunctionResult result2 = new FunctionResult();
        DirList dirList = new DirList();
        PosixFileFunctions.readdir(dir.getPath(), linkTarget, dirList, result2);
        if (result2.isFailed()) {
            throw this.listDirFailure(dir, result2);
        }
        return dirList.files;
    }

    @Override
    public void setMode(File file2, int perms) {
        FunctionResult result2 = new FunctionResult();
        PosixFileFunctions.chmod(file2.getPath(), perms, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not set UNIX mode on %s: %s", file2, result2.getMessage()));
        }
    }

    @Override
    public int getMode(File file2) {
        PosixFileInfo stat = this.stat(file2);
        if (stat.getType() == FileInfo.Type.Missing) {
            throw new NativeException(String.format("Could not get UNIX mode on %s: file does not exist.", file2));
        }
        return stat.getMode();
    }

    @Override
    public String readLink(File link) throws NativeException {
        FunctionResult result2 = new FunctionResult();
        String contents = PosixFileFunctions.readlink(link.getPath(), result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not read symlink %s: %s", link, result2.getMessage()));
        }
        return contents;
    }

    @Override
    public void symlink(File link, String contents) throws NativeException {
        FunctionResult result2 = new FunctionResult();
        PosixFileFunctions.symlink(link.getPath(), contents, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not create symlink %s: %s", link, result2.getMessage()));
        }
    }
}

