/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;

public class PsiLiteralUtil {
    @NonNls
    public static final String HEX_PREFIX = "0x";
    @NonNls
    public static final String BIN_PREFIX = "0b";
    @NonNls
    public static final String _2_IN_31 = Long.toString(Integer.MIN_VALUE).substring(1);
    @NonNls
    public static final String _2_IN_63 = Long.toString(Long.MIN_VALUE).substring(1);

    @Nullable
    public static Integer parseInteger(String text2) {
        try {
            if (text2.startsWith(HEX_PREFIX)) {
                long value = PsiLiteralUtil.parseDigits(text2.substring(2), 4, 32);
                return (int)value;
            }
            if (text2.startsWith(BIN_PREFIX)) {
                long value = PsiLiteralUtil.parseDigits(text2.substring(2), 1, 32);
                return (int)value;
            }
            if (StringUtil.startsWithChar(text2, '0')) {
                long value = PsiLiteralUtil.parseDigits(text2, 3, 32);
                return (int)value;
            }
            long l = Long.parseLong(text2, 10);
            if (text2.equals(_2_IN_31)) {
                return (int)l;
            }
            long converted = (int)l;
            return l == converted ? Integer.valueOf((int)l) : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Long parseLong(String text2) {
        if (StringUtil.endsWithChar(text2, 'L') || StringUtil.endsWithChar(text2, 'l')) {
            text2 = text2.substring(0, text2.length() - 1);
        }
        try {
            if (text2.startsWith(HEX_PREFIX)) {
                return PsiLiteralUtil.parseDigits(text2.substring(2), 4, 64);
            }
            if (text2.startsWith(BIN_PREFIX)) {
                return PsiLiteralUtil.parseDigits(text2.substring(2), 1, 64);
            }
            if (StringUtil.startsWithChar(text2, '0')) {
                return PsiLiteralUtil.parseDigits(text2, 3, 64);
            }
            if (_2_IN_63.equals(text2)) {
                return Long.MIN_VALUE;
            }
            return Long.valueOf(text2, 10);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Float parseFloat(String text2) {
        try {
            return Float.valueOf(text2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Double parseDouble(String text2) {
        try {
            return Double.valueOf(text2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static long parseDigits(String text2, int bitsInRadix, int maxBits) throws NumberFormatException {
        long integer;
        int radix = 1 << bitsInRadix;
        int textLength = text2.length();
        if (textLength == 0) {
            throw new NumberFormatException(text2);
        }
        long l = integer = textLength == 1 ? 0L : Long.parseLong(text2.substring(0, textLength - 1), radix);
        if ((integer & -1L << maxBits - bitsInRadix) != 0L) {
            throw new NumberFormatException(text2);
        }
        int lastDigit = Character.digit(text2.charAt(textLength - 1), radix);
        if (lastDigit == -1) {
            throw new NumberFormatException(text2);
        }
        integer <<= bitsInRadix;
        return integer |= (long)lastDigit;
    }
}

