/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.visitors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESExpressionVisitor;
import org.jetbrains.kotlin.contracts.model.MutableContextInfo;
import org.jetbrains.kotlin.contracts.model.structure.ESAnd;
import org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import org.jetbrains.kotlin.contracts.model.structure.ESEqual;
import org.jetbrains.kotlin.contracts.model.structure.ESIs;
import org.jetbrains.kotlin.contracts.model.structure.ESNot;
import org.jetbrains.kotlin.contracts.model.structure.ESOr;
import org.jetbrains.kotlin.contracts.model.structure.ESVariable;
import org.jetbrains.kotlin.contracts.model.structure.ValuesKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0014\u0010\n\u001a\u00020\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fJ!\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/contracts/model/visitors/InfoCollector;", "Lorg/jetbrains/kotlin/contracts/model/ESExpressionVisitor;", "Lorg/jetbrains/kotlin/contracts/model/MutableContextInfo;", "observedEffect", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "(Lorg/jetbrains/kotlin/contracts/model/ESEffect;)V", "isInverted", "", "collectFromEffect", "effect", "collectFromSchema", "schema", "", "inverted", "R", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "visitAnd", "and", "Lorg/jetbrains/kotlin/contracts/model/structure/ESAnd;", "visitConstant", "esConstant", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "visitEqual", "equal", "Lorg/jetbrains/kotlin/contracts/model/structure/ESEqual;", "visitIs", "isOperator", "Lorg/jetbrains/kotlin/contracts/model/structure/ESIs;", "visitNot", "not", "Lorg/jetbrains/kotlin/contracts/model/structure/ESNot;", "visitOr", "or", "Lorg/jetbrains/kotlin/contracts/model/structure/ESOr;", "visitVariable", "esVariable", "Lorg/jetbrains/kotlin/contracts/model/structure/ESVariable;", "resolution"})
public final class InfoCollector
implements ESExpressionVisitor<MutableContextInfo> {
    private boolean isInverted;
    private final ESEffect observedEffect;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MutableContextInfo collectFromSchema(@NotNull List<? extends ESEffect> schema) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
        Iterable iterable = $receiver$iv = (Iterable)schema;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            MutableContextInfo mutableContextInfo;
            Object element$iv$iv = element$iv$iv$iv;
            ESEffect it = (ESEffect)element$iv$iv;
            if (this.collectFromEffect(it) == null) continue;
            MutableContextInfo it$iv$iv = mutableContextInfo;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        MutableContextInfo initial$iv = MutableContextInfo.Companion.getEMPTY();
        MutableContextInfo accumulator$iv = initial$iv;
        for (Object element$iv : $receiver$iv) {
            void clauseInfo;
            Object element$iv$iv$iv;
            element$iv$iv$iv = (MutableContextInfo)element$iv;
            MutableContextInfo resultingInfo = accumulator$iv;
            accumulator$iv = resultingInfo.and((MutableContextInfo)clauseInfo);
        }
        return accumulator$iv;
    }

    private final MutableContextInfo collectFromEffect(ESEffect effect) {
        MutableContextInfo mutableContextInfo;
        if (!(effect instanceof ConditionalEffect)) {
            return MutableContextInfo.Companion.getEMPTY().fire(effect);
        }
        Boolean bl = this.observedEffect.isImplies(((ConditionalEffect)effect).getSimpleEffect());
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            mutableContextInfo = (MutableContextInfo)((ConditionalEffect)effect).getCondition().accept(this);
        } else if (bl == null || Intrinsics.areEqual((Object)bl, (Object)false)) {
            mutableContextInfo = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return mutableContextInfo;
    }

    @Override
    @NotNull
    public MutableContextInfo visitIs(@NotNull ESIs isOperator) {
        Intrinsics.checkParameterIsNotNull((Object)isOperator, (String)"isOperator");
        ESIs $receiver = isOperator;
        return $receiver.getFunctor().isNegated() != this.isInverted ? MutableContextInfo.Companion.getEMPTY().notSubtype($receiver.getLeft(), $receiver.getType()) : MutableContextInfo.Companion.getEMPTY().subtype($receiver.getLeft(), $receiver.getType());
    }

    @Override
    @NotNull
    public MutableContextInfo visitEqual(@NotNull ESEqual equal) {
        Intrinsics.checkParameterIsNotNull((Object)equal, (String)"equal");
        ESEqual $receiver = equal;
        return $receiver.getFunctor().isNegated() != this.isInverted ? MutableContextInfo.Companion.getEMPTY().notEqual($receiver.getLeft(), $receiver.getRight()) : MutableContextInfo.Companion.getEMPTY().equal($receiver.getLeft(), $receiver.getRight());
    }

    @Override
    @NotNull
    public MutableContextInfo visitAnd(@NotNull ESAnd and) {
        Intrinsics.checkParameterIsNotNull((Object)and, (String)"and");
        MutableContextInfo leftInfo = (MutableContextInfo)and.getLeft().accept(this);
        MutableContextInfo rightInfo = (MutableContextInfo)and.getRight().accept(this);
        return this.isInverted ? leftInfo.or(rightInfo) : leftInfo.and(rightInfo);
    }

    @Override
    @NotNull
    public MutableContextInfo visitNot(@NotNull ESNot not) {
        Intrinsics.checkParameterIsNotNull((Object)not, (String)"not");
        return (MutableContextInfo)this.inverted((Function0)new Function0<MutableContextInfo>(this, not){
            final /* synthetic */ InfoCollector this$0;
            final /* synthetic */ ESNot $not;

            @NotNull
            public final MutableContextInfo invoke() {
                return (MutableContextInfo)this.$not.getArg().accept(this.this$0);
            }
            {
                this.this$0 = infoCollector;
                this.$not = eSNot;
                super(0);
            }
        });
    }

    @Override
    @NotNull
    public MutableContextInfo visitOr(@NotNull ESOr or2) {
        Intrinsics.checkParameterIsNotNull((Object)or2, (String)"or");
        MutableContextInfo leftInfo = (MutableContextInfo)or2.getLeft().accept(this);
        MutableContextInfo rightInfo = (MutableContextInfo)or2.getRight().accept(this);
        return this.isInverted ? leftInfo.and(rightInfo) : leftInfo.or(rightInfo);
    }

    @Override
    @NotNull
    public MutableContextInfo visitVariable(@NotNull ESVariable esVariable) {
        Intrinsics.checkParameterIsNotNull((Object)esVariable, (String)"esVariable");
        return Intrinsics.areEqual((Object)esVariable.getType(), (Object)DefaultBuiltIns.Companion.getInstance().getBooleanType()) ^ true ? MutableContextInfo.Companion.getEMPTY() : MutableContextInfo.Companion.getEMPTY().equal(esVariable, ValuesKt.lift(!this.isInverted));
    }

    @Override
    @NotNull
    public MutableContextInfo visitConstant(@NotNull ESConstant esConstant) {
        Intrinsics.checkParameterIsNotNull((Object)esConstant, (String)"esConstant");
        return MutableContextInfo.Companion.getEMPTY();
    }

    private final <R> R inverted(Function0<? extends R> block) {
        this.isInverted = !this.isInverted;
        Object result2 = block.invoke();
        this.isInverted = !this.isInverted;
        return (R)result2;
    }

    public InfoCollector(@NotNull ESEffect observedEffect) {
        Intrinsics.checkParameterIsNotNull((Object)observedEffect, (String)"observedEffect");
        this.observedEffect = observedEffect;
    }
}

