/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import java.util.SortedMap;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.PropertyDiffListener;
import org.gradle.api.internal.changedetection.rules.SortedMapDiffUtil;
import org.gradle.api.internal.changedetection.rules.TaskStateChangeVisitor;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.state.TaskExecution;

@NonNullApi
public abstract class AbstractPropertyTaskStateChanges<V>
implements TaskStateChanges {
    private final TaskExecution previous;
    private final TaskExecution current;
    private final String title;
    private final Task task;

    protected AbstractPropertyTaskStateChanges(TaskExecution previous, TaskExecution current, String title, Task task) {
        this.previous = previous;
        this.current = current;
        this.title = title;
        this.task = task;
    }

    protected abstract SortedMap<String, ? extends V> getProperties(TaskExecution var1);

    @Override
    public boolean accept(final TaskStateChangeVisitor visitor) {
        return SortedMapDiffUtil.diff(this.getProperties(this.previous), this.getProperties(this.current), new PropertyDiffListener<String, V>(){

            @Override
            public boolean removed(String previousProperty) {
                return visitor.visitChange(new DescriptiveChange("%s property '%s' has been removed for %s", AbstractPropertyTaskStateChanges.this.title, previousProperty, AbstractPropertyTaskStateChanges.this.task));
            }

            @Override
            public boolean added(String currentProperty) {
                return visitor.visitChange(new DescriptiveChange("%s property '%s' has been added for %s", AbstractPropertyTaskStateChanges.this.title, currentProperty, AbstractPropertyTaskStateChanges.this.task));
            }

            @Override
            public boolean updated(String property, V previous, V current) {
                return true;
            }
        });
    }
}

