/*
 * Decompiled with CFR 0.152.
 */
package org.gennbo;

import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.gennbo.NBODialog;
import org.jmol.c.CBK;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.JmolPlugin;
import org.openscience.jmol.app.jmolpanel.JmolPanel;

public class NBOPlugin
implements JmolPlugin {
    protected NBODialog nboDialog;
    protected Viewer vwr;
    public static final String version = "0.1.2b";

    @Override
    public boolean isStarted() {
        return this.vwr != null;
    }

    @Override
    public void start(JFrame frame, Viewer vwr, Map<String, Object> jmolOptions) {
        this.vwr = vwr;
        if (this.getNBOProperty("serverPath", null) == null) {
            vwr.alert("NBOServe has not been installed. See http://nbo7.chem.wisc.edu/new6_css.htm for additional information");
        }
        this.nboDialog = new NBODialog(this, frame, vwr, jmolOptions);
        System.out.println("NBO Plugin started.");
    }

    @Override
    public String getWebSite() {
        return "http://nbo7.chem.wisc.edu";
    }

    @Override
    public String getName() {
        return "NBOPro@Jmol";
    }

    @Override
    public ImageIcon getMenuIcon() {
        return this.getIcon("nbo7logo20x20");
    }

    @Override
    public String getMenuText() {
        return this.getName();
    }

    ImageIcon getIcon(String name) {
        return new ImageIcon(this.getClass().getResource("assets/" + name + ".gif"));
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public void setVisible(boolean b) {
        if (this.nboDialog == null) {
            return;
        }
        this.nboDialog.setVisible(b);
    }

    @Override
    public void destroy() {
        if (this.nboDialog == null) {
            return;
        }
        this.nboDialog.close();
        this.nboDialog = null;
    }

    @Override
    public void notifyCallback(CBK type, Object[] data) {
        if (this.nboDialog == null) {
            return;
        }
        this.nboDialog.notifyCallback(type, data);
    }

    protected String getNBOProperty(String name, String defaultValue) {
        return JmolPanel.getPluginOption("NBO", name, defaultValue);
    }

    protected void setNBOProperty(String name, String option) {
        if (option == null) {
            return;
        }
        JmolPanel.setPluginOption("NBO", name, option.replace('\\', '/'));
    }
}

