/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.CachingBidirectionalShortFormProvider;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.ReferencedEntitySetProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class BidirectionalShortFormProviderAdapter
extends CachingBidirectionalShortFormProvider {
    @Nonnull
    private final ShortFormProvider shortFormProvider;
    private Set<OWLOntology> ontologies;
    private OWLOntologyManager man;
    @Nonnull
    private final OWLOntologyChangeListener changeListener = new OWLOntologyChangeListener(){

        @Override
        public void ontologiesChanged(@Nonnull List<? extends OWLOntologyChange> changes) {
            BidirectionalShortFormProviderAdapter.this.handleChanges(changes);
        }
    };

    public BidirectionalShortFormProviderAdapter(@Nonnull ShortFormProvider shortFormProvider) {
        this.shortFormProvider = OWLAPIPreconditions.checkNotNull(shortFormProvider, "shortFormProvider cannot be null");
    }

    public BidirectionalShortFormProviderAdapter(@Nonnull Set<OWLOntology> ontologies, @Nonnull ShortFormProvider shortFormProvider) {
        this.shortFormProvider = OWLAPIPreconditions.checkNotNull(shortFormProvider, "shortFormProvider cannot be null");
        this.ontologies = new HashSet<OWLOntology>((Collection)OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null"));
        this.rebuild(new ReferencedEntitySetProvider(ontologies));
    }

    public BidirectionalShortFormProviderAdapter(@Nonnull OWLOntologyManager man, @Nonnull Set<OWLOntology> ontologies, @Nonnull ShortFormProvider shortFormProvider) {
        this(ontologies, shortFormProvider);
        this.man = OWLAPIPreconditions.checkNotNull(man, "man cannot be null");
        this.man.addOntologyChangeListener(this.changeListener);
    }

    @Override
    protected String generateShortForm(@Nonnull OWLEntity entity) {
        return this.shortFormProvider.getShortForm(entity);
    }

    @Override
    public void dispose() {
        if (this.man != null) {
            this.man.removeOntologyChangeListener(this.changeListener);
        }
    }

    void handleChanges(@Nonnull List<? extends OWLOntologyChange> changes) {
        if (this.ontologies == null) {
            return;
        }
        HashSet<OWLEntity> processed = new HashSet<OWLEntity>();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!this.ontologies.contains(oWLOntologyChange.getOntology())) continue;
            if (oWLOntologyChange.isAddAxiom()) {
                AddAxiom addAx = (AddAxiom)oWLOntologyChange;
                for (OWLEntity ent : addAx.getSignature()) {
                    assert (ent != null);
                    if (processed.contains(ent)) continue;
                    processed.add(ent);
                    this.add(ent);
                }
                continue;
            }
            if (!oWLOntologyChange.isRemoveAxiom()) continue;
            RemoveAxiom remAx = (RemoveAxiom)oWLOntologyChange;
            for (OWLEntity ent : remAx.getSignature()) {
                assert (ent != null);
                if (processed.contains(ent)) continue;
                processed.add(ent);
                boolean stillRef = false;
                for (OWLOntology ont : this.ontologies) {
                    if (!ont.containsEntityInSignature(ent)) continue;
                    stillRef = true;
                    break;
                }
                if (stillRef) continue;
                this.remove(ent);
            }
        }
    }
}

