/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin;

import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NumberRange
implements Validator<String> {
    private Number max;
    private Number min;

    NumberRange(Number min, Number max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean validate(Problems problems, String compName, String model) {
        try {
            boolean result;
            double val = Double.parseDouble(model);
            double minn = this.min.doubleValue();
            double maxx = this.max.doubleValue();
            boolean bl = result = val >= minn && val <= maxx;
            if (!result) {
                problems.add(NbBundle.getMessage(NumberRange.class, (String)"VALUE_OUT_OF_RANGE", (Object[])new Object[]{compName, model, this.min, this.max}));
            }
            return result;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }
}

