/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.net.ssl.SSLParameters;
import org.bouncycastle.jsse.provider.JsseUtils_8;
import org.bouncycastle.jsse.provider.ProvSSLParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SSLParametersUtil {
    private static final Method getAlgorithmConstraints;
    private static final Method setAlgorithmConstraints;
    private static final Method getEndpointIdentificationAlgorithm;
    private static final Method setEndpointIdentificationAlgorithm;
    private static final Method getServerNames;
    private static final Method setServerNames;
    private static final Method getUseCipherSuitesOrder;
    private static final Method setUseCipherSuitesOrder;

    SSLParametersUtil() {
    }

    private static Method findMethod(Method[] methodArray, String string) {
        if (methodArray != null) {
            for (Method method : methodArray) {
                if (!method.getName().equals(string)) continue;
                return method;
            }
        }
        return null;
    }

    private static Class<?> getClassPrivileged(final String string) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    ClassLoader classLoader = SSLParametersUtil.class.getClassLoader();
                    if (classLoader != null) {
                        return classLoader.loadClass(string);
                    }
                    return Class.forName(string);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }

    private static Method[] getMethodsPrivileged(final Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                try {
                    return clazz.getMethods();
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }

    private static Object invokeGetterPrivileged(final Object object, final Method method) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return method.invoke(object, new Object[0]);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }

    private static void invokeSetterPrivileged(final Object object, final Method method, final Object object2) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    method.invoke(object, object2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    static SSLParameters toSSLParameters(ProvSSLParameters provSSLParameters) {
        SSLParameters sSLParameters = new SSLParameters();
        sSLParameters.setCipherSuites(provSSLParameters.getCipherSuites());
        sSLParameters.setProtocols(provSSLParameters.getProtocols());
        if (setAlgorithmConstraints != null) {
            SSLParametersUtil.invokeSetterPrivileged(sSLParameters, setAlgorithmConstraints, provSSLParameters.getAlgorithmConstraints());
        }
        if (setEndpointIdentificationAlgorithm != null) {
            SSLParametersUtil.invokeSetterPrivileged(sSLParameters, setEndpointIdentificationAlgorithm, provSSLParameters.getEndpointIdentificationAlgorithm());
        }
        if (setServerNames != null) {
            SSLParametersUtil.invokeSetterPrivileged(sSLParameters, setServerNames, JsseUtils_8.exportSNIServerNames(provSSLParameters.getServerNames()));
        }
        if (setUseCipherSuitesOrder != null) {
            SSLParametersUtil.invokeSetterPrivileged(sSLParameters, setUseCipherSuitesOrder, provSSLParameters.getUseCipherSuitesOrder());
        }
        if (provSSLParameters.getNeedClientAuth()) {
            sSLParameters.setNeedClientAuth(true);
        } else if (provSSLParameters.getWantClientAuth()) {
            sSLParameters.setWantClientAuth(true);
        } else {
            sSLParameters.setWantClientAuth(false);
        }
        return sSLParameters;
    }

    static ProvSSLParameters toProvSSLParameters(SSLParameters sSLParameters) {
        ProvSSLParameters provSSLParameters = new ProvSSLParameters();
        provSSLParameters.setCipherSuites(sSLParameters.getCipherSuites());
        provSSLParameters.setProtocols(sSLParameters.getProtocols());
        if (getAlgorithmConstraints != null) {
            provSSLParameters.setAlgorithmConstraints(SSLParametersUtil.invokeGetterPrivileged(sSLParameters, getAlgorithmConstraints));
        }
        if (getEndpointIdentificationAlgorithm != null) {
            provSSLParameters.setEndpointIdentificationAlgorithm((String)SSLParametersUtil.invokeGetterPrivileged(sSLParameters, getEndpointIdentificationAlgorithm));
        }
        if (getServerNames != null) {
            provSSLParameters.setServerNames(JsseUtils_8.importSNIServerNames(SSLParametersUtil.invokeGetterPrivileged(sSLParameters, getServerNames)));
        }
        if (getUseCipherSuitesOrder != null) {
            provSSLParameters.setUseCipherSuitesOrder((Boolean)SSLParametersUtil.invokeGetterPrivileged(sSLParameters, getUseCipherSuitesOrder));
        }
        if (sSLParameters.getNeedClientAuth()) {
            provSSLParameters.setNeedClientAuth(true);
        } else if (sSLParameters.getWantClientAuth()) {
            provSSLParameters.setWantClientAuth(true);
        } else {
            provSSLParameters.setWantClientAuth(false);
        }
        return provSSLParameters;
    }

    static {
        Class<?> clazz = SSLParametersUtil.getClassPrivileged("javax.net.ssl.SSLParameters");
        Method[] methodArray = SSLParametersUtil.getMethodsPrivileged(clazz);
        getAlgorithmConstraints = SSLParametersUtil.findMethod(methodArray, "getAlgorithmConstraints");
        setAlgorithmConstraints = SSLParametersUtil.findMethod(methodArray, "setAlgorithmConstraints");
        getEndpointIdentificationAlgorithm = SSLParametersUtil.findMethod(methodArray, "getEndpointIdentificationAlgorithm");
        setEndpointIdentificationAlgorithm = SSLParametersUtil.findMethod(methodArray, "setEndpointIdentificationAlgorithm");
        getServerNames = SSLParametersUtil.findMethod(methodArray, "getServerNames");
        setServerNames = SSLParametersUtil.findMethod(methodArray, "setServerNames");
        getUseCipherSuitesOrder = SSLParametersUtil.findMethod(methodArray, "getUseCipherSuitesOrder");
        setUseCipherSuitesOrder = SSLParametersUtil.findMethod(methodArray, "setUseCipherSuitesOrder");
    }
}

