# Stubs for os
# Ron Murawski <ron@horizonchess.com>

from io import TextIOWrapper as _TextIOWrapper
import sys
from typing import (
    Mapping, MutableMapping, Dict, List, Any, Tuple, IO, Iterable, Iterator, NoReturn, overload, Union, AnyStr,
    Optional, Generic, Set, Callable, Text, Sequence, NamedTuple, TypeVar, ContextManager
)

# Re-exported names from other modules.
from builtins import OSError as error
from posix import stat_result as stat_result
from . import path as path

_T = TypeVar('_T')

# ----- os variables -----

if sys.version_info >= (3, 2):
    supports_bytes_environ: bool

if sys.version_info >= (3, 3):
    supports_dir_fd: Set[Callable[..., Any]]
    supports_fd: Set[Callable[..., Any]]
    supports_effective_ids: Set[Callable[..., Any]]
    supports_follow_symlinks: Set[Callable[..., Any]]

    if sys.platform != 'win32':
        # Unix only
        PRIO_PROCESS: int
        PRIO_PGRP: int
        PRIO_USER: int

        F_LOCK: int
        F_TLOCK: int
        F_ULOCK: int
        F_TEST: int

        POSIX_FADV_NORMAL: int
        POSIX_FADV_SEQUENTIAL: int
        POSIX_FADV_RANDOM: int
        POSIX_FADV_NOREUSE: int
        POSIX_FADV_WILLNEED: int
        POSIX_FADV_DONTNEED: int

        SF_NODISKIO: int
        SF_MNOWAIT: int
        SF_SYNC: int

        XATTR_SIZE_MAX: int  # Linux only
        XATTR_CREATE: int  # Linux only
        XATTR_REPLACE: int  # Linux only

        P_PID: int
        P_PGID: int
        P_ALL: int

        WEXITED: int
        WSTOPPED: int
        WNOWAIT: int

        CLD_EXITED: int
        CLD_DUMPED: int
        CLD_TRAPPED: int
        CLD_CONTINUED: int

        SCHED_OTHER: int  # some flavors of Unix
        SCHED_BATCH: int  # some flavors of Unix
        SCHED_IDLE: int  # some flavors of Unix
        SCHED_SPORADIC: int  # some flavors of Unix
        SCHED_FIFO: int  # some flavors of Unix
        SCHED_RR: int  # some flavors of Unix
        SCHED_RESET_ON_FORK: int  # some flavors of Unix

    RTLD_LAZY: int
    RTLD_NOW: int
    RTLD_GLOBAL: int
    RTLD_LOCAL: int
    RTLD_NODELETE: int
    RTLD_NOLOAD: int
    RTLD_DEEPBIND: int


SEEK_SET: int
SEEK_CUR: int
SEEK_END: int
if sys.version_info >= (3, 3) and sys.platform != 'win32':
    SEEK_DATA: int  # some flavors of Unix
    SEEK_HOLE: int  # some flavors of Unix

O_RDONLY: int
O_WRONLY: int
O_RDWR: int
O_APPEND: int
O_CREAT: int
O_EXCL: int
O_TRUNC: int
# We don't use sys.platform for O_* flags to denote platform-dependent APIs because some codes,
# including tests for mypy, use a more finer way than sys.platform before using these APIs
# See https://github.com/python/typeshed/pull/2286 for discussions
O_DSYNC: int    # Unix only
O_RSYNC: int    # Unix only
O_SYNC: int     # Unix only
O_NDELAY: int   # Unix only
O_NONBLOCK: int  # Unix only
O_NOCTTY: int   # Unix only
if sys.version_info >= (3, 3):
    O_CLOEXEC: int  # Unix only
O_SHLOCK: int   # Unix only
O_EXLOCK: int   # Unix only
O_BINARY: int     # Windows only
O_NOINHERIT: int  # Windows only
O_SHORT_LIVED: int  # Windows only
O_TEMPORARY: int  # Windows only
O_RANDOM: int     # Windows only
O_SEQUENTIAL: int  # Windows only
O_TEXT: int       # Windows only
O_ASYNC: int      # Gnu extension if in C library
O_DIRECT: int     # Gnu extension if in C library
O_DIRECTORY: int  # Gnu extension if in C library
O_NOFOLLOW: int   # Gnu extension if in C library
O_NOATIME: int    # Gnu extension if in C library
if sys.version_info >= (3, 4):
    O_PATH: int  # Gnu extension if in C library
    O_TMPFILE: int  # Gnu extension if in C library
O_LARGEFILE: int  # Gnu extension if in C library

curdir: str
pardir: str
sep: str
altsep: str
extsep: str
pathsep: str
defpath: str
linesep: str
devnull: str
name: str

F_OK: int
R_OK: int
W_OK: int
X_OK: int

class _Environ(MutableMapping[AnyStr, AnyStr], Generic[AnyStr]):
    def copy(self) -> Dict[AnyStr, AnyStr]: ...
    def __delitem__(self, key: AnyStr) -> None: ...
    def __getitem__(self, key: AnyStr) -> AnyStr: ...
    def __setitem__(self, key: AnyStr, value: AnyStr) -> None: ...
    def __iter__(self) -> Iterator[AnyStr]: ...
    def __len__(self) -> int: ...

environ: _Environ[str]
if sys.version_info >= (3, 2):
    environb: _Environ[bytes]

if sys.platform != 'win32':
    confstr_names: Dict[str, int]
    pathconf_names: Dict[str, int]
    sysconf_names: Dict[str, int]

    EX_OK: int
    EX_USAGE: int
    EX_DATAERR: int
    EX_NOINPUT: int
    EX_NOUSER: int
    EX_NOHOST: int
    EX_UNAVAILABLE: int
    EX_SOFTWARE: int
    EX_OSERR: int
    EX_OSFILE: int
    EX_CANTCREAT: int
    EX_IOERR: int
    EX_TEMPFAIL: int
    EX_PROTOCOL: int
    EX_NOPERM: int
    EX_CONFIG: int
    EX_NOTFOUND: int

P_NOWAIT: int
P_NOWAITO: int
P_WAIT: int
if sys.platform == 'win32':
    P_DETACH: int
    P_OVERLAY: int

# wait()/waitpid() options
if sys.platform != 'win32':
    WNOHANG: int  # Unix only
    WCONTINUED: int  # some Unix systems
    WUNTRACED: int  # Unix only

TMP_MAX: int  # Undocumented, but used by tempfile

# ----- os classes (structures) -----
if sys.version_info >= (3, 6):
    from builtins import _PathLike as PathLike  # See comment in builtins

_PathType = path._PathType
if sys.version_info >= (3, 3):
    _FdOrPathType = Union[int, _PathType]
else:
    _FdOrPathType = _PathType

if sys.version_info >= (3, 6):
    class DirEntry(PathLike[AnyStr]):
        # This is what the scandir interator yields
        # The constructor is hidden

        name: AnyStr
        path: AnyStr
        def inode(self) -> int: ...
        def is_dir(self, follow_symlinks: bool = ...) -> bool: ...
        def is_file(self, follow_symlinks: bool = ...) -> bool: ...
        def is_symlink(self) -> bool: ...
        def stat(self) -> stat_result: ...

        def __fspath__(self) -> AnyStr: ...
elif sys.version_info >= (3, 5):
    class DirEntry(Generic[AnyStr]):
        # This is what the scandir interator yields
        # The constructor is hidden

        name: AnyStr
        path: AnyStr
        def inode(self) -> int: ...
        def is_dir(self, follow_symlinks: bool = ...) -> bool: ...
        def is_file(self, follow_symlinks: bool = ...) -> bool: ...
        def is_symlink(self) -> bool: ...
        def stat(self) -> stat_result: ...


if sys.platform != 'win32':
    class statvfs_result:  # Unix only
        f_bsize: int
        f_frsize: int
        f_blocks: int
        f_bfree: int
        f_bavail: int
        f_files: int
        f_ffree: int
        f_favail: int
        f_flag: int
        f_namemax: int

# ----- os function stubs -----
if sys.version_info >= (3, 6):
    def fsencode(filename: Union[str, bytes, PathLike]) -> bytes: ...
else:
    def fsencode(filename: Union[str, bytes]) -> bytes: ...

if sys.version_info >= (3, 6):
    def fsdecode(filename: Union[str, bytes, PathLike]) -> str: ...
else:
    def fsdecode(filename: Union[str, bytes]) -> str: ...

if sys.version_info >= (3, 6):
    @overload
    def fspath(path: str) -> str: ...
    @overload
    def fspath(path: bytes) -> bytes: ...
    @overload
    def fspath(path: PathLike) -> Any: ...

def get_exec_path(env: Optional[Mapping[str, str]] = ...) -> List[str]: ...
# NOTE: get_exec_path(): returns List[bytes] when env not None
def getlogin() -> str: ...
def getpid() -> int: ...
def getppid() -> int: ...
def strerror(code: int) -> str: ...
def umask(mask: int) -> int: ...

if sys.platform != 'win32':
    # Unix only
    def ctermid() -> str: ...
    def getegid() -> int: ...
    def geteuid() -> int: ...
    def getgid() -> int: ...
    if sys.version_info >= (3, 3):
        def getgrouplist(user: str, gid: int) -> List[int]: ...
    def getgroups() -> List[int]: ...  # Unix only, behaves differently on Mac
    def initgroups(username: str, gid: int) -> None: ...
    def getpgid(pid: int) -> int: ...
    def getpgrp() -> int: ...
    if sys.version_info >= (3, 3):
        def getpriority(which: int, who: int) -> int: ...
        def setpriority(which: int, who: int, priority: int) -> None: ...
    def getresuid() -> Tuple[int, int, int]: ...
    def getresgid() -> Tuple[int, int, int]: ...
    def getuid() -> int: ...
    def setegid(egid: int) -> None: ...
    def seteuid(euid: int) -> None: ...
    def setgid(gid: int) -> None: ...
    def setgroups(groups: Sequence[int]) -> None: ...
    def setpgrp() -> None: ...
    def setpgid(pid: int, pgrp: int) -> None: ...
    def setregid(rgid: int, egid: int) -> None: ...
    def setresgid(rgid: int, egid: int, sgid: int) -> None: ...
    def setresuid(ruid: int, euid: int, suid: int) -> None: ...
    def setreuid(ruid: int, euid: int) -> None: ...
    def getsid(pid: int) -> int: ...
    def setsid() -> None: ...
    def setuid(uid: int) -> None: ...
    if sys.version_info >= (3, 3):
        from posix import uname_result
        def uname() -> uname_result: ...
    else:
        def uname() -> Tuple[str, str, str, str, str]: ...

@overload
def getenv(key: Text) -> Optional[str]: ...
@overload
def getenv(key: Text, default: _T) -> Union[str, _T]: ...
def getenvb(key: bytes, default: bytes = ...) -> bytes: ...
def putenv(key: Union[bytes, Text], value: Union[bytes, Text]) -> None: ...
def unsetenv(key: Union[bytes, Text]) -> None: ...

# Return IO or TextIO
def fdopen(fd: int, mode: str = ..., buffering: int = ..., encoding: Optional[str] = ...,
           errors: str = ..., newline: str = ..., closefd: bool = ...) -> Any: ...
def close(fd: int) -> None: ...
def closerange(fd_low: int, fd_high: int) -> None: ...
def device_encoding(fd: int) -> Optional[str]: ...
def dup(fd: int) -> int: ...
def dup2(fd: int, fd2: int) -> None: ...
def fstat(fd: int) -> stat_result: ...
def fsync(fd: int) -> None: ...
def lseek(fd: int, pos: int, how: int) -> int: ...
if sys.version_info >= (3, 3):
    def open(file: _PathType, flags: int, mode: int = ..., *, dir_fd: Optional[int] = ...) -> int: ...
else:
    def open(file: _PathType, flags: int, mode: int = ...) -> int: ...
def pipe() -> Tuple[int, int]: ...
def read(fd: int, n: int) -> bytes: ...

if sys.platform != 'win32':
    # Unix only
    def fchmod(fd: int, mode: int) -> None: ...
    def fchown(fd: int, uid: int, gid: int) -> None: ...
    def fdatasync(fd: int) -> None: ...  # Unix only, not Mac
    def fpathconf(fd: int, name: Union[str, int]) -> int: ...
    def fstatvfs(fd: int) -> statvfs_result: ...
    def ftruncate(fd: int, length: int) -> None: ...
    if sys.version_info >= (3, 5):
        def get_blocking(fd: int) -> bool: ...
        def set_blocking(fd: int, blocking: bool) -> None: ...
    def isatty(fd: int) -> bool: ...
    if sys.version_info >= (3, 3):
        def lockf(__fd: int, __cmd: int, __length: int) -> None: ...
    def openpty() -> Tuple[int, int]: ...  # some flavors of Unix
    if sys.version_info >= (3, 3):
        def pipe2(flags: int) -> Tuple[int, int]: ...  # some flavors of Unix
        def posix_fallocate(fd: int, offset: int, length: int) -> None: ...
        def posix_fadvise(fd: int, offset: int, length: int, advice: int) -> None: ...
        def pread(fd: int, buffersize: int, offset: int) -> bytes: ...
        def pwrite(fd: int, string: bytes, offset: int) -> int: ...
        @overload
        def sendfile(__out_fd: int, __in_fd: int, offset: Optional[int], count: int) -> int: ...
        @overload
        def sendfile(__out_fd: int, __in_fd: int, offset: int, count: int,
                     headers: Sequence[bytes] = ..., trailers: Sequence[bytes] = ..., flags: int = ...) -> int: ...  # FreeBSD and Mac OS X only
        def readv(fd: int, buffers: Sequence[bytearray]) -> int: ...
        def writev(fd: int, buffers: Sequence[bytes]) -> int: ...

terminal_size = NamedTuple('terminal_size', [('columns', int), ('lines', int)])
def get_terminal_size(fd: int = ...) -> terminal_size: ...

if sys.version_info >= (3, 4):
    def get_inheritable(fd: int) -> bool: ...
    def set_inheritable(fd: int, inheritable: bool) -> None: ...

if sys.platform != 'win32':
    # Unix only
    def tcgetpgrp(fd: int) -> int: ...
    def tcsetpgrp(fd: int, pg: int) -> None: ...
    def ttyname(fd: int) -> str: ...
def write(fd: int, string: bytes) -> int: ...
if sys.version_info >= (3, 3):
    def access(path: _FdOrPathType, mode: int, *, dir_fd: Optional[int] = ...,
               effective_ids: bool = ..., follow_symlinks: bool = ...) -> bool: ...
else:
    def access(path: _PathType, mode: int) -> bool: ...
def chdir(path: _FdOrPathType) -> None: ...
def fchdir(fd: int) -> None: ...
def getcwd() -> str: ...
def getcwdb() -> bytes: ...
if sys.version_info >= (3, 3):
    def chmod(path: _FdOrPathType, mode: int, *, dir_fd: Optional[int] = ..., follow_symlinks: bool = ...) -> None: ...
    if sys.platform != 'win32':
        def chflags(path: _PathType, flags: int, follow_symlinks: bool = ...) -> None: ...  # some flavors of Unix
        def chown(path: _FdOrPathType, uid: int, gid: int, *, dir_fd: Optional[int] = ..., follow_symlinks: bool = ...) -> None: ...  # Unix only
else:
    def chmod(path: _PathType, mode: int) -> None: ...
    if sys.platform != 'win32':
        def chflags(path: _PathType, flags: int) -> None: ...  # Some flavors of Unix
        def chown(path: _PathType, uid: int, gid: int) -> None: ...  # Unix only
if sys.platform != 'win32':
    # Unix only
    def chroot(path: _PathType) -> None: ...
    def lchflags(path: _PathType, flags: int) -> None: ...
    def lchmod(path: _PathType, mode: int) -> None: ...
    def lchown(path: _PathType, uid: int, gid: int) -> None: ...
if sys.version_info >= (3, 3):
    def link(src: _PathType, link_name: _PathType, *, src_dir_fd: Optional[int] = ...,
             dst_dir_fd: Optional[int] = ..., follow_symlinks: bool = ...) -> None: ...
else:
    def link(src: _PathType, link_name: _PathType) -> None: ...

if sys.version_info >= (3, 6):
    @overload
    def listdir(path: Optional[str] = ...) -> List[str]: ...
    @overload
    def listdir(path: bytes) -> List[bytes]: ...
    @overload
    def listdir(path: int) -> List[str]: ...
    @overload
    def listdir(path: PathLike[str]) -> List[str]: ...
elif sys.version_info >= (3, 3):
    @overload
    def listdir(path: Optional[str] = ...) -> List[str]: ...
    @overload
    def listdir(path: bytes) -> List[bytes]: ...
    @overload
    def listdir(path: int) -> List[str]: ...
else:
    @overload
    def listdir(path: Optional[str] = ...) -> List[str]: ...
    @overload
    def listdir(path: bytes) -> List[bytes]: ...

if sys.version_info >= (3, 3):
    def lstat(path: _PathType, *, dir_fd: Optional[int] = ...) -> stat_result: ...
    def mkdir(path: _PathType, mode: int = ..., *, dir_fd: Optional[int] = ...) -> None: ...
    if sys.platform != 'win32':
        def mkfifo(path: _PathType, mode: int = ..., *, dir_fd: Optional[int] = ...) -> None: ...  # Unix only
else:
    def lstat(path: _PathType) -> stat_result: ...
    def mkdir(path: _PathType, mode: int = ...) -> None: ...
    if sys.platform != 'win32':
        def mkfifo(path: _PathType, mode: int = ...) -> None: ...  # Unix only
if sys.version_info >= (3, 4):
    def makedirs(name: _PathType, mode: int = ..., exist_ok: bool = ...) -> None: ...
else:
    def makedirs(path: _PathType, mode: int = ..., exist_ok: bool = ...) -> None: ...
if sys.version_info >= (3, 4):
    def mknod(path: _PathType, mode: int = ..., device: int = ...,
              *, dir_fd: Optional[int] = ...) -> None: ...
elif sys.version_info >= (3, 3):
    def mknod(filename: _PathType, mode: int = ..., device: int = ...,
              *, dir_fd: Optional[int] = ...) -> None: ...
else:
    def mknod(filename: _PathType, mode: int = ..., device: int = ...) -> None: ...
def major(device: int) -> int: ...
def minor(device: int) -> int: ...
def makedev(major: int, minor: int) -> int: ...
if sys.platform != 'win32':
    def pathconf(path: _FdOrPathType, name: Union[str, int]) -> int: ...  # Unix only
if sys.version_info >= (3, 6):
    def readlink(path: Union[AnyStr, PathLike[AnyStr]], *, dir_fd: Optional[int] = ...) -> AnyStr: ...
elif sys.version_info >= (3, 3):
    def readlink(path: AnyStr, *, dir_fd: Optional[int] = ...) -> AnyStr: ...
else:
    def readlink(path: AnyStr) -> AnyStr: ...
if sys.version_info >= (3, 3):
    def remove(path: _PathType, *, dir_fd: Optional[int] = ...) -> None: ...
else:
    def remove(path: _PathType) -> None: ...
if sys.version_info >= (3, 4):
    def removedirs(name: _PathType) -> None: ...
else:
    def removedirs(path: _PathType) -> None: ...
if sys.version_info >= (3, 3):
    def rename(src: _PathType, dst: _PathType, *,
               src_dir_fd: Optional[int] = ..., dst_dir_fd: Optional[int] = ...) -> None: ...
else:
    def rename(src: _PathType, dst: _PathType) -> None: ...
def renames(old: _PathType, new: _PathType) -> None: ...
if sys.version_info >= (3, 3):
    def replace(src: _PathType, dst: _PathType, *,
               src_dir_fd: Optional[int] = ..., dst_dir_fd: Optional[int] = ...) -> None: ...
    def rmdir(path: _PathType, *, dir_fd: Optional[int] = ...) -> None: ...
else:
    def rmdir(path: _PathType) -> None: ...
if sys.version_info >= (3, 7):
    class _ScandirIterator(Iterator[DirEntry[AnyStr]], ContextManager[_ScandirIterator[AnyStr]]):
        def __next__(self) -> DirEntry[AnyStr]: ...
        def close(self) -> None: ...
    @overload
    def scandir() -> _ScandirIterator[str]: ...
    @overload
    def scandir(path: int) -> _ScandirIterator[str]: ...
    @overload
    def scandir(path: Union[AnyStr, PathLike[AnyStr]]) -> _ScandirIterator[AnyStr]: ...
elif sys.version_info >= (3, 6):
    class _ScandirIterator(Iterator[DirEntry[AnyStr]], ContextManager[_ScandirIterator[AnyStr]]):
        def __next__(self) -> DirEntry[AnyStr]: ...
        def close(self) -> None: ...
    @overload
    def scandir() -> _ScandirIterator[str]: ...
    @overload
    def scandir(path: Union[AnyStr, PathLike[AnyStr]]) -> _ScandirIterator[AnyStr]: ...
elif sys.version_info >= (3, 5):
    @overload
    def scandir() -> Iterator[DirEntry[str]]: ...
    @overload
    def scandir(path: AnyStr) -> Iterator[DirEntry[AnyStr]]: ...
if sys.version_info >= (3, 3):
    def stat(path: _FdOrPathType, *, dir_fd: Optional[int] = ...,
             follow_symlinks: bool = ...) -> stat_result: ...
else:
    def stat(path: _PathType) -> stat_result: ...
if sys.version_info < (3, 7):
    @overload
    def stat_float_times() -> bool: ...
    @overload
    def stat_float_times(__newvalue: bool) -> None: ...
if sys.platform != 'win32':
    def statvfs(path: _FdOrPathType) -> statvfs_result: ...  # Unix only
if sys.version_info >= (3, 3):
    def symlink(source: _PathType, link_name: _PathType,
                target_is_directory: bool = ..., *, dir_fd: Optional[int] = ...) -> None: ...
    if sys.platform != 'win32':
        def sync() -> None: ...  # Unix only
    def truncate(path: _FdOrPathType, length: int) -> None: ...  # Unix only up to version 3.4
    def unlink(path: _PathType, *, dir_fd: Optional[int] = ...) -> None: ...
    def utime(path: _FdOrPathType, times: Optional[Union[Tuple[int, int], Tuple[float, float]]] = ..., *,
              ns: Tuple[int, int] = ..., dir_fd: Optional[int] = ...,
              follow_symlinks: bool = ...) -> None: ...
else:
    def symlink(source: _PathType, link_name: _PathType,
                target_is_directory: bool = ...) -> None:
        ...  # final argument in Windows only
    def unlink(path: _PathType) -> None: ...
    def utime(path: _PathType, times: Optional[Tuple[float, float]]) -> None: ...

if sys.version_info >= (3, 6):
    def walk(top: Union[AnyStr, PathLike[AnyStr]], topdown: bool = ...,
             onerror: Optional[Callable[[OSError], Any]] = ...,
             followlinks: bool = ...) -> Iterator[Tuple[AnyStr, List[AnyStr],
                                                        List[AnyStr]]]: ...
else:
    def walk(top: AnyStr, topdown: bool = ..., onerror: Optional[Callable[[OSError], Any]] = ...,
             followlinks: bool = ...) -> Iterator[Tuple[AnyStr, List[AnyStr],
                                                        List[AnyStr]]]: ...
if sys.platform != 'win32' and sys.version_info >= (3, 3):
    if sys.version_info >= (3, 7):
        @overload
        def fwalk(top: Union[str, PathLike[str]] = ..., topdown: bool = ...,
                  onerror: Optional[Callable] = ..., *, follow_symlinks: bool = ...,
                  dir_fd: Optional[int] = ...) -> Iterator[Tuple[str, List[str], List[str], int]]: ...
        @overload
        def fwalk(top: bytes, topdown: bool = ...,
                  onerror: Optional[Callable] = ..., *, follow_symlinks: bool = ...,
                  dir_fd: Optional[int] = ...) -> Iterator[Tuple[bytes, List[bytes], List[bytes], int]]: ...
    elif sys.version_info >= (3, 6):
        def fwalk(top: Union[str, PathLike[str]] = ..., topdown: bool = ...,
                  onerror: Optional[Callable] = ..., *, follow_symlinks: bool = ...,
                  dir_fd: Optional[int] = ...) -> Iterator[Tuple[str, List[str], List[str], int]]: ...
    else:
        def fwalk(top: str = ..., topdown: bool = ...,
                  onerror: Optional[Callable] = ..., *, follow_symlinks: bool = ...,
                  dir_fd: Optional[int] = ...) -> Iterator[Tuple[str, List[str], List[str], int]]: ...
    def getxattr(path: _FdOrPathType, attribute: _PathType, *, follow_symlinks: bool = ...) -> bytes: ...  # Linux only
    def listxattr(path: _FdOrPathType, *, follow_symlinks: bool = ...) -> List[str]: ...  # Linux only
    def removexattr(path: _FdOrPathType, attribute: _PathType, *, follow_symlinks: bool = ...) -> None: ...  # Linux only
    def setxattr(path: _FdOrPathType, attribute: _PathType, value: bytes, flags: int = ..., *,
                 follow_symlinks: bool = ...) -> None: ...  # Linux only

def abort() -> NoReturn: ...
# These are defined as execl(file, *args) but the first *arg is mandatory.
def execl(file: _PathType, __arg0: Union[bytes, Text], *args: Union[bytes, Text]) -> NoReturn: ...
def execlp(file: _PathType, __arg0: Union[bytes, Text], *args: Union[bytes, Text]) -> NoReturn: ...

# These are: execle(file, *args, env) but env is pulled from the last element of the args.
def execle(file: _PathType, __arg0: Union[bytes, Text], *args: Any) -> NoReturn: ...
def execlpe(file: _PathType, __arg0: Union[bytes, Text], *args: Any) -> NoReturn: ...

# The docs say `args: tuple or list of strings`
# The implementation enforces tuple or list so we can't use Sequence.
_ExecVArgs = Union[Tuple[Union[bytes, Text], ...], List[bytes], List[Text], List[Union[bytes, Text]]]
def execv(path: _PathType, args: _ExecVArgs) -> NoReturn: ...
def execve(path: _FdOrPathType, args: _ExecVArgs, env: Mapping[str, str]) -> NoReturn: ...
def execvp(file: _PathType, args: _ExecVArgs) -> NoReturn: ...
def execvpe(file: _PathType, args: _ExecVArgs, env: Mapping[str, str]) -> NoReturn: ...

def _exit(n: int) -> NoReturn: ...
def kill(pid: int, sig: int) -> None: ...
if sys.platform != 'win32':
    # Unix only
    def fork() -> int: ...
    def forkpty() -> Tuple[int, int]: ...  # some flavors of Unix
    def killpg(pgid: int, sig: int) -> None: ...
    def nice(increment: int) -> int: ...
    def plock(op: int) -> None: ...  # ???op is int?

if sys.version_info >= (3, 0):
    class _wrap_close(_TextIOWrapper):
        def close(self) -> Optional[int]: ...  # type: ignore
    def popen(command: str, mode: str = ..., buffering: int = ...) -> _wrap_close: ...
else:
    class _wrap_close(IO[Text]):
        def close(self) -> Optional[int]: ...  # type: ignore
    def popen(__cmd: Text, __mode: Text = ..., __bufsize: int = ...) -> _wrap_close: ...
    def popen2(__cmd: Text, __mode: Text = ..., __bufsize: int = ...) -> Tuple[IO[Text], IO[Text]]: ...
    def popen3(__cmd: Text, __mode: Text = ..., __bufsize: int = ...) -> Tuple[IO[Text], IO[Text], IO[Text]]: ...
    def popen4(__cmd: Text, __mode: Text = ..., __bufsize: int = ...) -> Tuple[IO[Text], IO[Text]]: ...

def spawnl(mode: int, path: _PathType, arg0: Union[bytes, Text], *args: Union[bytes, Text]) -> int: ...
def spawnle(mode: int, path: _PathType, arg0: Union[bytes, Text],
            *args: Any) -> int: ...  # Imprecise sig
def spawnv(mode: int, path: _PathType, args: List[Union[bytes, Text]]) -> int: ...
def spawnve(mode: int, path: _PathType, args: List[Union[bytes, Text]],
            env: Mapping[str, str]) -> int: ...
def system(command: _PathType) -> int: ...
if sys.version_info >= (3, 3):
    from posix import times_result
    def times() -> times_result: ...
else:
    def times() -> Tuple[float, float, float, float, float]: ...
def waitpid(pid: int, options: int) -> Tuple[int, int]: ...

if sys.platform == 'win32':
    def startfile(path: _PathType, operation: Optional[str] = ...) -> None: ...
else:
    # Unix only
    def spawnlp(mode: int, file: _PathType, arg0: Union[bytes, Text], *args: Union[bytes, Text]) -> int: ...
    def spawnlpe(mode: int, file: _PathType, arg0: Union[bytes, Text], *args: Any) -> int: ...  # Imprecise signature
    def spawnvp(mode: int, file: _PathType, args: List[Union[bytes, Text]]) -> int: ...
    def spawnvpe(mode: int, file: _PathType, args: List[Union[bytes, Text]], env: Mapping[str, str]) -> int: ...
    def wait() -> Tuple[int, int]: ...  # Unix only
    if sys.version_info >= (3, 3):
        from posix import waitid_result
        def waitid(idtype: int, ident: int, options: int) -> waitid_result: ...
    def wait3(options: int) -> Tuple[int, int, Any]: ...
    def wait4(pid: int, options: int) -> Tuple[int, int, Any]: ...
    def WCOREDUMP(status: int) -> bool: ...
    def WIFCONTINUED(status: int) -> bool: ...
    def WIFSTOPPED(status: int) -> bool: ...
    def WIFSIGNALED(status: int) -> bool: ...
    def WIFEXITED(status: int) -> bool: ...
    def WEXITSTATUS(status: int) -> int: ...
    def WSTOPSIG(status: int) -> int: ...
    def WTERMSIG(status: int) -> int: ...

if sys.platform != 'win32' and sys.version_info >= (3, 3):
    from posix import sched_param
    def sched_get_priority_min(policy: int) -> int: ...  # some flavors of Unix
    def sched_get_priority_max(policy: int) -> int: ...  # some flavors of Unix
    def sched_setscheduler(pid: int, policy: int, param: sched_param) -> None: ...  # some flavors of Unix
    def sched_getscheduler(pid: int) -> int: ...  # some flavors of Unix
    def sched_setparam(pid: int, param: sched_param) -> None: ...  # some flavors of Unix
    def sched_getparam(pid: int) -> sched_param: ...  # some flavors of Unix
    def sched_rr_get_interval(pid: int) -> float: ...  # some flavors of Unix
    def sched_yield() -> None: ...  # some flavors of Unix
    def sched_setaffinity(pid: int, mask: Iterable[int]) -> None: ...  # some flavors of Unix
    def sched_getaffinity(pid: int) -> Set[int]: ...  # some flavors of Unix

if sys.version_info >= (3, 4):
    def cpu_count() -> Optional[int]: ...
if sys.platform != 'win32':
    # Unix only
    def confstr(name: Union[str, int]) -> Optional[str]: ...
    def getloadavg() -> Tuple[float, float, float]: ...
    def sysconf(name: Union[str, int]) -> int: ...
if sys.version_info >= (3, 6):
    def getrandom(size: int, flags: int = ...) -> bytes: ...
    def urandom(size: int) -> bytes: ...
else:
    def urandom(n: int) -> bytes: ...

if sys.version_info >= (3, 7):
    def register_at_fork(func: Callable[..., object], when: str) -> None: ...
