/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;

public class PatternSet
implements Serializable,
Cloneable,
InputLocationTracker {
    private List<String> includes;
    private List<String> excludes;
    private Map<Object, InputLocation> locations;

    public void addExclude(String string2) {
        this.getExcludes().add(string2);
    }

    public void addInclude(String string2) {
        this.getIncludes().add(string2);
    }

    public PatternSet clone() {
        try {
            PatternSet copy2 = (PatternSet)super.clone();
            if (this.includes != null) {
                copy2.includes = new ArrayList<String>();
                copy2.includes.addAll(this.includes);
            }
            if (this.excludes != null) {
                copy2.excludes = new ArrayList<String>();
                copy2.excludes.addAll(this.excludes);
            }
            if (copy2.locations != null) {
                copy2.locations = new LinkedHashMap<Object, InputLocation>(copy2.locations);
            }
            return copy2;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public List<String> getExcludes() {
        if (this.excludes == null) {
            this.excludes = new ArrayList<String>();
        }
        return this.excludes;
    }

    public List<String> getIncludes() {
        if (this.includes == null) {
            this.includes = new ArrayList<String>();
        }
        return this.includes;
    }

    @Override
    public InputLocation getLocation(Object key2) {
        return this.locations != null ? this.locations.get(key2) : null;
    }

    public void removeExclude(String string2) {
        this.getExcludes().remove(string2);
    }

    public void removeInclude(String string2) {
        this.getIncludes().remove(string2);
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    @Override
    public void setLocation(Object key2, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key2, location);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("PatternSet [includes: {");
        for (String str2 : this.getIncludes()) {
            sb.append(str2).append(", ");
        }
        if (sb.substring(sb.length() - 2).equals(", ")) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append("}, excludes: {");
        for (String str2 : this.getExcludes()) {
            sb.append(str2).append(", ");
        }
        if (sb.substring(sb.length() - 2).equals(", ")) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append("}]");
        return sb.toString();
    }
}

