// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * The node observer interface. Observers should implement this
 * interface to receive information about the state of the IceGrid
 * nodes.
 *
 **/
public interface _NodeObserverOperationsNC
{
    /**
     * The <tt>nodeInit</tt> operation indicates the current state
     * of nodes. It is called after the registration of an observer.
     *
     * @param nodes The current state of the nodes.
     *
     **/
    void nodeInit(NodeDynamicInfo[] nodes);

    /**
     * The <tt>nodeUp</tt> operation is called to notify an observer that a node
     * came up.
     *
     * @param node The node state.
     *
     **/
    void nodeUp(NodeDynamicInfo node);

    /**
     * The <tt>nodeDown</tt> operation is called to notify an observer that a node
     * went down.
     *
     * @param name The node name.
     *
     **/
    void nodeDown(String name);

    /**
     * The <tt>updateServer</tt> operation is called to notify an observer that
     * the state of a server changed.
     *
     * @param node The node hosting the server.
     *
     * @param updatedInfo The new server state.
     *
     **/
    void updateServer(String node, ServerDynamicInfo updatedInfo);

    /**
     * The <tt>updateAdapter</tt> operation is called to notify an observer that
     * the state of an adapter changed.
     *
     * @param node The node hosting the adapter.
     *
     * @param updatedInfo The new adapter state.
     *
     **/
    void updateAdapter(String node, AdapterDynamicInfo updatedInfo);
}
