##  <#GAPDoc Label="Saturate:example">
##  <Example><![CDATA[
##  gap> ZZ := HomalgRingOfIntegers( );
##  Z
##  gap> Display( ZZ );
##  <An internal ring>
##  gap> m := LeftSubmodule( "2", ZZ );
##  <A principal (left) ideal given by a cyclic generator>
##  gap> Display( m );
##  [ [  2 ] ]
##  
##  A (left) ideal generated by the entry of the above matrix
##  gap> J := LeftSubmodule( "3", ZZ );
##  <A principal (left) ideal given by a cyclic generator>
##  gap> Display( J );
##  [ [  3 ] ]
##  
##  A (left) ideal generated by the entry of the above matrix
##  gap> I := Intersect( J, m^3 );
##  <A principal (left) ideal given by a cyclic generator>
##  gap> Display( I );
##  [ [  24 ] ]
##  
##  A (left) ideal generated by the entry of the above matrix
##  gap> Im := SubobjectQuotient( I, m );
##  <A principal (left) ideal of rank 1 given by a free generator>
##  gap> Display( Im );
##  [ [  -12 ] ]
##  
##  A (left) ideal generated by the entry of the above matrix
##  gap> I_m := Saturate( I, m );
##  <A principal (left) ideal of rank 1 given by a free generator>
##  gap> Display( I_m );
##  [ [  -3 ] ]
##  
##  A (left) ideal generated by the entry of the above matrix
##  gap> I_m = J;
##  true
##  ]]></Example>
##  <#/GAPDoc>

LoadPackage( "Modules" );

ZZ := HomalgRingOfIntegers( );

m := LeftSubmodule( "2", ZZ );

J := LeftSubmodule( "3", ZZ );

I := Intersect( J, m^3 );

Im := SubobjectQuotient( I, m );

I_m := Saturate( I, m );
