/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IcePatch2;

import com.zeroc.Ice.Current;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.UserException;
import com.zeroc.IceInternal.Incoming;
import com.zeroc.IcePatch2.ByteSeqSeqHelper;
import com.zeroc.IcePatch2.FileAccessException;
import com.zeroc.IcePatch2.FileInfo;
import com.zeroc.IcePatch2.FileInfoSeqHelper;
import com.zeroc.IcePatch2.FileSizeRangeException;
import com.zeroc.IcePatch2.LargeFileInfo;
import com.zeroc.IcePatch2.LargeFileInfoSeqHelper;
import com.zeroc.IcePatch2.PartitionOutOfRangeException;
import java.util.Arrays;
import java.util.concurrent.CompletionStage;

public interface FileServer
extends Object {
    public static final String[] _iceIds;
    public static final String[] _iceOps;

    @Deprecated
    public FileInfo[] getFileInfoSeq(int var1, Current var2) throws FileSizeRangeException, PartitionOutOfRangeException;

    public LargeFileInfo[] getLargeFileInfoSeq(int var1, Current var2) throws PartitionOutOfRangeException;

    public byte[][] getChecksumSeq(Current var1);

    public byte[] getChecksum(Current var1);

    @Deprecated
    public CompletionStage<byte[]> getFileCompressedAsync(String var1, int var2, int var3, Current var4) throws FileAccessException, FileSizeRangeException;

    public CompletionStage<byte[]> getLargeFileCompressedAsync(String var1, long var2, int var4, Current var5) throws FileAccessException;

    @Override
    default public String[] ice_ids(Current current) {
        return _iceIds;
    }

    @Override
    default public String ice_id(Current current) {
        return FileServer.ice_staticId();
    }

    public static String ice_staticId() {
        return "::IcePatch2::FileServer";
    }

    @Deprecated
    public static CompletionStage<OutputStream> _iceD_getFileInfoSeq(FileServer obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        int iceP_partition = istr.readInt();
        inS.endReadParams();
        FileInfo[] ret = obj.getFileInfoSeq(iceP_partition, current);
        OutputStream ostr = inS.startWriteParams();
        FileInfoSeqHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getLargeFileInfoSeq(FileServer obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        int iceP_partition = istr.readInt();
        inS.endReadParams();
        LargeFileInfo[] ret = obj.getLargeFileInfoSeq(iceP_partition, current);
        OutputStream ostr = inS.startWriteParams();
        LargeFileInfoSeqHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getChecksumSeq(FileServer obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        byte[][] ret = obj.getChecksumSeq(current);
        OutputStream ostr = inS.startWriteParams();
        ByteSeqSeqHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getChecksum(FileServer obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        byte[] ret = obj.getChecksum(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeByteSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    @Deprecated
    public static CompletionStage<OutputStream> _iceD_getFileCompressed(FileServer obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_path = istr.readString();
        int iceP_pos = istr.readInt();
        int iceP_num = istr.readInt();
        inS.endReadParams();
        return inS.setResultFuture(obj.getFileCompressedAsync(iceP_path, iceP_pos, iceP_num, current), (ostr, ret) -> ostr.writeByteSeq((byte[])ret));
    }

    public static CompletionStage<OutputStream> _iceD_getLargeFileCompressed(FileServer obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_path = istr.readString();
        long iceP_pos = istr.readLong();
        int iceP_num = istr.readInt();
        inS.endReadParams();
        return inS.setResultFuture(obj.getLargeFileCompressedAsync(iceP_path, iceP_pos, iceP_num, current), (ostr, ret) -> ostr.writeByteSeq((byte[])ret));
    }

    @Override
    default public CompletionStage<OutputStream> _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_iceOps, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return FileServer._iceD_getChecksum(this, in, current);
            }
            case 1: {
                return FileServer._iceD_getChecksumSeq(this, in, current);
            }
            case 2: {
                return FileServer._iceD_getFileCompressed(this, in, current);
            }
            case 3: {
                return FileServer._iceD_getFileInfoSeq(this, in, current);
            }
            case 4: {
                return FileServer._iceD_getLargeFileCompressed(this, in, current);
            }
            case 5: {
                return FileServer._iceD_getLargeFileInfoSeq(this, in, current);
            }
            case 6: {
                return Object._iceD_ice_id(this, in, current);
            }
            case 7: {
                return Object._iceD_ice_ids(this, in, current);
            }
            case 8: {
                return Object._iceD_ice_isA(this, in, current);
            }
            case 9: {
                return Object._iceD_ice_ping(this, in, current);
            }
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        _iceIds = new String[]{"::Ice::Object", "::IcePatch2::FileServer"};
        _iceOps = new String[]{"getChecksum", "getChecksumSeq", "getFileCompressed", "getFileInfoSeq", "getLargeFileCompressed", "getLargeFileInfoSeq", "ice_id", "ice_ids", "ice_isA", "ice_ping"};
    }
}

